/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.ui.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileHistoryFilterer
extends VcsLogFilterer {
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final IndexDataGetter myIndexDataGetter;
    @NotNull
    private final VirtualFile myRoot;

    public FileHistoryFilterer(@NotNull VcsLogData logData, @NotNull FilePath filePath) {
        super(logData.getLogProviders(), logData.getStorage(), logData.getTopCommitsCache(), logData.getCommitDetailsGetter(), logData.getIndex());
        this.myFilePath = filePath;
        this.myIndexDataGetter = (IndexDataGetter)ObjectUtils.assertNotNull((Object)this.myIndex.getDataGetter());
        this.myRoot = (VirtualFile)ObjectUtils.assertNotNull((Object)VcsUtil.getVcsRootFor((Project)logData.getProject(), (FilePath)this.myFilePath));
    }

    @Override
    @NotNull
    protected VisiblePack createVisiblePack(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @Nullable Set<Integer> matchingHeads, @Nullable Set<Integer> matchingCommits, boolean canRequestMore) {
        FileHistoryRefiner refiner;
        int row;
        if (!this.myIndex.isIndexed(this.myRoot) || matchingCommits == null) {
            return super.createVisiblePack(dataPack, sortType, filters, matchingHeads, matchingCommits, canRequestMore);
        }
        VisibleGraph<Integer> visibleGraph = this.createVisibleGraph(dataPack, sortType, matchingHeads, matchingCommits);
        IndexDataGetter.FileNamesData namesData = this.myIndexDataGetter.buildFileNamesData(this.myFilePath);
        if (namesData.hasRenames() && visibleGraph.getVisibleCommitCount() > 0 && visibleGraph instanceof VisibleGraphImpl && (row = this.getCurrentRow(dataPack, visibleGraph, namesData)) >= 0 && (refiner = new FileHistoryRefiner(visibleGraph, namesData)).refine(((VisibleGraphImpl)visibleGraph).getLinearGraph(), row, this.myFilePath)) {
            visibleGraph = this.createVisibleGraph(dataPack, sortType, matchingHeads, refiner.getMatchingCommits());
        }
        return new FileHistoryVisiblePack(dataPack, visibleGraph, canRequestMore, filters, namesData);
    }

    private int getCurrentRow(@NotNull DataPack pack, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull IndexDataGetter.FileNamesData fileIndexData) {
        CompressedRefs refs;
        Optional<VcsRef> headOptional;
        PermanentGraph<Integer> permanentGraph = pack.getPermanentGraph();
        if (permanentGraph instanceof PermanentGraphImpl && (headOptional = (refs = pack.getRefsModel().getAllRefsByRoot().get(this.myRoot)).streamBranches().filter(br -> br.getName().equals("HEAD")).findFirst()).isPresent()) {
            VcsRef head = headOptional.get();
            assert (head.getRoot().equals(this.myRoot));
            return this.findAncestorRowAffectingFile((PermanentGraphImpl)permanentGraph, head.getCommitHash(), visibleGraph, fileIndexData);
        }
        return -1;
    }

    private int findAncestorRowAffectingFile(@NotNull PermanentGraphImpl<Integer> permanentGraph, @NotNull Hash hash, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull IndexDataGetter.FileNamesData fileNamesData) {
        Ref result2 = new Ref();
        PermanentCommitsInfo commitsInfo = permanentGraph.getPermanentCommitsInfo();
        ReachableNodes reachableNodes = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentGraph.getLinearGraph()));
        reachableNodes.walk(Collections.singleton(((PermanentCommitsInfoImpl)commitsInfo).getNodeId(this.myStorage.getCommitIndex(hash, this.myRoot))), true, arg_0 -> this.lambda$findAncestorRowAffectingFile$1((PermanentCommitsInfoImpl)commitsInfo, fileNamesData, result2, arg_0));
        if (!result2.isNull()) {
            Integer rowIndex = visibleGraph.getVisibleRowIndex(((PermanentCommitsInfoImpl)commitsInfo).getCommitId((Integer)result2.get()));
            return (Integer)ObjectUtils.assertNotNull((Object)rowIndex);
        }
        return -1;
    }

    private /* synthetic */ boolean lambda$findAncestorRowAffectingFile$1(PermanentCommitsInfoImpl commitsInfo, @NotNull IndexDataGetter.FileNamesData fileNamesData, Ref result2, int currentNode) {
        int id = (Integer)commitsInfo.getCommitId(currentNode);
        if (fileNamesData.affects(id, this.myFilePath)) {
            result2.set((Object)currentNode);
            return false;
        }
        return true;
    }

    private static class FileHistoryRefiner
    implements DfsUtil.NodeVisitor {
        @NotNull
        private final VisibleGraph<Integer> myVisibleGraph;
        @NotNull
        private final IndexDataGetter.FileNamesData myNamesData;
        @NotNull
        private final Stack<FilePath> myPaths;
        @NotNull
        private final Set<Integer> myMatchingCommits;
        private boolean myWasChanged;

        public FileHistoryRefiner(@NotNull VisibleGraph<Integer> visibleGraph, @NotNull IndexDataGetter.FileNamesData namesData) {
            this.myVisibleGraph = visibleGraph;
            this.myNamesData = namesData;
            this.myPaths = new Stack();
            this.myMatchingCommits = ContainerUtil.newHashSet();
            this.myWasChanged = false;
        }

        public boolean refine(@NotNull LinearGraph graph, int row, @NotNull FilePath startPath) {
            this.myPaths.push((Object)startPath);
            DfsUtil.walk(LinearGraphUtils.asLiteLinearGraph(graph), row, this);
            return this.myWasChanged;
        }

        @NotNull
        public Set<Integer> getMatchingCommits() {
            return this.myMatchingCommits;
        }

        @Override
        public void enterNode(int node) {
            FilePath currentPath = (FilePath)this.myPaths.peek();
            Integer commit = (Integer)this.myVisibleGraph.getRowInfo(node).getCommit();
            FilePath previousPath = this.myNamesData.getPreviousPath(commit, currentPath);
            if (previousPath != null) {
                this.myMatchingCommits.add(commit);
                this.myPaths.push((Object)previousPath);
                this.myNamesData.retain(commit, currentPath, previousPath);
            } else {
                this.myNamesData.remove(commit);
                this.myWasChanged = true;
            }
        }

        @Override
        public void exitNode(int node) {
            Integer commit = (Integer)this.myVisibleGraph.getRowInfo(node).getCommit();
            if (this.myMatchingCommits.contains(commit)) {
                this.myPaths.pop();
            }
        }
    }
}

