/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.PaintParameters;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.LabelPainter;
import com.intellij.vcs.log.ui.render.RectanglePainter;
import com.intellij.vcs.log.ui.render.TooltipReferencesPanel;
import com.intellij.vcs.log.ui.render.TypeSafeTableCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphCommitCellRenderer
extends TypeSafeTableCellRenderer<GraphCommitCell> {
    private static final int MAX_GRAPH_WIDTH = 6;
    private static final int VERTICAL_PADDING = JBUI.scale((int)7);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final MyComponent myComponent;
    @NotNull
    private final MyComponent myTemplateComponent;
    @NotNull
    private final LabelPainter myTooltipPainter;

    public GraphCommitCellRenderer(@NotNull VcsLogData logData, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table, boolean compact, boolean showTagNames) {
        this.myLogData = logData;
        this.myGraphTable = table;
        this.myTooltipPainter = new LabelPainter(this.myLogData, compact, showTagNames);
        this.myComponent = new MyComponent(logData, painter, table, compact, showTagNames);
        this.myTemplateComponent = new MyComponent(logData, painter, table, compact, showTagNames);
    }

    protected SimpleColoredComponent getTableCellRendererComponentImpl(@NotNull JTable table, @NotNull GraphCommitCell value2, boolean isSelected, boolean hasFocus, int row, int column) {
        this.myComponent.customize(value2, isSelected, hasFocus, row, column);
        return this.myComponent;
    }

    @Nullable
    public JComponent getTooltip(@NotNull Object value2, @NotNull Point point, int row) {
        GraphCommitCell cell = (GraphCommitCell)this.getValue(value2);
        Collection<VcsRef> refs = cell.getRefsToThisCommit();
        if (!refs.isEmpty()) {
            double distance;
            this.myTooltipPainter.customizePainter((JComponent)((Object)this.myComponent), refs, this.myComponent.getBackground(), this.myComponent.getForeground(), true, this.getColumnWidth());
            if (this.myTooltipPainter.isLeftAligned() ? (distance = point.getX() - (double)this.myTemplateComponent.getGraphWidth(cell.getPrintElements())) > 0.0 && distance <= (double)this.getReferencesWidth(row, cell) : (double)this.getColumnWidth() - point.getX() <= (double)this.getReferencesWidth(row, cell)) {
                return new TooltipReferencesPanel(this.myLogData, this.myTooltipPainter, refs);
            }
        }
        return null;
    }

    public int getPreferredHeight() {
        return this.myComponent.getPreferredHeight();
    }

    private int getReferencesWidth(int row) {
        return this.getReferencesWidth(row, (GraphCommitCell)this.getValue(this.myGraphTable.getModel().getValueAt(row, 1)));
    }

    private int getReferencesWidth(int row, @NotNull GraphCommitCell cell) {
        Collection<VcsRef> refs = cell.getRefsToThisCommit();
        if (!refs.isEmpty()) {
            this.myTemplateComponent.customize(cell, this.myGraphTable.isRowSelected(row), this.myGraphTable.hasFocus(), row, 1);
            return this.myTemplateComponent.getReferencePainter().getSize().width;
        }
        return 0;
    }

    private int getGraphWidth(int row) {
        GraphCommitCell cell = (GraphCommitCell)this.getValue(this.myGraphTable.getModel().getValueAt(row, 1));
        return this.myTemplateComponent.getGraphWidth(cell.getPrintElements());
    }

    public int getTooltipXCoordinate(int row) {
        int referencesWidth = this.getReferencesWidth(row);
        if (referencesWidth != 0) {
            if (this.myComponent.getReferencePainter().isLeftAligned()) {
                return this.getGraphWidth(row) + referencesWidth / 2;
            }
            return this.getColumnWidth() - referencesWidth / 2;
        }
        return this.getColumnWidth() / 2;
    }

    private int getColumnWidth() {
        return this.myGraphTable.getColumnByModelIndex(1).getWidth();
    }

    public void setCompactReferencesView(boolean compact) {
        this.myComponent.getReferencePainter().setCompact(compact);
        this.myTemplateComponent.getReferencePainter().setCompact(compact);
    }

    public void setShowTagsNames(boolean showTagNames) {
        this.myComponent.getReferencePainter().setShowTagNames(showTagNames);
        this.myTemplateComponent.getReferencePainter().setShowTagNames(showTagNames);
    }

    private static class GraphImage {
        private final int myWidth;
        @NotNull
        private final Image myImage;

        GraphImage(@NotNull Image image, int width) {
            this.myImage = image;
            this.myWidth = width;
        }

        @NotNull
        Image getImage() {
            return this.myImage;
        }

        int getWidth() {
            return this.myWidth;
        }
    }

    private static class MyComponent
    extends SimpleColoredRenderer {
        private static final int DISPLAYED_MESSAGE_PART = 80;
        @NotNull
        private final VcsLogData myLogData;
        @NotNull
        private final VcsLogGraphTable myGraphTable;
        @NotNull
        private final GraphCellPainter myPainter;
        @NotNull
        private final IssueLinkRenderer myIssueLinkRenderer;
        @NotNull
        private final LabelPainter myReferencePainter;
        @NotNull
        protected GraphImage myGraphImage = new GraphImage(UIUtil.createImage((int)1, (int)1, (int)2), 0);
        @NotNull
        private Font myFont;
        private int myHeight;

        public MyComponent(@NotNull VcsLogData data, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table, boolean compact, boolean showTags) {
            this.myLogData = data;
            this.myPainter = painter;
            this.myGraphTable = table;
            this.myReferencePainter = new LabelPainter(this.myLogData, compact, showTags);
            this.myIssueLinkRenderer = new IssueLinkRenderer(this.myLogData.getProject(), (SimpleColoredComponent)this);
            this.myFont = RectanglePainter.getFont();
            this.myHeight = this.calculateHeight();
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            int referencesSize = this.myReferencePainter.isLeftAligned() ? 0 : this.myReferencePainter.getSize().width;
            return new Dimension(preferredSize.width + referencesSize, this.getPreferredHeight());
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int graphImageWidth = this.myGraphImage.getWidth();
            if (!this.myReferencePainter.isLeftAligned()) {
                int start = Math.max(graphImageWidth, this.getWidth() - this.myReferencePainter.getSize().width);
                this.myReferencePainter.paint((Graphics2D)g, start, 0, this.getHeight());
            } else {
                this.myReferencePainter.paint((Graphics2D)g, graphImageWidth, 0, this.getHeight());
            }
            UIUtil.drawImage((Graphics)g, (Image)this.myGraphImage.getImage(), (int)0, (int)0, null);
        }

        public void customize(@NotNull GraphCommitCell cell, boolean isSelected, boolean hasFocus, int row, int column) {
            this.clear();
            this.setPaintFocusBorder(false);
            this.acquireState((JTable)((Object)this.myGraphTable), isSelected, hasFocus, row, column);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            this.setBorder(null);
            this.myGraphImage = this.getGraphImage(cell.getPrintElements());
            SimpleTextAttributes style = this.myGraphTable.applyHighlighters((Component)((Object)this), row, column, hasFocus, isSelected);
            Collection<VcsRef> refs = cell.getRefsToThisCommit();
            Color baseForeground = (Color)ObjectUtils.assertNotNull((Object)this.myGraphTable.getBaseStyle(row, column, hasFocus, isSelected).getForeground());
            this.append("");
            if (this.myReferencePainter.isLeftAligned()) {
                this.myReferencePainter.customizePainter((JComponent)((Object)this), refs, this.getBackground(), baseForeground, isSelected, this.getAvailableWidth(column, this.myGraphImage.getWidth()));
                this.appendTextPadding(this.myGraphImage.getWidth() + this.myReferencePainter.getSize().width + LabelPainter.RIGHT_PADDING);
                this.appendText(cell, style, isSelected);
            } else {
                this.appendTextPadding(this.myGraphImage.getWidth());
                this.appendText(cell, style, isSelected);
                this.myReferencePainter.customizePainter((JComponent)((Object)this), refs, this.getBackground(), baseForeground, isSelected, this.getAvailableWidth(column, this.myGraphImage.getWidth()));
            }
        }

        private void appendText(@NotNull GraphCommitCell cell, @NotNull SimpleTextAttributes style, boolean isSelected) {
            this.myIssueLinkRenderer.appendTextWithLinks(StringUtil.replace((String)cell.getText(), (String)"\t", (String)" ").trim(), style);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((Object)this.myGraphTable), (SimpleColoredComponent)this, (boolean)false, (boolean)isSelected);
        }

        private int getAvailableWidth(int column, int graphWidth) {
            int textAndLabelsWidth = this.myGraphTable.getColumnModel().getColumn(column).getWidth() - graphWidth;
            int freeSpace = textAndLabelsWidth - super.getPreferredSize().width;
            int allowedSpace = this.myReferencePainter.isCompact() ? Math.min(freeSpace, textAndLabelsWidth / 3) : Math.max(freeSpace, Math.max(textAndLabelsWidth / 2, textAndLabelsWidth - JBUI.scale((int)80)));
            return Math.max(0, allowedSpace);
        }

        private int calculateHeight() {
            return Math.max(this.myReferencePainter.getSize().height, this.getFontMetrics(this.myFont).getHeight() + VERTICAL_PADDING);
        }

        public int getPreferredHeight() {
            Font font = RectanglePainter.getFont();
            if (this.myFont != font) {
                this.myFont = font;
                this.myHeight = this.calculateHeight();
            }
            return this.myHeight;
        }

        @NotNull
        private GraphImage getGraphImage(@NotNull Collection<? extends PrintElement> printElements) {
            double maxIndex = this.getMaxGraphElementIndex(printElements);
            BufferedImage image = UIUtil.createImage((int)((int)((double)PaintParameters.getNodeWidth(this.myGraphTable.getRowHeight()) * (maxIndex + 2.0))), (int)this.myGraphTable.getRowHeight(), (int)2);
            Graphics2D g2 = image.createGraphics();
            this.myPainter.draw(g2, printElements);
            int width = (int)(maxIndex * (double)PaintParameters.getNodeWidth(this.myGraphTable.getRowHeight()));
            return new GraphImage(image, width);
        }

        private int getGraphWidth(@NotNull Collection<? extends PrintElement> printElements) {
            double maxIndex = this.getMaxGraphElementIndex(printElements);
            return (int)(maxIndex * (double)PaintParameters.getNodeWidth(this.myGraphTable.getRowHeight()));
        }

        private double getMaxGraphElementIndex(@NotNull Collection<? extends PrintElement> printElements) {
            double maxIndex = 0.0;
            for (PrintElement printElement : printElements) {
                maxIndex = Math.max(maxIndex, (double)printElement.getPositionInCurrentRow());
                if (!(printElement instanceof EdgePrintElement)) continue;
                maxIndex = Math.max(maxIndex, (double)(printElement.getPositionInCurrentRow() + ((EdgePrintElement)printElement).getPositionInOtherRow()) / 2.0);
            }
            maxIndex += 1.0;
            maxIndex = Math.max(maxIndex, (double)Math.min(6, this.myGraphTable.getVisibleGraph().getRecommendedWidth()));
            return maxIndex;
        }

        @NotNull
        public LabelPainter getReferencePainter() {
            return this.myReferencePainter;
        }
    }
}

