/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.RectanglePainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPainter {
    public static final int TOP_TEXT_PADDING = JBUI.scale((int)1);
    public static final int BOTTOM_TEXT_PADDING = JBUI.scale((int)2);
    public static final int RIGHT_PADDING = JBUI.scale((int)4);
    public static final int LEFT_PADDING = JBUI.scale((int)2);
    public static final int COMPACT_MIDDLE_PADDING = JBUI.scale((int)2);
    public static final int MIDDLE_PADDING = JBUI.scale((int)12);
    private static final int MAX_LENGTH = 22;
    private static final String THREE_DOTS = "...";
    private static final String TWO_DOTS = "..";
    private static final String SEPARATOR = "/";
    private static final JBColor BACKGROUND = new JBColor(Color.BLACK, Color.WHITE);
    private static final float BALANCE = 0.08f;
    private static final JBColor TEXT_COLOR = new JBColor(new Color(0x7A7A7A), new Color(0x909090));
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private List<Pair<String, LabelIcon>> myLabels = ContainerUtil.newArrayList();
    private int myHeight = JBUI.scale((int)22);
    private int myWidth = 0;
    @NotNull
    private Color myBackground = UIUtil.getTableBackground();
    @Nullable
    private Color myGreyBackground = null;
    @NotNull
    private Color myForeground = UIUtil.getTableForeground();
    private boolean myCompact;
    private boolean myShowTagNames;

    public LabelPainter(@NotNull VcsLogData data, boolean compact, boolean showTagNames) {
        this.myLogData = data;
        this.myCompact = compact;
        this.myShowTagNames = showTagNames;
    }

    @Nullable
    public static VcsLogRefManager getRefManager(@NotNull VcsLogData logData, @NotNull Collection<VcsRef> references) {
        if (!references.isEmpty()) {
            VirtualFile root = ((VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(references))).getRoot();
            return logData.getLogProvider(root).getReferenceManager();
        }
        return null;
    }

    public void customizePainter(@NotNull JComponent component, @NotNull Collection<VcsRef> references, @NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth) {
        this.myBackground = background;
        this.myForeground = isSelected ? foreground : TEXT_COLOR;
        FontMetrics metrics = component.getFontMetrics(this.getReferenceFont());
        this.myHeight = metrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING;
        VcsLogRefManager manager = LabelPainter.getRefManager(this.myLogData, references);
        List refGroups = manager == null ? ContainerUtil.emptyList() : manager.groupForTable(references, this.myCompact, this.myShowTagNames);
        this.myGreyBackground = LabelPainter.calculateGreyBackground(refGroups, background, isSelected, this.myCompact);
        Pair<List<Pair<String, LabelIcon>>, Integer> presentation = LabelPainter.calculatePresentation(refGroups, metrics, this.myHeight, this.myGreyBackground != null ? this.myGreyBackground : this.myBackground, availableWidth, this.myCompact);
        this.myLabels = (List)presentation.first;
        this.myWidth = (Integer)presentation.second;
    }

    @NotNull
    private static Pair<List<Pair<String, LabelIcon>>, Integer> calculatePresentation(@NotNull List<RefGroup> refGroups, @NotNull FontMetrics fontMetrics, int height, @NotNull Color background, int availableWidth, boolean compact) {
        int width = LEFT_PADDING + RIGHT_PADDING;
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            return Pair.create((Object)labels, (Object)width);
        }
        if (compact) {
            return LabelPainter.calculateCompactPresentation(refGroups, fontMetrics, height, background, availableWidth);
        }
        return LabelPainter.calculateLongPresentation(refGroups, fontMetrics, height, background, availableWidth);
    }

    @NotNull
    private static Pair<List<Pair<String, LabelIcon>>, Integer> calculateCompactPresentation(@NotNull List<RefGroup> refGroups, @NotNull FontMetrics fontMetrics, int height, @NotNull Color background, int availableWidth) {
        int width = LEFT_PADDING + RIGHT_PADDING;
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            return Pair.create((Object)labels, (Object)width);
        }
        for (RefGroup group : refGroups) {
            List colors = group.getColors();
            LabelIcon labelIcon = new LabelIcon(height, background, colors.toArray(new Color[colors.size()]));
            int newWidth = width + labelIcon.getIconWidth() + (group != ContainerUtil.getLastItem(refGroups) ? COMPACT_MIDDLE_PADDING : 0);
            String text = LabelPainter.shortenRefName(group.getName(), fontMetrics, availableWidth - newWidth);
            labels.add(Pair.create((Object)text, (Object)labelIcon));
            width = newWidth += fontMetrics.stringWidth(text);
        }
        return Pair.create((Object)labels, (Object)width);
    }

    @NotNull
    private static Pair<List<Pair<String, LabelIcon>>, Integer> calculateLongPresentation(@NotNull List<RefGroup> refGroups, @NotNull FontMetrics fontMetrics, int height, @NotNull Color background, int availableWidth) {
        int width = LEFT_PADDING + RIGHT_PADDING;
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            return Pair.create((Object)labels, (Object)width);
        }
        for (int i2 = 0; i2 < refGroups.size(); ++i2) {
            String text;
            RefGroup group = refGroups.get(i2);
            int doNotFitWidth = 0;
            if (i2 < refGroups.size() - 1) {
                LabelIcon lastIcon = new LabelIcon(height, background, LabelPainter.getColors(refGroups.subList(i2 + 1, refGroups.size())));
                doNotFitWidth = lastIcon.getIconWidth();
            }
            List colors = group.getColors();
            LabelIcon labelIcon = new LabelIcon(height, background, colors.toArray(new Color[colors.size()]));
            int newWidth = width + labelIcon.getIconWidth() + (i2 != refGroups.size() - 1 ? MIDDLE_PADDING : 0);
            if (availableWidth - (newWidth += fontMetrics.stringWidth(text = LabelPainter.getGroupText(group, fontMetrics, availableWidth - newWidth - doNotFitWidth))) - doNotFitWidth < 0) {
                LabelIcon lastIcon = new LabelIcon(height, background, LabelPainter.getColors(refGroups.subList(i2, refGroups.size())));
                String name = labels.isEmpty() ? text : "";
                labels.add(Pair.create((Object)name, (Object)lastIcon));
                width += fontMetrics.stringWidth(name) + lastIcon.getIconWidth();
                break;
            }
            labels.add(Pair.create((Object)text, (Object)labelIcon));
            width = newWidth;
        }
        return Pair.create((Object)labels, (Object)width);
    }

    @NotNull
    private static Color[] getColors(@NotNull Collection<RefGroup> groups) {
        LinkedHashMap usedColors = ContainerUtil.newLinkedHashMap();
        for (RefGroup group : groups) {
            List colors = group.getColors();
            for (Color color : colors) {
                Integer count = (Integer)usedColors.get(color);
                if (count == null) {
                    count = 0;
                }
                usedColors.put(color, count + 1);
            }
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Map.Entry entry : usedColors.entrySet()) {
            result2.add(entry.getKey());
            if ((Integer)entry.getValue() <= 1) continue;
            result2.add(entry.getKey());
        }
        return result2.toArray(new Color[result2.size()]);
    }

    @NotNull
    private static String getGroupText(@NotNull RefGroup group, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (!group.isExpanded()) {
            return LabelPainter.shortenRefName(group.getName(), fontMetrics, availableWidth);
        }
        String text = "";
        String remainder = ", ...";
        String separator = ", ";
        int remainderWidth = fontMetrics.stringWidth(remainder);
        int separatorWidth = fontMetrics.stringWidth(separator);
        for (int i2 = 0; i2 < group.getRefs().size(); ++i2) {
            String refName;
            int refNameWidth;
            boolean firstRef;
            boolean lastRef = i2 == group.getRefs().size() - 1;
            int width = availableWidth - (lastRef ? 0 : remainderWidth) - ((firstRef = i2 == 0) ? 0 : separatorWidth);
            if (width - (refNameWidth = fontMetrics.stringWidth(refName = LabelPainter.shortenRefName(((VcsRef)group.getRefs().get(i2)).getName(), fontMetrics, width))) < 0 && !firstRef) {
                text = text + remainder;
                break;
            }
            text = text + (firstRef ? "" : separator) + refName;
            availableWidth -= (firstRef ? 0 : separatorWidth) + refNameWidth;
        }
        return text;
    }

    @Nullable
    private static Color calculateGreyBackground(@NotNull List<RefGroup> refGroups, @NotNull Color background, boolean isSelected, boolean isCompact) {
        if (isSelected) {
            return null;
        }
        if (!isCompact) {
            return ColorUtil.mix((Color)background, (Color)BACKGROUND, (double)0.08f);
        }
        for (RefGroup group : refGroups) {
            boolean paintGreyBackground;
            if (group.isExpanded()) {
                paintGreyBackground = ContainerUtil.find((Iterable)group.getRefs(), ref -> !ref.getName().isEmpty()) != null;
            } else {
                boolean bl = paintGreyBackground = !group.getName().isEmpty();
            }
            if (!paintGreyBackground) continue;
            return ColorUtil.mix((Color)background, (Color)BACKGROUND, (double)0.08f);
        }
        return null;
    }

    @NotNull
    private static String shortenRefName(@NotNull String refName, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (fontMetrics.stringWidth(refName) > availableWidth && refName.length() > 22) {
            int separatorIndex = refName.indexOf(SEPARATOR);
            if (separatorIndex > TWO_DOTS.length()) {
                refName = TWO_DOTS + refName.substring(separatorIndex);
            }
            if (fontMetrics.stringWidth(refName) <= availableWidth) {
                return refName;
            }
            if (availableWidth > 0) {
                for (int i2 = refName.length(); i2 > 22; --i2) {
                    String result2 = StringUtil.shortenTextWithEllipsis((String)refName, (int)i2, (int)0, (String)THREE_DOTS);
                    if (fontMetrics.stringWidth(result2) > availableWidth) continue;
                    return result2;
                }
            }
            return StringUtil.shortenTextWithEllipsis((String)refName, (int)22, (int)0, (String)THREE_DOTS);
        }
        return refName;
    }

    public void paint(@NotNull Graphics2D g2, int x, int y, int height) {
        if (this.myLabels.isEmpty()) {
            return;
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setFont(this.getReferenceFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int baseLine = SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        g2.setColor(this.myBackground);
        g2.fillRect(x, y, this.myWidth, height);
        if (this.myGreyBackground != null && this.myCompact) {
            g2.setColor(this.myGreyBackground);
            g2.fillRect(x, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING, this.myWidth, fontMetrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING);
        }
        x += LEFT_PADDING;
        for (Pair<String, LabelIcon> label : this.myLabels) {
            LabelIcon icon = (LabelIcon)label.second;
            String text = (String)label.first;
            if (this.myGreyBackground != null && !this.myCompact) {
                g2.setColor(this.myGreyBackground);
                g2.fill(new RoundRectangle2D.Double(x - LEFT_PADDING, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING, icon.getIconWidth() + fontMetrics.stringWidth(text) + 3 * LEFT_PADDING, fontMetrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING, RectanglePainter.LABEL_ARC, RectanglePainter.LABEL_ARC));
            }
            icon.paintIcon(null, g2, x, y + (height - icon.getIconHeight()) / 2);
            g2.setColor(this.myForeground);
            g2.drawString(text, x += icon.getIconWidth(), y + baseLine);
            x += fontMetrics.stringWidth(text) + (this.myCompact ? COMPACT_MIDDLE_PADDING : MIDDLE_PADDING);
        }
        config.restore();
    }

    public Dimension getSize() {
        if (this.myLabels.isEmpty()) {
            return new Dimension();
        }
        return new Dimension(this.myWidth, this.myHeight);
    }

    public boolean isLeftAligned() {
        return Registry.is((String)"vcs.log.labels.left.aligned");
    }

    public Font getReferenceFont() {
        Font font = RectanglePainter.getFont();
        return font.deriveFont((float)font.getSize() - 1.0f);
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    public void setShowTagNames(boolean showTagNames) {
        this.myShowTagNames = showTagNames;
    }

    public void setCompact(boolean compact) {
        this.myCompact = compact;
    }
}

