/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;

public class RectanglePainter {
    protected static final int TEXT_PADDING_X = JBUI.scale((int)5);
    public static final int TOP_TEXT_PADDING = JBUI.scale((int)2);
    public static final int BOTTOM_TEXT_PADDING = JBUI.scale((int)1);
    public static final int LABEL_ARC = JBUI.scale((int)6);
    private final boolean mySquare;

    public RectanglePainter(boolean square) {
        this.mySquare = square;
    }

    public static Font getFont() {
        return UIUtil.getLabelFont();
    }

    protected Font getLabelFont() {
        return RectanglePainter.getFont();
    }

    public void paint(@NotNull Graphics2D g2, @NotNull String text, int paddingX, int paddingY, @NotNull Color color) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setFont(this.getLabelFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int width = fontMetrics.stringWidth(text) + 2 * TEXT_PADDING_X;
        int height = fontMetrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING;
        g2.setColor(color);
        if (this.mySquare) {
            g2.fillRect(paddingX, paddingY, width, height);
        } else {
            g2.fill(new RoundRectangle2D.Double(paddingX, paddingY, width, height, LABEL_ARC, LABEL_ARC));
        }
        g2.setColor((Color)JBColor.BLACK);
        int x = paddingX + TEXT_PADDING_X;
        int y = paddingY + SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        g2.drawString(text, x, y);
        config.restore();
    }

    public Dimension calculateSize(@NotNull String text, @NotNull FontMetrics metrics) {
        int width = metrics.stringWidth(text) + 2 * TEXT_PADDING_X;
        int height = metrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING;
        return new Dimension(width, height);
    }
}

