/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.frame.ReferencesPanel;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.LabelPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TooltipReferencesPanel
extends ReferencesPanel {
    private static final int REFS_LIMIT = 10;
    @NotNull
    private final LabelPainter myReferencePainter;
    private boolean myHasGroupWithMultipleRefs;

    public TooltipReferencesPanel(@NotNull VcsLogData logData, @NotNull LabelPainter referencePainter, @NotNull Collection<VcsRef> refs) {
        super((LayoutManager)new VerticalFlowLayout(JBUI.scale((int)4), JBUI.scale((int)0)), 10);
        this.myReferencePainter = referencePainter;
        VirtualFile root = ((VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(refs))).getRoot();
        this.setReferences(ContainerUtil.sorted(refs, (Comparator)logData.getLogProvider(root).getReferenceManager().getLabelsOrderComparator()));
    }

    @Override
    public void update() {
        this.myHasGroupWithMultipleRefs = false;
        for (Map.Entry typeAndRefs : this.myGroupedVisibleReferences.entrySet()) {
            if (((Collection)typeAndRefs.getValue()).size() <= 1) continue;
            this.myHasGroupWithMultipleRefs = true;
        }
        super.update();
    }

    @Override
    @NotNull
    protected Font getLabelsFont() {
        return this.myReferencePainter.getReferenceFont();
    }

    @Override
    @Nullable
    protected Icon createIcon(@NotNull VcsRefType type2, @NotNull Collection<VcsRef> refs, int refIndex, int height) {
        if (refIndex == 0) {
            Color[] colorArray;
            Color color = type2.getBackgroundColor();
            Color color2 = this.getBackground();
            if (refs.size() > 1) {
                Color[] colorArray2 = new Color[2];
                colorArray2[0] = color;
                colorArray = colorArray2;
                colorArray2[1] = color;
            } else {
                Color[] colorArray3 = new Color[1];
                colorArray = colorArray3;
                colorArray3[0] = color;
            }
            return new LabelIcon(height, color2, colorArray){

                @Override
                public int getIconWidth() {
                    return this.getWidth(TooltipReferencesPanel.this.myHasGroupWithMultipleRefs ? 2 : 1);
                }
            };
        }
        return TooltipReferencesPanel.createEmptyIcon(height);
    }

    @NotNull
    private static Icon createEmptyIcon(int height) {
        return EmptyIcon.create((int)LabelIcon.getWidth(height, 2), (int)height);
    }

    @Override
    @NotNull
    protected JBLabel createRestLabel(int restSize) {
        String gray = ColorUtil.toHex((Color)UIManager.getColor("Button.disabledText"));
        return this.createLabel("<html><font color=\"#" + gray + "\">... " + restSize + " more in details pane</font></html>", TooltipReferencesPanel.createEmptyIcon(this.getIconHeight()));
    }
}

