/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableModel
extends AbstractTableModel {
    public static final int ROOT_COLUMN = 0;
    public static final int COMMIT_COLUMN = 1;
    public static final int AUTHOR_COLUMN = 2;
    public static final int DATE_COLUMN = 3;
    private static final int COLUMN_COUNT = 4;
    private static final String[] COLUMN_NAMES = new String[]{"", "Subject", "Author", "Date"};
    private static final int UP_PRELOAD_COUNT = 20;
    private static final int DOWN_PRELOAD_COUNT = 40;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    protected final AbstractVcsLogUi myUi;
    @NotNull
    protected VisiblePack myDataPack;
    private boolean myMoreRequested;

    public GraphTableModel(@NotNull VisiblePack dataPack, @NotNull VcsLogData logData, @NotNull AbstractVcsLogUi ui) {
        this.myLogData = logData;
        this.myUi = ui;
        this.myDataPack = dataPack;
    }

    @Override
    public int getRowCount() {
        return this.myDataPack.getVisibleGraph().getVisibleCommitCount();
    }

    @NotNull
    public VirtualFile getRoot(int rowIndex) {
        return this.myDataPack.getRoot(rowIndex);
    }

    @NotNull
    public Integer getIdAtRow(int row) {
        return (Integer)this.myDataPack.getVisibleGraph().getRowInfo(row).getCommit();
    }

    @Nullable
    public CommitId getCommitIdAtRow(int row) {
        return this.myLogData.getCommitId(this.getIdAtRow(row));
    }

    public int getRowOfCommit(@NotNull Hash hash, @NotNull VirtualFile root) {
        int commitIndex = this.myLogData.getCommitIndex(hash, root);
        return ContainerUtil.indexOf(VcsLogUtil.getVisibleCommits(this.myDataPack.getVisibleGraph()), i2 -> i2 == commitIndex);
    }

    public int getRowOfCommitByPartOfHash(@NotNull String partialHash) {
        CommitIdByStringCondition hashByString = new CommitIdByStringCondition(partialHash);
        CommitId commitId = this.myLogData.getStorage().findCommitId((Condition<CommitId>)((Condition)commitId1 -> hashByString.value((CommitId)commitId1) && this.getRowOfCommit(commitId1.getHash(), commitId1.getRoot()) != -1));
        return commitId != null ? this.getRowOfCommit(commitId.getHash(), commitId.getRoot()) : -1;
    }

    @Override
    public final int getColumnCount() {
        return 4;
    }

    public void requestToLoadMore(@NotNull Runnable onLoaded) {
        this.myMoreRequested = true;
        this.myUi.getRefresher().moreCommitsNeeded(onLoaded);
        this.myUi.getTable().setPaintBusy(true);
    }

    @Override
    @NotNull
    public final Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount() - 1 && this.canRequestMore()) {
            this.requestToLoadMore(EmptyRunnable.INSTANCE);
        }
        VcsShortCommitDetails data = this.getShortDetails(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.getRoot(rowIndex);
            }
            case 1: {
                return new GraphCommitCell(data.getSubject(), this.getRefsAtRow(rowIndex), this.myDataPack.getVisibleGraph().getRowInfo(rowIndex).getPrintElements());
            }
            case 2: {
                String authorString = VcsUserUtil.getShortPresentation(data.getAuthor());
                return authorString + (VcsUserUtil.isSamePerson(data.getAuthor(), data.getCommitter()) ? "" : "*");
            }
            case 3: {
                if (data.getAuthorTime() < 0L) {
                    return "";
                }
                return DateFormatUtil.formatDateTime((long)data.getAuthorTime());
            }
        }
        throw new IllegalArgumentException("columnIndex is " + columnIndex + " > " + (this.getColumnCount() - 1));
    }

    public boolean canRequestMore() {
        return !this.myMoreRequested && this.myDataPack.canRequestMore();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return VirtualFile.class;
            }
            case 1: {
                return GraphCommitCell.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("columnIndex is " + column + " > " + (this.getColumnCount() - 1));
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public void setVisiblePack(@NotNull VisiblePack visiblePack) {
        this.myDataPack = visiblePack;
        this.myMoreRequested = false;
        this.fireTableDataChanged();
    }

    @NotNull
    public VisiblePack getVisiblePack() {
        return this.myDataPack;
    }

    @NotNull
    public VcsFullCommitDetails getFullDetails(int row) {
        return this.getDetails(row, this.myLogData.getCommitDetailsGetter());
    }

    @NotNull
    public VcsShortCommitDetails getShortDetails(int row) {
        return this.getDetails(row, this.myLogData.getMiniDetailsGetter());
    }

    @NotNull
    private <T extends VcsShortCommitDetails> T getDetails(int row, @NotNull DataGetter<T> dataGetter) {
        Iterable<Integer> iterable = this.createRowsIterable(row, 20, 40, this.getRowCount());
        return dataGetter.getCommitData(this.getIdAtRow(row), iterable);
    }

    @NotNull
    public Collection<VcsRef> getRefsAtRow(int row) {
        return ((RefsModel)this.myDataPack.getRefs()).refsToCommit(this.getIdAtRow(row));
    }

    @NotNull
    public List<VcsRef> getBranchesAtRow(int row) {
        return this.getRefsAtRow(row).stream().filter(ref -> ref.getType().isBranch()).collect(Collectors.toList());
    }

    @NotNull
    private Iterable<Integer> createRowsIterable(final int row, final int above, final int below, final int maxRows) {
        return () -> new Iterator<Integer>(){
            private int myRowIndex;
            {
                this.myRowIndex = Math.max(0, row - above);
            }

            @Override
            public boolean hasNext() {
                return this.myRowIndex < row + below && this.myRowIndex < maxRows;
            }

            @Override
            public Integer next() {
                int nextRow = this.myRowIndex++;
                return GraphTableModel.this.getIdAtRow(nextRow);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing elements is not supported.");
            }
        };
    }

    @NotNull
    public List<Integer> convertToCommitIds(@NotNull List<Integer> rows) {
        return ContainerUtil.map(rows, (Function)((NotNullFunction)this::getIdAtRow));
    }
}

