/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.graph.DefaultColorGenerator;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.paint.SimpleGraphCellPainter;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.table.GraphTableController;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.IndexSpeedSearch;
import com.intellij.vcs.log.ui.table.TableWithProgress;
import com.intellij.vcs.log.visible.VisiblePack;
import gnu.trove.TIntHashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogGraphTable
extends TableWithProgress
implements DataProvider,
CopyProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogGraphTable.class);
    public static final int ROOT_INDICATOR_WHITE_WIDTH = 5;
    private static final int ROOT_INDICATOR_WIDTH = 13;
    private static final int ROOT_NAME_MAX_WIDTH = 200;
    private static final int MAX_DEFAULT_AUTHOR_COLUMN_WIDTH = 300;
    private static final int MAX_ROWS_TO_CALC_WIDTH = 1000;
    @NotNull
    private final AbstractVcsLogUi myUi;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MyDummyTableCellEditor myDummyEditor = new MyDummyTableCellEditor();
    @NotNull
    private final TableCellRenderer myDummyRenderer = new DefaultTableCellRenderer();
    @NotNull
    private final GraphCommitCellRenderer myGraphCommitCellRenderer;
    @NotNull
    private final GraphTableController myController;
    @NotNull
    private final StringCellRenderer myStringCellRenderer;
    private boolean myAuthorColumnInitialized = false;
    @Nullable
    private Selection mySelection = null;
    @NotNull
    private final Collection<VcsLogHighlighter> myHighlighters = ContainerUtil.newArrayList();

    public VcsLogGraphTable(@NotNull AbstractVcsLogUi ui, @NotNull VcsLogData logData, @NotNull VisiblePack initialDataPack) {
        super(new GraphTableModel(initialDataPack, logData, ui));
        this.myUi = ui;
        this.myLogData = logData;
        SimpleGraphCellPainter graphCellPainter = new SimpleGraphCellPainter(new DefaultColorGenerator()){

            @Override
            protected int getRowHeight() {
                return VcsLogGraphTable.this.getRowHeight();
            }
        };
        this.myGraphCommitCellRenderer = new GraphCommitCellRenderer(logData, graphCellPainter, this, true, false);
        this.myStringCellRenderer = new StringCellRenderer();
        this.getEmptyText().setText("Changes Log");
        this.myLogData.getProgress().addProgressIndicatorListener(new MyProgressListener(), ui);
        this.initColumns();
        this.setDefaultRenderer(VirtualFile.class, new RootCellRenderer(this.myUi));
        this.setDefaultRenderer(GraphCommitCell.class, this.myGraphCommitCellRenderer);
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)this.myStringCellRenderer));
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.setTableHeader((JTableHeader)((Object)new InvisibleResizableHeader()));
        this.myController = new GraphTableController(this, ui, logData, graphCellPainter, this.myGraphCommitCellRenderer);
        this.getSelectionModel().addListSelectionListener(new MyListSelectionListener());
        this.getColumnModel().setColumnSelectionAllowed(false);
        ScrollingUtil.installActions((JTable)((Object)this), (boolean)false);
        new IndexSpeedSearch(this.myLogData.getProject(), this.myLogData.getIndex(), this){

            @Override
            protected boolean isSpeedSearchEnabled() {
                return VcsLogGraphTable.this.isSpeedSearchEnabled() && super.isSpeedSearchEnabled();
            }
        };
    }

    protected void initColumns() {
        this.setColumnModel(new MyTableColumnModel(this.myUi.getProperties()));
        this.createDefaultColumnsFromModel();
        this.setAutoCreateColumnsFromModel(false);
        this.onColumnOrderSettingChanged();
        this.setRootColumnSize();
        for (int column = 0; column < this.getColumnCount(); ++column) {
            this.getColumnByModelIndex(column).setResizable(column != 0);
        }
    }

    protected boolean isSpeedSearchEnabled() {
        return Registry.is((String)"vcs.log.speedsearch");
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permGraphChanged) {
        Selection previousSelection = this.getSelection();
        boolean filtersChanged = !this.getModel().getVisiblePack().getFilters().equals(visiblePack.getFilters());
        this.getModel().setVisiblePack(visiblePack);
        previousSelection.restore(visiblePack.getVisibleGraph(), true, permGraphChanged);
        for (VcsLogHighlighter highlighter : this.myHighlighters) {
            highlighter.update((VcsLogDataPack)visiblePack, permGraphChanged);
        }
        this.setPaintBusy(false);
        this.myAuthorColumnInitialized = this.myAuthorColumnInitialized && !filtersChanged;
        this.reLayout();
    }

    public void onColumnOrderSettingChanged() {
        if (this.myUi.getProperties().exists(CommonUiProperties.COLUMN_ORDER)) {
            List<Integer> columnOrder = this.myUi.getProperties().get(CommonUiProperties.COLUMN_ORDER);
            int columnCount = this.getColumnModel().getColumnCount();
            boolean dataCorrect = true;
            if (columnOrder.size() != columnCount) {
                dataCorrect = false;
            } else {
                for (int i2 = 0; i2 < columnCount; ++i2) {
                    Integer expectedColumnIndex = columnOrder.get(i2);
                    if (expectedColumnIndex < 0 || expectedColumnIndex >= columnCount) {
                        dataCorrect = false;
                        break;
                    }
                    if (expectedColumnIndex.intValue() == this.getColumnModel().getColumn(i2).getModelIndex()) continue;
                    int foundColumnIndex = -1;
                    for (int j = i2 + 1; j < columnCount; ++j) {
                        if (this.getColumnModel().getColumn(j).getModelIndex() != expectedColumnIndex.intValue()) continue;
                        foundColumnIndex = j;
                        break;
                    }
                    if (foundColumnIndex < 0) {
                        dataCorrect = false;
                        break;
                    }
                    ((MyTableColumnModel)this.getColumnModel()).moveWithoutChecks(foundColumnIndex, i2);
                }
            }
            if (!dataCorrect) {
                if (!columnOrder.isEmpty()) {
                    LOG.debug("Incorrect column order was saved in properties " + columnOrder + ", replacing it with current order.");
                }
                this.saveColumnOrderToSettings();
            }
        }
    }

    private void saveColumnOrderToSettings() {
        if (this.myUi.getProperties().exists(CommonUiProperties.COLUMN_ORDER)) {
            ArrayList columnOrder = ContainerUtil.newArrayList();
            for (int i2 = 0; i2 < this.getColumnModel().getColumnCount(); ++i2) {
                columnOrder.add(this.getColumnModel().getColumn(i2).getModelIndex());
            }
            this.myUi.getProperties().set(CommonUiProperties.COLUMN_ORDER, columnOrder);
        }
    }

    public void reLayout() {
        if (this.getTableHeader().getResizingColumn() == null) {
            this.updateAuthorAndDataWidth();
            super.doLayout();
            this.repaint();
        }
    }

    public void forceReLayout(int column) {
        if (column == 2) {
            this.myAuthorColumnInitialized = false;
        }
        this.reLayout();
    }

    public void doLayout() {
        if (this.getTableHeader().getResizingColumn() == null) {
            this.updateAuthorAndDataWidth();
        }
        super.doLayout();
    }

    public void resetColumnWidth(int column) {
        if (CommonUiProperties.getColumnWidth(this.myUi.getProperties(), column) != -1) {
            CommonUiProperties.saveColumnWidth(this.myUi.getProperties(), column, -1);
        } else {
            this.forceReLayout(column);
        }
    }

    private void updateAuthorAndDataWidth() {
        for (int i2 : new int[]{2, 3}) {
            int width = CommonUiProperties.getColumnWidth(this.myUi.getProperties(), i2);
            if (width <= 0 || width > this.getWidth()) {
                width = i2 != 2 || !this.myAuthorColumnInitialized ? this.getColumnWidthFromData(i2) : -1;
            }
            if (width <= 0 || width == this.getColumnByModelIndex(i2).getPreferredWidth()) continue;
            this.getColumnByModelIndex(i2).setPreferredWidth(width);
        }
        this.updateCommitColumnWidth();
    }

    private int getColumnWidthFromData(int i2) {
        Font tableFont = VcsLogGraphTable.getTableFont();
        if (i2 == 2) {
            int width = this.getColumnByModelIndex(i2).getPreferredWidth();
            if (this.getModel().getRowCount() > 0) {
                int maxRowsToCheck = Math.min(1000, this.getRowCount());
                int maxAuthorWidth = 0;
                int unloaded = 0;
                for (int row = 0; row < maxRowsToCheck; ++row) {
                    String value2 = this.getModel().getValueAt(row, 2).toString();
                    if (value2.isEmpty()) {
                        ++unloaded;
                        continue;
                    }
                    Font font = tableFont;
                    VcsLogHighlighter.TextStyle style = this.getStyle(row, this.convertColumnIndexToView(2), false, false).getTextStyle();
                    if (VcsLogHighlighter.TextStyle.BOLD.equals((Object)style)) {
                        font = tableFont.deriveFont(1);
                    } else if (VcsLogHighlighter.TextStyle.ITALIC.equals((Object)style)) {
                        font = tableFont.deriveFont(2);
                    }
                    maxAuthorWidth = Math.max(this.getFontMetrics(font).stringWidth(value2 + "*"), maxAuthorWidth);
                }
                width = Math.min(maxAuthorWidth + this.myStringCellRenderer.getHorizontalTextPadding(), JBUI.scale((int)300));
                if (unloaded * 2 <= maxRowsToCheck) {
                    this.myAuthorColumnInitialized = true;
                }
            }
            return width;
        }
        if (i2 == 3) {
            return this.getFontMetrics(VcsLogGraphTable.getTableFont().deriveFont(1)).stringWidth(DateFormatUtil.formatDateTime((Date)new Date())) + this.myStringCellRenderer.getHorizontalTextPadding();
        }
        throw new IllegalArgumentException("Can only calculate author or date columns width from data, yet given column " + i2);
    }

    @NotNull
    public TableColumn getColumnByModelIndex(int index) {
        return this.getColumnModel().getColumn(this.convertColumnIndexToView(index));
    }

    private static Font getTableFont() {
        return UIManager.getFont("Table.font");
    }

    private void updateCommitColumnWidth() {
        int size = this.getWidth();
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            if (i2 == 1) continue;
            TableColumn column = this.getColumnByModelIndex(i2);
            size -= column.getPreferredWidth();
        }
        TableColumn commitColumn = this.getColumnByModelIndex(1);
        commitColumn.setPreferredWidth(size);
    }

    private void setRootColumnSize() {
        int rootWidth;
        TableColumn column = this.getColumnByModelIndex(0);
        if (!this.myUi.isMultipleRoots()) {
            rootWidth = 0;
        } else if (!this.myUi.isShowRootNames()) {
            rootWidth = JBUI.scale((int)13);
        } else {
            int width = 0;
            for (VirtualFile file2 : this.myLogData.getRoots()) {
                Font tableFont = VcsLogGraphTable.getTableFont();
                width = Math.max(this.getFontMetrics(tableFont).stringWidth(file2.getName() + "  "), width);
            }
            rootWidth = Math.min(width, JBUI.scale((int)200));
        }
        column.setMinWidth(rootWidth);
        column.setMaxWidth(rootWidth);
        column.setPreferredWidth(rootWidth);
    }

    public void rootColumnUpdated() {
        this.setRootColumnSize();
        this.reLayout();
        this.repaint();
    }

    public String getToolTipText(@NotNull MouseEvent event) {
        Object at;
        int row = this.rowAtPoint(event.getPoint());
        int column = this.convertColumnIndexToModel(this.columnAtPoint(event.getPoint()));
        if (column < 0 || row < 0) {
            return null;
        }
        if (column == 0 && (at = this.getValueAt(row, column)) instanceof VirtualFile) {
            return "<html><b>" + ((VirtualFile)at).getPresentableUrl() + "</b><br/>Click to " + (this.myUi.isShowRootNames() ? "collapse" : "expand") + "</html>";
        }
        return null;
    }

    public void jumpToRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex <= this.getRowCount() - 1) {
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
            this.setRowSelectionInterval(rowIndex, rowIndex);
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length == 0 || selectedRows.length > 1000) {
                return null;
            }
            Set roots = ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row -> this.getModel().getRoot((int)row));
            if (roots.size() == 1) {
                return this.myLogData.getLogProvider((VirtualFile)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)roots))).getSupportedVcs();
            }
        } else {
            if (VcsLogDataKeys.VCS_LOG_BRANCHES.is(dataId)) {
                int[] selectedRows = this.getSelectedRows();
                if (selectedRows.length != 1) {
                    return null;
                }
                return this.getModel().getBranchesAtRow(selectedRows[0]);
            }
            if (VcsDataKeys.PRESET_COMMIT_MESSAGE.is(dataId)) {
                int[] selectedRows = this.getSelectedRows();
                if (selectedRows.length == 0) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (int i2 = 0; i2 < Math.min(1000, selectedRows.length); ++i2) {
                    sb.append(this.getModel().getValueAt(selectedRows[i2], 1).toString());
                    if (i2 == selectedRows.length - 1) continue;
                    sb.append("\n");
                }
                return sb.toString();
            }
        }
        return null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        StringBuilder sb = new StringBuilder();
        int[] selectedRows = this.getSelectedRows();
        for (int i2 = 0; i2 < Math.min(1000, selectedRows.length); ++i2) {
            int row = selectedRows[i2];
            for (int j = 1; j < this.getModel().getColumnCount(); ++j) {
                sb.append(this.getModel().getValueAt(row, j).toString());
                if (j >= this.getModel().getRowCount() - 1) continue;
                sb.append(" ");
            }
            if (i2 == selectedRows.length - 1) continue;
            sb.append("\n");
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return this.getSelectedRowCount() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }

    public void addHighlighter(@NotNull VcsLogHighlighter highlighter) {
        this.myHighlighters.add(highlighter);
    }

    public void removeHighlighter(@NotNull VcsLogHighlighter highlighter) {
        this.myHighlighters.remove(highlighter);
    }

    public void removeAllHighlighters() {
        this.myHighlighters.clear();
    }

    @NotNull
    public SimpleTextAttributes applyHighlighters(@NotNull Component rendererComponent, int row, int column, boolean hasFocus, boolean selected) {
        VcsLogHighlighter.VcsCommitStyle style = this.getStyle(row, column, hasFocus, selected);
        assert (style.getBackground() != null && style.getForeground() != null && style.getTextStyle() != null);
        rendererComponent.setBackground(style.getBackground());
        rendererComponent.setForeground(style.getForeground());
        switch (style.getTextStyle()) {
            case BOLD: {
                return SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            case ITALIC: {
                return SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
            }
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    public VcsLogHighlighter.VcsCommitStyle getBaseStyle(int row, int column, boolean hasFocus, boolean selected) {
        Component dummyRendererComponent = this.myDummyRenderer.getTableCellRendererComponent((JTable)((Object)this), "", selected, hasFocus, row, column);
        return VcsCommitStyleFactory.createStyle((Color)dummyRendererComponent.getForeground(), (Color)dummyRendererComponent.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
    }

    private VcsLogHighlighter.VcsCommitStyle getStyle(int row, int column, boolean hasFocus, boolean selected) {
        VcsLogHighlighter.VcsCommitStyle baseStyle = this.getBaseStyle(row, column, hasFocus, selected);
        VisibleGraph<Integer> visibleGraph = this.getVisibleGraph();
        if (row < 0 || row >= visibleGraph.getVisibleCommitCount()) {
            LOG.error("Visible graph has " + visibleGraph.getVisibleCommitCount() + " commits, yet we want row " + row);
            return baseStyle;
        }
        RowInfo rowInfo = visibleGraph.getRowInfo(row);
        VcsLogHighlighter.VcsCommitStyle defaultStyle = VcsCommitStyleFactory.createStyle((Color)(rowInfo.getRowType() == RowType.UNMATCHED ? JBColor.GRAY : baseStyle.getForeground()), (Color)baseStyle.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
        VcsShortCommitDetails details = this.myLogData.getMiniDetailsGetter().getCommitDataIfAvailable((Integer)rowInfo.getCommit());
        if (details == null) {
            return defaultStyle;
        }
        List styles = ContainerUtil.map(this.myHighlighters, highlighter -> highlighter.getStyle(details, selected));
        return VcsCommitStyleFactory.combine((Collection)ContainerUtil.append((List)styles, (Object[])new VcsLogHighlighter.VcsCommitStyle[]{defaultStyle}));
    }

    public void viewportSet(JViewport viewport) {
        viewport.addChangeListener(e -> {
            GraphTableModel model = this.getModel();
            Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)this));
            model.fireTableChanged(new TableModelEvent(model, (Integer)visibleRows.first - 1, (Integer)visibleRows.second, 0));
        });
    }

    public static JBColor getRootBackgroundColor(@NotNull VirtualFile root, @NotNull VcsLogColorManager colorManager) {
        return VcsLogColorManagerImpl.getBackgroundColor(colorManager.getRootColor(root));
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        Component layeredPane = UIUtil.findParentByCondition((Component)((Object)this), component -> component instanceof LoadingDecorator.CursorAware);
        if (layeredPane != null) {
            layeredPane.setCursor(cursor);
        }
    }

    @NotNull
    public GraphTableModel getModel() {
        return (GraphTableModel)super.getModel();
    }

    @NotNull
    public Selection getSelection() {
        if (this.mySelection == null) {
            this.mySelection = new Selection(this);
        }
        return this.mySelection;
    }

    public void handleAnswer(@Nullable GraphAnswer<Integer> answer, boolean dataCouldChange) {
        this.myController.handleGraphAnswer(answer, dataCouldChange, null, null);
    }

    public void showTooltip(int row) {
        this.myController.showTooltip(row);
    }

    public void setCompactReferencesView(boolean compact) {
        this.myGraphCommitCellRenderer.setCompactReferencesView(compact);
        this.repaint();
    }

    public void setShowTagNames(boolean showTagsNames) {
        this.myGraphCommitCellRenderer.setShowTagsNames(showTagsNames);
        this.repaint();
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        return this.getModel().getVisiblePack().getVisibleGraph();
    }

    public TableCellEditor getCellEditor() {
        return this.myDummyEditor;
    }

    public int getRowHeight() {
        return this.myGraphCommitCellRenderer.getPreferredHeight();
    }

    @Override
    protected void paintFooter(@NotNull Graphics g, int x, int y, int width, int height) {
        int lastRow = this.getRowCount() - 1;
        if (lastRow >= 0) {
            g.setColor(this.getStyle(lastRow, this.convertColumnIndexToView(1), this.hasFocus(), false).getBackground());
            g.fillRect(x, y, width, height);
            if (this.myUi.isMultipleRoots()) {
                g.setColor((Color)VcsLogGraphTable.getRootBackgroundColor(this.getModel().getRoot(lastRow), this.myUi.getColorManager()));
                int rootWidth = this.getColumnByModelIndex(0).getWidth();
                if (!this.myUi.isShowRootNames()) {
                    rootWidth -= JBUI.scale((int)5);
                }
                g.fillRect(x, y, rootWidth, height);
            }
        } else {
            g.setColor(this.getBaseStyle(lastRow, this.convertColumnIndexToView(1), this.hasFocus(), false).getBackground());
            g.fillRect(x, y, width, height);
        }
    }

    public boolean isResizingColumns() {
        return this.getCursor() == Cursor.getPredefinedCursor(11);
    }

    private class MyTableColumnModel
    extends DefaultTableColumnModel {
        @NotNull
        private final VcsLogUiProperties myProperties;

        public MyTableColumnModel(VcsLogUiProperties properties) {
            this.myProperties = properties;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VcsLogGraphTable.this.getTableHeader().getResizingColumn() == null) {
                return;
            }
            if ("width".equals(evt.getPropertyName())) {
                TableColumn authorColumn = VcsLogGraphTable.this.getColumnByModelIndex(2);
                if (authorColumn.equals(evt.getSource())) {
                    CommonUiProperties.saveColumnWidth(this.myProperties, 2, authorColumn.getWidth());
                } else {
                    TableColumn dateColumn = VcsLogGraphTable.this.getColumnByModelIndex(3);
                    if (dateColumn.equals(evt.getSource())) {
                        CommonUiProperties.saveColumnWidth(this.myProperties, 3, dateColumn.getWidth());
                    }
                }
            }
            super.propertyChange(evt);
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            if (VcsLogGraphTable.this.convertColumnIndexToModel(columnIndex) == 0 || VcsLogGraphTable.this.convertColumnIndexToModel(newIndex) == 0) {
                return;
            }
            this.moveWithoutChecks(columnIndex, newIndex);
            VcsLogGraphTable.this.saveColumnOrderToSettings();
        }

        public void moveWithoutChecks(int columnIndex, int newIndex) {
            super.moveColumn(columnIndex, newIndex);
        }
    }

    private class MyProgressListener
    implements VcsLogProgress.ProgressListener {
        @NotNull
        private String myText = "";

        private MyProgressListener() {
        }

        @Override
        public void progressStarted() {
            this.myText = VcsLogGraphTable.this.getEmptyText().getText();
            VcsLogGraphTable.this.getEmptyText().setText("Loading History...");
        }

        @Override
        public void progressStopped() {
            VcsLogGraphTable.this.getEmptyText().setText(this.myText);
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            VcsLogGraphTable.this.mySelection = null;
        }
    }

    private static class MyBasicTableHeaderUI
    extends BasicTableHeaderUI
    implements MouseInputListener {
        public MyBasicTableHeaderUI(@NotNull JTableHeader tableHeader) {
            this.header = tableHeader;
            this.mouseInputListener = this.createMouseInputListener();
        }

        @NotNull
        private MouseEvent convertMouseEvent(@NotNull MouseEvent e) {
            return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), 0, e.getXOnScreen(), this.header.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (this.isOnBorder(e) || this.isOnRootColumn(e)) {
                return;
            }
            this.mouseInputListener.mousePressed(this.convertMouseEvent(e));
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (this.isOnBorder(e) || this.isOnRootColumn(e)) {
                return;
            }
            this.mouseInputListener.mouseReleased(this.convertMouseEvent(e));
            if (this.header.getCursor() == Cursor.getPredefinedCursor(13)) {
                this.header.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (this.isOnBorder(e) || this.isOnRootColumn(e)) {
                return;
            }
            this.mouseInputListener.mouseDragged(this.convertMouseEvent(e));
            if (this.header.getDraggedColumn() != null && this.header.getCursor() == Cursor.getPredefinedCursor(0)) {
                this.header.setCursor(Cursor.getPredefinedCursor(13));
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (this.isOnBorder(e)) {
                return;
            }
            this.mouseInputListener.mouseMoved(this.convertMouseEvent(e));
        }

        public boolean isOnBorder(@NotNull MouseEvent e) {
            return Math.abs(this.header.getTable().getWidth() - e.getPoint().x) <= JBUI.scale((int)3);
        }

        public boolean isOnRootColumn(@NotNull MouseEvent e) {
            return this.header.getTable().getColumnModel().getColumnIndexAtX(e.getX()) == 0;
        }
    }

    private static class EmptyTableCellRenderer
    implements TableCellRenderer {
        private EmptyTableCellRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setMaximumSize(new Dimension(0, 0));
            return panel2;
        }
    }

    private class InvisibleResizableHeader
    extends JBTable.JBTableHeader {
        @NotNull
        private final MyBasicTableHeaderUI myHeaderUI;
        @Nullable
        private Cursor myCursor;

        public InvisibleResizableHeader() {
            super((JBTable)VcsLogGraphTable.this);
            this.myCursor = null;
            this.myHeaderUI = new MyBasicTableHeaderUI((JTableHeader)((Object)this));
            this.setDefaultRenderer(new EmptyTableCellRenderer());
            this.setReorderingAllowed(true);
        }

        public void setTable(JTable table) {
            JTable oldTable = this.getTable();
            if (oldTable != null) {
                oldTable.removeMouseListener(this.myHeaderUI);
                oldTable.removeMouseMotionListener(this.myHeaderUI);
            }
            super.setTable(table);
            if (table != null) {
                table.addMouseListener(this.myHeaderUI);
                table.addMouseMotionListener(this.myHeaderUI);
            }
        }

        public void setCursor(@Nullable Cursor cursor) {
            JTable table = this.getTable();
            if (table != null) {
                table.setCursor(cursor);
                this.myCursor = cursor;
            } else {
                super.setCursor(cursor);
            }
        }

        public Cursor getCursor() {
            if (this.myCursor == null) {
                JTable table = this.getTable();
                if (table == null) {
                    return super.getCursor();
                }
                return table.getCursor();
            }
            return this.myCursor;
        }

        @NotNull
        public Rectangle getHeaderRect(int column) {
            Rectangle headerRect = super.getHeaderRect(column);
            return new Rectangle(headerRect.x, headerRect.y, headerRect.width, 1);
        }
    }

    private class MyDummyTableCellEditor
    implements TableCellEditor {
        private MyDummyTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            if (!(anEvent instanceof MouseEvent)) {
                return true;
            }
            return VcsLogGraphTable.this.myController.findPrintElement((MouseEvent)anEvent) == null;
        }

        @Override
        public boolean stopCellEditing() {
            return false;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    private class StringCellRenderer
    extends ColoredTableCellRenderer {
        private StringCellRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value2, boolean selected, boolean hasFocus, int row, int column) {
            this.setBorder(null);
            if (value2 == null) {
                return;
            }
            this.append(value2.toString(), VcsLogGraphTable.this.applyHighlighters((Component)((Object)this), row, column, hasFocus, selected));
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
        }

        public int getHorizontalTextPadding() {
            Insets borderInsets = this.getMyBorder().getBorderInsets((Component)((Object)this));
            Insets ipad = this.getIpad();
            return borderInsets.left + borderInsets.right + ipad.left + ipad.right;
        }
    }

    private static class RootCellRenderer
    extends JBLabel
    implements TableCellRenderer {
        @NotNull
        private final AbstractVcsLogUi myUi;
        @NotNull
        private Color myColor = UIUtil.getTableBackground();
        @NotNull
        private Color myBorderColor = UIUtil.getTableBackground();
        private boolean isNarrow = true;

        RootCellRenderer(@NotNull AbstractVcsLogUi ui) {
            super("", 0);
            this.myUi = ui;
        }

        protected void paintComponent(Graphics g) {
            this.setFont(VcsLogGraphTable.getTableFont());
            g.setColor(this.myColor);
            int width = this.getWidth();
            if (this.isNarrow) {
                g.fillRect(0, 0, width - JBUI.scale((int)5), this.myUi.getTable().getRowHeight());
                g.setColor(this.myBorderColor);
                g.fillRect(width - JBUI.scale((int)5), 0, JBUI.scale((int)5), this.myUi.getTable().getRowHeight());
            } else {
                g.fillRect(0, 0, width, this.myUi.getTable().getRowHeight());
            }
            super.paintComponent(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color;
            String text;
            if (value2 instanceof VirtualFile) {
                VirtualFile root = (VirtualFile)value2;
                int readableRow = ScrollingUtil.getReadableRow((JTable)table, (int)Math.round((float)this.myUi.getTable().getRowHeight() * 0.5f));
                text = row < readableRow ? "" : (row == 0 || !value2.equals(table.getModel().getValueAt(row - 1, column)) || readableRow == row ? root.getName() : "");
                color = VcsLogGraphTable.getRootBackgroundColor(root, this.myUi.getColorManager());
            } else {
                text = null;
                color = UIUtil.getTableBackground((boolean)isSelected);
            }
            this.myColor = color;
            Color background = ((VcsLogGraphTable)((Object)table)).getStyle(row, column, hasFocus, isSelected).getBackground();
            assert (background != null);
            this.myBorderColor = background;
            this.setForeground(UIUtil.getTableForeground((boolean)false));
            if (this.myUi.isShowRootNames()) {
                this.setText(text);
                this.isNarrow = false;
            } else {
                this.setText("");
                this.isNarrow = true;
            }
            return this;
        }

        public void setBackground(Color bg) {
            this.myBorderColor = bg;
        }
    }

    static class Selection {
        @NotNull
        private final VcsLogGraphTable myTable;
        @NotNull
        private final TIntHashSet mySelectedCommits;
        @Nullable
        private final Integer myVisibleSelectedCommit;
        @Nullable
        private final Integer myDelta;
        private final boolean myIsOnTop;

        public Selection(@NotNull VcsLogGraphTable table) {
            this.myTable = table;
            List selectedRows = ContainerUtil.sorted((Collection)Ints.asList((int[])this.myTable.getSelectedRows()));
            Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)this.myTable));
            this.myIsOnTop = (Integer)visibleRows.first - 1 == 0;
            VisibleGraph<Integer> graph = this.myTable.getVisibleGraph();
            this.mySelectedCommits = new TIntHashSet();
            Integer visibleSelectedCommit = null;
            Integer delta = null;
            Iterator iterator = selectedRows.iterator();
            while (iterator.hasNext()) {
                int row = (Integer)iterator.next();
                if (row >= graph.getVisibleCommitCount()) continue;
                Integer commit = (Integer)graph.getRowInfo(row).getCommit();
                this.mySelectedCommits.add(commit.intValue());
                if ((Integer)visibleRows.first - 1 > row || row > (Integer)visibleRows.second || visibleSelectedCommit != null) continue;
                visibleSelectedCommit = commit;
                delta = this.myTable.getCellRect((int)row, (int)0, (boolean)false).y - this.myTable.getVisibleRect().y;
            }
            if (visibleSelectedCommit == null && (Integer)visibleRows.first - 1 >= 0) {
                visibleSelectedCommit = (Integer)graph.getRowInfo((Integer)visibleRows.first - 1).getCommit();
                delta = this.myTable.getCellRect((int)(((Integer)visibleRows.first).intValue() - 1), (int)0, (boolean)false).y - this.myTable.getVisibleRect().y;
            }
            this.myVisibleSelectedCommit = visibleSelectedCommit;
            this.myDelta = delta;
        }

        public void restore(@NotNull VisibleGraph<Integer> newVisibleGraph, boolean scrollToSelection, boolean permGraphChanged) {
            Pair<TIntHashSet, Integer> toSelectAndScroll = this.findRowsToSelectAndScroll(this.myTable.getModel(), newVisibleGraph);
            if (!((TIntHashSet)toSelectAndScroll.first).isEmpty()) {
                this.myTable.getSelectionModel().setValueIsAdjusting(true);
                ((TIntHashSet)toSelectAndScroll.first).forEach(row -> {
                    this.myTable.addRowSelectionInterval(row, row);
                    return true;
                });
                this.myTable.getSelectionModel().setValueIsAdjusting(false);
            }
            if (scrollToSelection) {
                if (this.myIsOnTop && permGraphChanged) {
                    this.scrollToRow(0, 0);
                } else if (toSelectAndScroll.second != null) {
                    assert (this.myDelta != null);
                    this.scrollToRow((Integer)toSelectAndScroll.second, this.myDelta);
                }
            }
        }

        private void scrollToRow(Integer row, Integer delta) {
            Rectangle startRect = this.myTable.getCellRect(row, 0, true);
            this.myTable.scrollRectToVisible(new Rectangle(startRect.x, Math.max(startRect.y - delta, 0), startRect.width, this.myTable.getVisibleRect().height));
        }

        @NotNull
        private Pair<TIntHashSet, Integer> findRowsToSelectAndScroll(@NotNull GraphTableModel model, @NotNull VisibleGraph<Integer> visibleGraph) {
            TIntHashSet rowsToSelect = new TIntHashSet();
            if (model.getRowCount() == 0) {
                return Pair.create((Object)rowsToSelect, null);
            }
            Integer rowToScroll = null;
            for (int row = 0; row < visibleGraph.getVisibleCommitCount() && (rowsToSelect.size() < this.mySelectedCommits.size() || rowToScroll == null); ++row) {
                int commit = (Integer)visibleGraph.getRowInfo(row).getCommit();
                if (this.mySelectedCommits.contains(commit)) {
                    rowsToSelect.add(row);
                }
                if (this.myVisibleSelectedCommit == null || this.myVisibleSelectedCommit != commit) continue;
                rowToScroll = row;
            }
            return Pair.create((Object)rowsToSelect, rowToScroll);
        }
    }
}

