/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.VcsLogProvider;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PersistentUtil {
    @NotNull
    public static final File LOG_CACHE = new File(PathManager.getSystemPath(), "vcs-log");
    @NotNull
    private static final String CORRUPTION_MARKER = "corruption.marker";

    @NotNull
    public static String calcLogId(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        int hashcode = PersistentUtil.calcLogProvidersHash(logProviders);
        return project2.getLocationHash() + "." + Integer.toHexString(hashcode);
    }

    private static int calcLogProvidersHash(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        List sortedRoots = ContainerUtil.sorted(logProviders.keySet(), Comparator.comparing(VirtualFile::getPath));
        return StringUtil.join((Collection)sortedRoots, root -> root.getPath() + "." + ((VcsLogProvider)logProviders.get(root)).getSupportedVcs().getName(), (String)".").hashCode();
    }

    @NotNull
    public static File getStorageFile(@NotNull String storageKind, @NotNull String logId, int version) {
        File subdir = new File(LOG_CACHE, storageKind);
        String safeLogId = PathUtilRt.suggestFileName((String)logId, (boolean)true, (boolean)true);
        File mapFile = new File(subdir, safeLogId + "." + version);
        if (!mapFile.exists()) {
            IOUtil.deleteAllFilesStartingWith((File)new File(subdir, safeLogId));
        }
        return mapFile;
    }

    public static void cleanupOldStorageFile(@NotNull String storageKind, @NotNull String logId) {
        File subdir = new File(LOG_CACHE, storageKind);
        String safeLogId = PathUtilRt.suggestFileName((String)logId, (boolean)true, (boolean)true);
        IOUtil.deleteAllFilesStartingWith((File)new File(subdir, safeLogId));
        File[] files = subdir.listFiles();
        if (files != null && files.length == 0) {
            subdir.delete();
        }
    }

    @NotNull
    public static <T> PersistentEnumeratorBase<T> createPersistentEnumerator(@NotNull KeyDescriptor<T> keyDescriptor, @NotNull String storageKind, @NotNull String logId, int version) throws IOException {
        File storageFile = PersistentUtil.getStorageFile(storageKind, logId, version);
        return (PersistentEnumeratorBase)IOUtil.openCleanOrResetBroken(() -> new PersistentBTreeEnumerator(storageFile, keyDescriptor, Page.PAGE_SIZE, null, version), (File)storageFile);
    }

    public static boolean deleteWithRenamingAllFilesStartingWith(@NotNull File baseFile) {
        File parentFile = baseFile.getParentFile();
        if (parentFile == null) {
            return false;
        }
        File[] files = parentFile.listFiles(pathname -> pathname.getName().startsWith(baseFile.getName()));
        if (files == null) {
            return true;
        }
        boolean deleted = true;
        for (File f : files) {
            deleted &= FileUtil.deleteWithRenaming((File)f);
        }
        return deleted;
    }

    public static boolean cleanupStorageFiles(@NotNull String subdirName, @NotNull String id) {
        File subdir = new File(LOG_CACHE, subdirName);
        String safeLogId = PathUtilRt.suggestFileName((String)id, (boolean)true, (boolean)true);
        return PersistentUtil.deleteWithRenamingAllFilesStartingWith(new File(subdir, safeLogId + "."));
    }

    @NotNull
    public static File getStorageFile(@NotNull String subdirName, @NotNull String kind2, @NotNull String id, int version, boolean cleanupOldVersions) {
        File subdir = new File(LOG_CACHE, subdirName);
        String safeLogId = PathUtilRt.suggestFileName((String)id, (boolean)true, (boolean)true);
        File file2 = new File(subdir, safeLogId + "." + kind2 + "." + version);
        if (cleanupOldVersions && !file2.exists()) {
            IOUtil.deleteAllFilesStartingWith((File)new File(subdir, safeLogId + "." + kind2));
        }
        return file2;
    }

    @NotNull
    public static File getCorruptionMarkerFile() {
        return new File(LOG_CACHE, CORRUPTION_MARKER);
    }
}

