/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TroveUtil {
    @NotNull
    public static <T> Stream<T> streamValues(@NotNull TIntObjectHashMap<T> map2) {
        TIntObjectIterator it = map2.iterator();
        return Stream.generate(() -> {
            it.advance();
            return it.value();
        }).limit(map2.size());
    }

    @NotNull
    public static IntStream streamKeys(@NotNull TIntObjectHashMap<?> map2) {
        TIntObjectIterator it = map2.iterator();
        return IntStream.generate(() -> {
            it.advance();
            return it.key();
        }).limit(map2.size());
    }

    @NotNull
    public static IntStream stream(@NotNull TIntArrayList list) {
        if (list.isEmpty()) {
            return IntStream.empty();
        }
        return IntStream.range(0, list.size()).map(arg_0 -> ((TIntArrayList)list).get(arg_0));
    }

    @NotNull
    public static Set<Integer> intersect(TIntHashSet ... sets) {
        TIntHashSet result2 = null;
        Arrays.sort(sets, (set1, set2) -> {
            if (set1 == null) {
                return -1;
            }
            if (set2 == null) {
                return 1;
            }
            return set1.size() - set2.size();
        });
        for (TIntHashSet set3 : sets) {
            result2 = TroveUtil.intersect(result2, set3);
        }
        if (result2 == null) {
            return ContainerUtil.newHashSet();
        }
        return TroveUtil.createJavaSet(result2);
    }

    @Nullable
    private static TIntHashSet intersect(@Nullable TIntHashSet set1, @Nullable TIntHashSet set2) {
        if (set1 == null) {
            return set2;
        }
        if (set2 == null) {
            return set1;
        }
        TIntHashSet result2 = new TIntHashSet();
        if (set1.size() < set2.size()) {
            set1.forEach(value2 -> {
                if (set2.contains(value2)) {
                    result2.add(value2);
                }
                return true;
            });
        } else {
            set2.forEach(value2 -> {
                if (set1.contains(value2)) {
                    result2.add(value2);
                }
                return true;
            });
        }
        return result2;
    }

    @NotNull
    private static Set<Integer> createJavaSet(@NotNull TIntHashSet set2) {
        HashSet result2 = ContainerUtil.newHashSet((int)set2.size());
        set2.forEach(value2 -> {
            result2.add(value2);
            return true;
        });
        return result2;
    }

    public static void addAll(@NotNull TIntHashSet where, @NotNull TIntHashSet what) {
        what.forEach(value2 -> {
            where.add(value2);
            return true;
        });
    }

    @NotNull
    public static IntStream stream(@NotNull TIntHashSet set2) {
        TIntIterator it = set2.iterator();
        return IntStream.generate(() -> ((TIntIterator)it).next()).limit(set2.size());
    }

    @NotNull
    public static <T> List<T> map(@NotNull TIntHashSet set2, @NotNull IntFunction<T> function) {
        return TroveUtil.stream(set2).mapToObj(function).collect(Collectors.toList());
    }

    public static void processBatches(@NotNull IntStream stream, int batchSize, @NotNull Consumer<TIntHashSet> consumer2) {
        Ref batch = new Ref((Object)new TIntHashSet());
        stream.forEach(commit -> {
            ((TIntHashSet)batch.get()).add(commit);
            if (((TIntHashSet)batch.get()).size() >= batchSize) {
                try {
                    consumer2.consume(batch.get());
                }
                finally {
                    batch.set((Object)new TIntHashSet());
                }
            }
        });
        if (!((TIntHashSet)batch.get()).isEmpty()) {
            consumer2.consume(batch.get());
        }
    }
}

