/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public class VcsLogUiUtil {
    @NotNull
    public static JComponent installProgress(@NotNull JComponent component, final @NotNull VcsLogData logData, @NotNull Disposable disposableParent) {
        final ProgressStripe progressStripe = new ProgressStripe(component, disposableParent, 300){

            @Override
            public void updateUI() {
                super.updateUI();
                if (this.myDecorator != null && logData.getProgress().isRunning()) {
                    this.startLoadingImmediately();
                }
            }
        };
        logData.getProgress().addProgressIndicatorListener(new VcsLogProgress.ProgressListener(){

            @Override
            public void progressStarted() {
                progressStripe.startLoading();
            }

            @Override
            public void progressStopped() {
                progressStripe.stopLoading();
            }
        }, disposableParent);
        return progressStripe;
    }

    @NotNull
    public static JScrollPane setupScrolledGraph(@NotNull VcsLogGraphTable graphTable, int border) {
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)graphTable), (int)border);
        graphTable.viewportSet(scrollPane.getViewport());
        return scrollPane;
    }

    public static void installDetailsListeners(@NotNull VcsLogGraphTable graphTable, @NotNull DetailsPanel detailsPanel, @NotNull VcsLogData logData, @NotNull Disposable disposableParent) {
        Runnable miniDetailsLoadedListener = () -> {
            graphTable.reLayout();
            graphTable.repaint();
        };
        Runnable containingBranchesListener = () -> {
            detailsPanel.branchesChanged();
            graphTable.repaint();
        };
        logData.getMiniDetailsGetter().addDetailsLoadedListener(miniDetailsLoadedListener);
        logData.getContainingBranchesGetter().addTaskCompletedListener(containingBranchesListener);
        Disposer.register((Disposable)disposableParent, () -> {
            logData.getContainingBranchesGetter().removeTaskCompletedListener(containingBranchesListener);
            logData.getMiniDetailsGetter().removeDetailsLoadedListener(miniDetailsLoadedListener);
        });
    }
}

