/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.util.Couple;
import com.intellij.vcs.log.VcsUser;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUserUtil {
    @NotNull
    private static final Pattern NAME_PATTERN = Pattern.compile("(\\w+)[\\W_](\\w+)");
    @NotNull
    private static final Pattern PRINTABLE_ASCII_PATTERN = Pattern.compile("[ -~]*");

    @NotNull
    public static String toExactString(@NotNull VcsUser user) {
        return VcsUserUtil.getString(user.getName(), user.getEmail());
    }

    @NotNull
    private static String getString(@NotNull String name, @NotNull String email) {
        if (name.isEmpty()) {
            return email;
        }
        if (email.isEmpty()) {
            return name;
        }
        return name + " <" + email + ">";
    }

    public static boolean isSamePerson(@NotNull VcsUser user1, @NotNull VcsUser user2) {
        return VcsUserUtil.getNameInStandardForm(VcsUserUtil.getName(user1)).equals(VcsUserUtil.getNameInStandardForm(VcsUserUtil.getName(user2)));
    }

    @NotNull
    public static String getShortPresentation(@NotNull VcsUser user) {
        return VcsUserUtil.getName(user);
    }

    @NotNull
    private static String getName(@NotNull VcsUser user) {
        return VcsUserUtil.getUserName(user.getName(), user.getEmail());
    }

    @NotNull
    public static String getUserName(@NotNull String name, @NotNull String email) {
        if (!name.isEmpty()) {
            return name;
        }
        String emailNamePart = VcsUserUtil.getNameFromEmail(email);
        if (emailNamePart != null) {
            return emailNamePart;
        }
        return email;
    }

    @Nullable
    public static String getNameFromEmail(@NotNull String email) {
        int at = email.indexOf(64);
        String emailNamePart = null;
        if (at > 0) {
            emailNamePart = email.substring(0, at);
        }
        return emailNamePart;
    }

    @NotNull
    public static String getNameInStandardForm(@NotNull String name) {
        Couple<String> firstAndLastName = VcsUserUtil.getFirstAndLastName(name);
        if (firstAndLastName != null) {
            return ((String)firstAndLastName.first).toLowerCase(Locale.ENGLISH) + " " + ((String)firstAndLastName.second).toLowerCase(Locale.ENGLISH);
        }
        return VcsUserUtil.nameToLowerCase(name);
    }

    @Nullable
    public static Couple<String> getFirstAndLastName(@NotNull String name) {
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            return Couple.of((Object)matcher.group(1), (Object)matcher.group(2));
        }
        return null;
    }

    @NotNull
    public static String nameToLowerCase(@NotNull String name) {
        if (!PRINTABLE_ASCII_PATTERN.matcher(name).matches()) {
            return name;
        }
        return name.toLowerCase(Locale.ENGLISH);
    }

    @NotNull
    public static String capitalizeName(@NotNull String name) {
        if (name.isEmpty()) {
            return name;
        }
        if (!PRINTABLE_ASCII_PATTERN.matcher(name).matches()) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    @NotNull
    public static String emailToLowerCase(@NotNull String email) {
        return email.toLowerCase(Locale.ENGLISH);
    }
}

