/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.SimpleGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SnapshotVisiblePackBuilder {
    @NotNull
    private final VcsLogStorage myStorage;

    public SnapshotVisiblePackBuilder(@NotNull VcsLogStorage storage2) {
        this.myStorage = storage2;
    }

    @NotNull
    public VisiblePack build(@NotNull VisiblePack visiblePack) {
        if (visiblePack.getVisibleGraph() instanceof VisibleGraphImpl && visiblePack.getVisibleGraph().getVisibleCommitCount() > 0) {
            return this.build(visiblePack.getDataPack(), (VisibleGraphImpl)visiblePack.getVisibleGraph(), visiblePack.getFilters());
        }
        VisibleGraph<Integer> newGraph = EmptyVisibleGraph.getInstance();
        DataPackBase newPack = new DataPackBase(visiblePack.getDataPack().getLogProviders(), this.createEmptyRefsModel(), false);
        return new VisiblePack(newPack, newGraph, true, visiblePack.getFilters());
    }

    @NotNull
    private VisiblePack build(@NotNull DataPackBase oldPack, @NotNull VisibleGraphImpl<Integer> oldGraph, @NotNull VcsLogFilterCollection filters) {
        SimpleGraphInfo<Integer> info = oldGraph.buildSimpleGraphInfo();
        Set heads = ContainerUtil.map2Set(info.getPermanentGraphLayout().getHeadNodeIndex(), integer -> (Integer)info.getPermanentCommitsInfo().getCommitId((int)integer));
        RefsModel newRefsModel = this.createRefsModel(oldPack.getRefsModel(), heads, oldGraph, oldPack.getLogProviders());
        DataPackBase newPack = new DataPackBase(oldPack.getLogProviders(), newRefsModel, false);
        GraphColorManagerImpl colorManager = new GraphColorManagerImpl(newRefsModel, VcsLogStorageImpl.createHashGetter(this.myStorage), DataPack.getRefManagerMap(oldPack.getLogProviders()));
        VisibleGraphImpl<Integer> newGraph = new VisibleGraphImpl<Integer>(new CollapsedController(new BaseController(info), info, null), info, colorManager);
        return new VisiblePack(newPack, newGraph, true, filters);
    }

    @NotNull
    private RefsModel createEmptyRefsModel() {
        return new RefsModel(ContainerUtil.newHashMap(), ContainerUtil.newHashSet(), this.myStorage, ContainerUtil.newHashMap());
    }

    private RefsModel createRefsModel(@NotNull RefsModel refsModel, @NotNull Set<Integer> heads, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        HashSet branchesAndHeads = ContainerUtil.newHashSet();
        refsModel.getBranches().stream().filter(ref -> {
            int index = this.myStorage.getCommitIndex(ref.getCommitHash(), ref.getRoot());
            Integer row = visibleGraph.getVisibleRowIndex((Object)index);
            return row != null && row >= 0;
        }).forEach(branchesAndHeads::add);
        heads.stream().flatMap(head -> refsModel.refsToCommit((int)head).stream()).forEach(branchesAndHeads::add);
        Map<VirtualFile, Set<VcsRef>> map2 = VcsLogUtil.groupRefsByRoot(branchesAndHeads);
        HashMap refs = ContainerUtil.newHashMap();
        Iterator<VirtualFile> iterator = providers.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile root;
            Set<VcsRef> refsForRoot = map2.get(root = iterator.next());
            refs.put(root, new CompressedRefs((Set<VcsRef>)(refsForRoot == null ? ContainerUtil.newHashSet() : refsForRoot), this.myStorage));
        }
        return new RefsModel(refs, heads, this.myStorage, providers);
    }
}

