/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogHashFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFilterer {
    private static final Logger LOG = Logger.getInstance(VcsLogFilterer.class);
    @NotNull
    protected final VcsLogStorage myStorage;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final DataGetter<VcsFullCommitDetails> myCommitDetailsGetter;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    protected final VcsLogIndex myIndex;

    public VcsLogFilterer(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogStorage storage2, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull DataGetter<VcsFullCommitDetails> detailsGetter, @NotNull VcsLogIndex index) {
        this.myStorage = storage2;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myCommitDetailsGetter = detailsGetter;
        this.myLogProviders = providers;
        this.myIndex = index;
    }

    @NotNull
    Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        long start = System.currentTimeMillis();
        VcsLogHashFilter hashFilter = filters.getHashFilter();
        if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
            return Pair.create((Object)this.applyHashFilter(dataPack, hashFilter.getHashes(), sortType), (Object)((Object)commitCount));
        }
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(dataPack.getLogProviders().keySet(), filters.getRootFilter(), filters.getStructureFilter());
        Set<Integer> matchingHeads = this.getMatchingHeads(dataPack.getRefsModel(), visibleRoots, filters);
        FilterResult filterResult = this.filterByDetails(dataPack, filters, commitCount, visibleRoots, matchingHeads);
        VisiblePack visiblePack = this.createVisiblePack(dataPack, sortType, filters, matchingHeads, filterResult.matchingCommits, filterResult.canRequestMore);
        LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start) + " for filtering by " + filters);
        return Pair.create((Object)visiblePack, (Object)((Object)filterResult.commitCount));
    }

    @NotNull
    protected VisiblePack createVisiblePack(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @Nullable Set<Integer> matchingHeads, @Nullable Set<Integer> matchingCommits, boolean canRequestMore) {
        VisibleGraph<Integer> visibleGraph = this.createVisibleGraph(dataPack, sortType, matchingHeads, matchingCommits);
        return new VisiblePack(dataPack, visibleGraph, canRequestMore, filters);
    }

    @NotNull
    protected VisibleGraph<Integer> createVisibleGraph(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @Nullable Set<Integer> matchingHeads, @Nullable Set<Integer> matchingCommits) {
        VisibleGraph visibleGraph = VcsLogFilterer.matchesNothing(matchingHeads) || VcsLogFilterer.matchesNothing(matchingCommits) ? EmptyVisibleGraph.getInstance() : dataPack.getPermanentGraph().createVisibleGraph(sortType, matchingHeads, matchingCommits);
        return visibleGraph;
    }

    @NotNull
    private FilterResult filterByDetails(@NotNull DataPack dataPack, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount, @NotNull Collection<VirtualFile> visibleRoots, @Nullable Set<Integer> matchingHeads) {
        List notIndexedRoots;
        List detailsFilters = filters.getDetailsFilters();
        if (detailsFilters.isEmpty()) {
            return new FilterResult(null, false, commitCount);
        }
        Set filteredWidthIndex = null;
        if (this.myIndex.canFilter(detailsFilters) && (notIndexedRoots = ContainerUtil.filter(visibleRoots, root -> !this.myIndex.isIndexed((VirtualFile)root))).size() < visibleRoots.size()) {
            filteredWidthIndex = this.myIndex.filter(detailsFilters);
            if (notIndexedRoots.isEmpty()) {
                return new FilterResult(filteredWidthIndex, false, commitCount);
            }
            matchingHeads = this.getMatchingHeads(dataPack.getRefsModel(), notIndexedRoots, filters);
        }
        FilterResult filteredWithVcs = this.filterWithVcs(dataPack.getPermanentGraph(), filters, detailsFilters, matchingHeads, commitCount);
        Set filteredCommits = filteredWidthIndex == null ? filteredWithVcs.matchingCommits : (filteredWithVcs.matchingCommits == null ? filteredWidthIndex : ContainerUtil.union(filteredWidthIndex, (Set)filteredWithVcs.matchingCommits));
        return new FilterResult(filteredCommits, filteredWithVcs.canRequestMore, filteredWithVcs.commitCount);
    }

    @NotNull
    private FilterResult filterWithVcs(@NotNull PermanentGraph graph, @NotNull VcsLogFilterCollection filters, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads, @NotNull CommitCountStage commitCount) {
        Set<Object> matchingCommits = null;
        if (commitCount == CommitCountStage.INITIAL && (matchingCommits = this.getMatchedCommitIndex(this.filterInMemory((PermanentGraph<Integer>)graph, detailsFilters, matchingHeads))).size() < commitCount.getCount()) {
            commitCount = commitCount.next();
            matchingCommits = null;
        }
        if (matchingCommits == null) {
            try {
                matchingCommits = this.getMatchedCommitIndex(VcsLogFilterer.getFilteredDetailsFromTheVcs(this.myLogProviders, filters, commitCount.getCount()));
            }
            catch (VcsException e) {
                matchingCommits = Collections.emptySet();
                LOG.error((Throwable)e);
            }
        }
        return new FilterResult(matchingCommits, matchingCommits.size() >= commitCount.getCount(), commitCount);
    }

    private static <T> boolean matchesNothing(@Nullable Collection<T> matchingSet) {
        return matchingSet != null && matchingSet.isEmpty();
    }

    private VisiblePack applyHashFilter(@NotNull DataPack dataPack, @NotNull Collection<String> hashes, @NotNull PermanentGraph.SortType sortType) {
        Set indices2 = ContainerUtil.map2SetNotNull(hashes, partOfHash -> {
            CommitId commitId = this.myStorage.findCommitId(new CommitIdByStringCondition((String)partOfHash));
            return commitId != null ? Integer.valueOf(this.myStorage.getCommitIndex(commitId.getHash(), commitId.getRoot())) : null;
        });
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, indices2);
        return new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph, false, new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder().with(new VcsLogHashFilterImpl(hashes)).build());
    }

    @Nullable
    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull Collection<VirtualFile> roots, @NotNull VcsLogFilterCollection filters) {
        VcsLogBranchFilter branchFilter = filters.getBranchFilter();
        VcsLogRootFilter rootFilter = filters.getRootFilter();
        VcsLogStructureFilter structureFilter = filters.getStructureFilter();
        if (branchFilter == null && rootFilter == null && structureFilter == null) {
            return null;
        }
        Set<Integer> filteredByBranch = null;
        if (branchFilter != null) {
            filteredByBranch = this.getMatchingHeads(refs, branchFilter);
        }
        Set<Integer> filteredByFile = this.getMatchingHeads(refs, roots);
        if (filteredByBranch == null) {
            return filteredByFile;
        }
        if (filteredByFile == null) {
            return filteredByBranch;
        }
        return new HashSet(ContainerUtil.intersection(filteredByBranch, filteredByFile));
    }

    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull VcsLogBranchFilter filter) {
        return new HashSet((Collection)ContainerUtil.mapNotNull((Collection)refs.getBranches(), ref -> {
            boolean acceptRef = filter.matches(ref.getName());
            return acceptRef ? Integer.valueOf(this.myStorage.getCommitIndex(ref.getCommitHash(), ref.getRoot())) : null;
        }));
    }

    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull Collection<VirtualFile> roots) {
        HashSet result2 = new HashSet();
        for (VcsRef branch : refs.getBranches()) {
            if (!roots.contains(branch.getRoot())) continue;
            result2.add(this.myStorage.getCommitIndex(branch.getCommitHash(), branch.getRoot()));
        }
        return result2;
    }

    @NotNull
    private Collection<CommitId> filterInMemory(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        GraphCommit commit;
        VcsCommitMetadata data;
        ArrayList result2 = ContainerUtil.newArrayList();
        Iterator iterator = permanentGraph.getAllCommits().iterator();
        while (iterator.hasNext() && (data = this.getDetailsFromCache((Integer)(commit = (GraphCommit)iterator.next()).getId())) != null) {
            if (!this.matchesAllFilters(data, permanentGraph, detailsFilters, matchingHeads)) continue;
            result2.add(new CommitId((Hash)data.getId(), data.getRoot()));
        }
        return result2;
    }

    private boolean matchesAllFilters(@NotNull VcsCommitMetadata commit, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        boolean matchesAllDetails = ContainerUtil.and(detailsFilters, filter -> filter.matches(commit));
        return matchesAllDetails && this.matchesAnyHead(permanentGraph, commit, matchingHeads);
    }

    private boolean matchesAnyHead(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull VcsCommitMetadata commit, @Nullable Set<Integer> matchingHeads) {
        if (matchingHeads == null) {
            return true;
        }
        int commitIndex = this.myStorage.getCommitIndex((Hash)commit.getId(), commit.getRoot());
        return ContainerUtil.intersects((Collection)permanentGraph.getContainingBranches((Object)commitIndex), matchingHeads);
    }

    @Nullable
    private VcsCommitMetadata getDetailsFromCache(int commitIndex) {
        VcsCommitMetadata details = this.myTopCommitsDetailsCache.get(commitIndex);
        if (details != null) {
            return details;
        }
        return (VcsCommitMetadata)UIUtil.invokeAndWaitIfNeeded(() -> this.myCommitDetailsGetter.getCommitDataIfAvailable(commitIndex));
    }

    @NotNull
    private static Collection<CommitId> getFilteredDetailsFromTheVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(providers.keySet(), filterCollection.getRootFilter(), filterCollection.getStructureFilter());
        ArrayList commits = ContainerUtil.newArrayList();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            if (!visibleRoots.contains(root) || filterCollection.getUserFilter() != null && filterCollection.getUserFilter().getUsers(root).isEmpty()) continue;
            VcsLogFilterCollection rootSpecificCollection = filterCollection;
            if (rootSpecificCollection.getStructureFilter() != null) {
                rootSpecificCollection = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder(filterCollection).with(new VcsLogStructureFilterImpl(ContainerUtil.newHashSet(VcsLogUtil.getFilteredFilesForRoot(root, filterCollection)))).build();
            }
            List matchingCommits = entry.getValue().getCommitsMatchingFilter(root, rootSpecificCollection, maxCount);
            commits.addAll(ContainerUtil.map((Collection)matchingCommits, commit -> new CommitId((Hash)commit.getId(), root)));
        }
        return commits;
    }

    @Nullable
    private Set<Integer> getMatchedCommitIndex(@Nullable Collection<CommitId> commits) {
        if (commits == null) {
            return null;
        }
        return ContainerUtil.map2Set(commits, commitId -> this.myStorage.getCommitIndex(commitId.getHash(), commitId.getRoot()));
    }

    public boolean affectedByIndexingRoots(@NotNull VcsLogFilterCollection filters, @NotNull List<VirtualFile> roots) {
        boolean needsIndex;
        List detailsFilters = filters.getDetailsFilters();
        if (detailsFilters.isEmpty()) {
            return false;
        }
        Set<VirtualFile> affectedRoots = VcsLogUtil.getAllVisibleRoots(roots, filters.getRootFilter(), filters.getStructureFilter());
        boolean bl = needsIndex = !affectedRoots.isEmpty();
        if (needsIndex) {
            LOG.debug(filters + " are affected by indexing of " + affectedRoots);
        }
        return needsIndex;
    }

    private static class FilterResult {
        @Nullable
        private final Set<Integer> matchingCommits;
        private final boolean canRequestMore;
        @NotNull
        private final CommitCountStage commitCount;

        private FilterResult(@Nullable Set<Integer> commits, boolean more, @NotNull CommitCountStage count) {
            this.matchingCommits = commits;
            this.canRequestMore = more;
            this.commitCount = count;
        }
    }
}

