/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VisiblePack
implements VcsLogDataPack {
    @NotNull
    public static final VisiblePack EMPTY = new VisiblePack(DataPack.EMPTY, EmptyVisibleGraph.getInstance(), false, VcsLogFilterCollectionImpl.EMPTY);
    @NotNull
    private final DataPackBase myDataPack;
    @NotNull
    private final VisibleGraph<Integer> myVisibleGraph;
    private final boolean myCanRequestMore;
    @NotNull
    private final VcsLogFilterCollection myFilters;

    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> graph, boolean canRequestMore, @NotNull VcsLogFilterCollection filters) {
        this.myDataPack = dataPack;
        this.myVisibleGraph = graph;
        this.myCanRequestMore = canRequestMore;
        this.myFilters = filters;
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        return this.myVisibleGraph;
    }

    @NotNull
    public DataPackBase getDataPack() {
        return this.myDataPack;
    }

    public boolean canRequestMore() {
        return this.myCanRequestMore;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        return this.myDataPack.getLogProviders();
    }

    @NotNull
    public VcsLogRefs getRefs() {
        return this.myDataPack.getRefsModel();
    }

    public boolean isFull() {
        return this.myDataPack.isFull();
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        return this.myFilters;
    }

    public VirtualFile getRoot(int row) {
        int head = (Integer)this.myVisibleGraph.getRowInfo(row).getOneOfHeads();
        return this.myDataPack.getRefsModel().rootAtHead(head);
    }
}

