/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.SnapshotVisiblePackBuilder;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisiblePackRefresherImpl
implements VisiblePackRefresher,
Disposable {
    private static final Logger LOG = Logger.getInstance(VisiblePackRefresherImpl.class);
    @NotNull
    private final SingleTaskController<Request, VisiblePack> myTaskController;
    @NotNull
    private final VcsLogFilterer myVisiblePackBuilder;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogIndex.IndexingFinishedListener myIndexingFinishedListener;
    @NotNull
    private VcsLogFilterCollection myFilters;
    @NotNull
    private PermanentGraph.SortType mySortType;
    @NotNull
    private CommitCountStage myCommitCount = CommitCountStage.INITIAL;
    @NotNull
    private List<MoreCommitsRequest> myRequestsToRun = ContainerUtil.newArrayList();
    @NotNull
    private List<VisiblePackChangeListener> myVisiblePackChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private volatile VisiblePack myVisiblePack = VisiblePack.EMPTY;
    private volatile boolean myIsValid = true;

    public VisiblePackRefresherImpl(final @NotNull Project project2, @NotNull VcsLogData logData, @NotNull PermanentGraph.SortType initialSortType, @NotNull VcsLogFilterer builder) {
        this.myLogData = logData;
        this.myVisiblePackBuilder = builder;
        this.myFilters = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder().build();
        this.mySortType = initialSortType;
        this.myTaskController = new SingleTaskController<Request, VisiblePack>(visiblePack -> {
            this.myVisiblePack = visiblePack;
            for (VisiblePackChangeListener listener2 : this.myVisiblePackChangeListeners) {
                listener2.onVisiblePackChange((VisiblePack)visiblePack);
            }
        }){

            @Override
            protected void startNewBackgroundTask() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    MyTask task = new MyTask(project2, "Applying filters...");
                    ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, VisiblePackRefresherImpl.this.myLogData.getProgress().createProgressIndicator());
                });
            }
        };
        this.myIndexingFinishedListener = root -> this.myTaskController.request(new IndexingFinishedRequest(root));
        this.myLogData.getIndex().addListener(this.myIndexingFinishedListener);
    }

    @Override
    public void addVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        this.myVisiblePackChangeListeners.add(listener2);
    }

    @Override
    public void removeVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        this.myVisiblePackChangeListeners.remove(listener2);
    }

    @Override
    public void onRefresh() {
        this.myTaskController.request(new RefreshRequest());
    }

    @Override
    public void setValid(boolean validate) {
        this.myTaskController.request(new ValidateRequest(validate));
    }

    @Override
    public void onFiltersChange(@NotNull VcsLogFilterCollection newFilters) {
        this.myTaskController.request(new FilterRequest(newFilters));
    }

    @Override
    public void onSortTypeChange(@NotNull PermanentGraph.SortType sortType) {
        this.myTaskController.request(new SortTypeRequest(sortType));
    }

    @Override
    public void moreCommitsNeeded(@NotNull Runnable onLoaded) {
        this.myTaskController.request(new MoreCommitsRequest(onLoaded));
    }

    @Override
    public boolean isValid() {
        return this.myIsValid;
    }

    public void dispose() {
        this.myLogData.getIndex().removeListener(this.myIndexingFinishedListener);
    }

    private static final class IndexingFinishedRequest
    implements Request {
        @NotNull
        private final VirtualFile root;

        IndexingFinishedRequest(@NotNull VirtualFile root) {
            this.root = root;
        }

        @NotNull
        public VirtualFile getRoot() {
            return this.root;
        }

        public String toString() {
            return "IndexingFinishedRequest for " + this.root;
        }
    }

    private static final class MoreCommitsRequest
    implements Request {
        @NotNull
        private final Runnable onLoaded;

        MoreCommitsRequest(@NotNull Runnable onLoaded) {
            this.onLoaded = onLoaded;
        }
    }

    private static final class SortTypeRequest
    implements Request {
        private final PermanentGraph.SortType sortType;

        SortTypeRequest(PermanentGraph.SortType sortType) {
            this.sortType = sortType;
        }

        public String toString() {
            return "SortTypeRequest " + this.sortType;
        }
    }

    private static final class FilterRequest
    implements Request {
        private final VcsLogFilterCollection filters;

        FilterRequest(VcsLogFilterCollection filters) {
            this.filters = filters;
        }

        public String toString() {
            return "FilterRequest by " + this.filters;
        }
    }

    private static final class ValidateRequest
    implements Request {
        private final boolean validate;

        private ValidateRequest(boolean validate) {
            this.validate = validate;
        }

        public String toString() {
            return "ValidateRequest " + this.validate;
        }
    }

    private static final class RefreshRequest
    implements Request {
        private RefreshRequest() {
        }

        public String toString() {
            return "RefreshRequest";
        }
    }

    private static interface Request {
    }

    private class MyTask
    extends Task.Backgroundable {
        public MyTask(@NotNull Project project2, String title) {
            super(project2, title, false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            List<Request> requests;
            VisiblePack visiblePack = null;
            while (!(requests = VisiblePackRefresherImpl.this.myTaskController.popRequests()).isEmpty()) {
                try {
                    visiblePack = this.getVisiblePack(visiblePack, requests);
                }
                catch (ProcessCanceledException reThrown) {
                    throw reThrown;
                }
                catch (Throwable t) {
                    LOG.error("Error while filtering log by " + requests, t);
                }
            }
            VisiblePackRefresherImpl.this.myTaskController.taskCompleted(visiblePack);
            if (visiblePack != null && VisiblePackRefresherImpl.this.myIsValid) {
                List requestsToRun = VisiblePackRefresherImpl.this.myRequestsToRun;
                VisiblePackRefresherImpl.this.myRequestsToRun = ContainerUtil.newArrayList();
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (MoreCommitsRequest request : requestsToRun) {
                        request.onLoaded.run();
                    }
                });
            }
        }

        @Nullable
        private VisiblePack getVisiblePack(@Nullable VisiblePack visiblePack, @NotNull List<Request> requests) {
            ValidateRequest validateRequest = (ValidateRequest)ContainerUtil.findLastInstance(requests, ValidateRequest.class);
            FilterRequest filterRequest = (FilterRequest)ContainerUtil.findLastInstance(requests, FilterRequest.class);
            SortTypeRequest sortTypeRequest = (SortTypeRequest)ContainerUtil.findLastInstance(requests, SortTypeRequest.class);
            List moreCommitsRequests = ContainerUtil.findAll(requests, MoreCommitsRequest.class);
            List indexingRequests = ContainerUtil.findAll(requests, IndexingFinishedRequest.class);
            VisiblePackRefresherImpl.this.myRequestsToRun.addAll(moreCommitsRequests);
            if (filterRequest != null) {
                VisiblePackRefresherImpl.this.myFilters = filterRequest.filters;
            }
            if (sortTypeRequest != null) {
                VisiblePackRefresherImpl.this.mySortType = sortTypeRequest.sortType;
            }
            if (!VisiblePackRefresherImpl.this.myIsValid) {
                if (validateRequest != null && validateRequest.validate) {
                    VisiblePackRefresherImpl.this.myIsValid = true;
                    return this.refresh(visiblePack, filterRequest, moreCommitsRequests);
                }
                return visiblePack;
            }
            if (validateRequest != null && !validateRequest.validate) {
                VisiblePack frozenVisiblePack;
                VisiblePackRefresherImpl.this.myIsValid = false;
                VisiblePack visiblePack2 = frozenVisiblePack = visiblePack == null ? VisiblePackRefresherImpl.this.myVisiblePack : visiblePack;
                if (filterRequest != null) {
                    frozenVisiblePack = this.refresh(visiblePack, filterRequest, moreCommitsRequests);
                }
                return new SnapshotVisiblePackBuilder(VisiblePackRefresherImpl.this.myLogData.getStorage()).build(frozenVisiblePack);
            }
            Request nonValidateRequest = (Request)ContainerUtil.find(requests, request -> !(request instanceof ValidateRequest) && !(request instanceof IndexingFinishedRequest));
            if (nonValidateRequest != null) {
                return this.refresh(visiblePack, filterRequest, moreCommitsRequests);
            }
            if (!indexingRequests.isEmpty() && VisiblePackRefresherImpl.this.myVisiblePackBuilder.affectedByIndexingRoots(VisiblePackRefresherImpl.this.myFilters, ContainerUtil.map((Collection)indexingRequests, IndexingFinishedRequest::getRoot))) {
                return this.refresh(visiblePack, filterRequest, moreCommitsRequests);
            }
            return visiblePack;
        }

        private VisiblePack refresh(@Nullable VisiblePack visiblePack, @Nullable FilterRequest filterRequest, @NotNull List<MoreCommitsRequest> moreCommitsRequests) {
            DataPack dataPack = VisiblePackRefresherImpl.this.myLogData.getDataPack();
            if (dataPack == DataPack.EMPTY) {
                return visiblePack;
            }
            if (filterRequest != null) {
                VisiblePackRefresherImpl.this.myCommitCount = CommitCountStage.INITIAL;
            } else if (!moreCommitsRequests.isEmpty()) {
                VisiblePackRefresherImpl.this.myCommitCount = VisiblePackRefresherImpl.this.myCommitCount.next();
            }
            Pair<VisiblePack, CommitCountStage> pair = VisiblePackRefresherImpl.this.myVisiblePackBuilder.filter(dataPack, VisiblePackRefresherImpl.this.mySortType, VisiblePackRefresherImpl.this.myFilters, VisiblePackRefresherImpl.this.myCommitCount);
            visiblePack = (VisiblePack)pair.first;
            VisiblePackRefresherImpl.this.myCommitCount = (CommitCountStage)((Object)pair.second);
            return visiblePack;
        }
    }
}

