/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsFileUtil {
    public static final int FILE_PATH_LIMIT = 7600;

    @NotNull
    public static <T> List<T> foreachChunk(@NotNull List<String> arguments, @NotNull ThrowableNotNullFunction<List<String>, List<? extends T>, VcsException> processor2) throws VcsException {
        return VcsFileUtil.foreachChunk(arguments, 1, processor2);
    }

    @NotNull
    public static <T> List<T> foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableNotNullFunction<List<String>, List<? extends T>, VcsException> processor2) throws VcsException {
        ArrayList result2 = ContainerUtil.newArrayList();
        VcsFileUtil.foreachChunk(arguments, groupSize, (ThrowableConsumer<List<String>, VcsException>)((ThrowableConsumer)chunk -> result2.addAll((Collection)processor2.fun(chunk))));
        return result2;
    }

    public static void foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableConsumer<List<String>, VcsException> consumer2) throws VcsException {
        List<List<String>> chunks = VcsFileUtil.chunkArguments(arguments, groupSize);
        for (List<String> chunk : chunks) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.checkCanceled();
            }
            consumer2.consume(chunk);
        }
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments) {
        return VcsFileUtil.chunkArguments(arguments, 1);
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments, int groupSize) {
        int i2;
        assert (arguments.size() % groupSize == 0) : "Arguments size should be divisible by group size";
        ArrayList<List<String>> rc = new ArrayList<List<String>>();
        int start = 0;
        int size = 0;
        for (i2 = 0; i2 < arguments.size(); i2 += groupSize) {
            int length = 0;
            for (int j = 0; j < groupSize; ++j) {
                length += arguments.get(i2 + j).length();
            }
            if (size + length > 7600) {
                if (start == i2) {
                    rc.add(arguments.subList(i2, i2 + groupSize));
                    start = i2 + groupSize;
                } else {
                    rc.add(arguments.subList(start, i2));
                    start = i2;
                }
                size = 0;
                continue;
            }
            size += length;
        }
        if (start != arguments.size()) {
            rc.add(arguments.subList(start, i2));
        }
        return rc;
    }

    public static List<List<String>> chunkPaths(VirtualFile root, Collection<FilePath> files) {
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativePaths(root, files));
    }

    public static List<List<String>> chunkFiles(@NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) {
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativeFiles(root, files));
    }

    public static String getRelativeFilePath(VirtualFile file2, @NotNull VirtualFile baseDir) {
        return VcsFileUtil.getRelativeFilePath(file2.getPath(), baseDir);
    }

    public static String getRelativeFilePath(String file2, @NotNull VirtualFile baseDir) {
        String basePath;
        if (SystemInfo.isWindows) {
            file2 = file2.replace('\\', '/');
        }
        if (!file2.startsWith(basePath = baseDir.getPath())) {
            return file2;
        }
        if (file2.equals(basePath)) {
            return ".";
        }
        return file2.substring(baseDir.getPath().length() + 1);
    }

    public static boolean isOctal(char ch) {
        return '0' <= ch && ch <= '7';
    }

    public static String relativePath(VirtualFile root, FilePath path) {
        return VcsFileUtil.relativePath(VfsUtil.virtualToIoFile((VirtualFile)root), path.getIOFile());
    }

    public static String relativePath(File root, FilePath path) {
        return VcsFileUtil.relativePath(root, path.getIOFile());
    }

    public static String relativePath(File root, VirtualFile file2) {
        return VcsFileUtil.relativePath(root, VfsUtil.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativePath(VirtualFile root, VirtualFile file2) {
        return VcsFileUtil.relativePath(VfsUtil.virtualToIoFile((VirtualFile)root), VfsUtil.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativeOrFullPath(VirtualFile root, VirtualFile file2) {
        if (root == null) {
            file2.getPath();
        }
        return VcsFileUtil.relativePath(VfsUtil.virtualToIoFile((VirtualFile)root), VfsUtil.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativePath(File root, File path) {
        String rc = FileUtil.getRelativePath((File)root, (File)path);
        if (rc == null) {
            throw new IllegalArgumentException("The file " + path + " cannot be made relative to " + root);
        }
        return rc.replace(File.separatorChar, '/');
    }

    public static List<String> toRelativePaths(@NotNull VirtualFile root, @NotNull Collection<FilePath> filePaths) {
        ArrayList<String> rc = new ArrayList<String>(filePaths.size());
        for (FilePath path : filePaths) {
            rc.add(VcsFileUtil.relativePath(root, path));
        }
        return rc;
    }

    public static List<String> toRelativeFiles(@NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) {
        ArrayList<String> rc = new ArrayList<String>(files.size());
        for (VirtualFile file2 : files) {
            rc.add(VcsFileUtil.relativePath(root, file2));
        }
        return rc;
    }

    public static void markFilesDirty(@NotNull Project project2, @NotNull Collection<VirtualFile> affectedFiles) {
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project2);
        for (VirtualFile file2 : affectedFiles) {
            if (file2.isDirectory()) {
                dirty.dirDirtyRecursively(file2);
                continue;
            }
            dirty.fileDirty(file2);
        }
    }

    public static void markFilesDirty(@NotNull Project project2, @NotNull List<FilePath> affectedFiles) {
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project2);
        for (FilePath file2 : affectedFiles) {
            if (file2.isDirectory()) {
                dirty.dirDirtyRecursively(file2);
                continue;
            }
            dirty.fileDirty(file2);
        }
    }

    @Nullable
    public static VirtualFile getPossibleBase(VirtualFile file2, String ... path) {
        if (file2 == null || path.length == 0) {
            return null;
        }
        VirtualFile current = file2;
        ArrayList<VirtualFile> backTrace = new ArrayList<VirtualFile>();
        int idx = path.length - 1;
        while (current != null) {
            if (SystemInfo.isFileSystemCaseSensitive ? current.getName().equals(path[idx]) : current.getName().equalsIgnoreCase(path[idx])) {
                if (idx == 0) {
                    return current;
                }
                --idx;
            } else if (idx != path.length - 1) {
                int diff = path.length - 1 - idx - 1;
                for (int i2 = 0; i2 < diff; ++i2) {
                    current = (VirtualFile)backTrace.remove(backTrace.size() - 1);
                }
                idx = path.length - 1;
                continue;
            }
            backTrace.add(current);
            current = current.getParent();
        }
        return null;
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project2, VirtualFile ... virtualFiles) {
        VcsFileUtil.addFilesToVcsWithConfirmation(project2, Arrays.asList(virtualFiles));
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project2, @NotNull Collection<VirtualFile> virtualFiles) {
        if (virtualFiles.isEmpty()) {
            return;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        ArrayListMultimap vcsMap = ArrayListMultimap.create();
        for (VirtualFile createdFile : virtualFiles) {
            AbstractVcs vcs = vcsManager.getVcsFor(createdFile);
            if (vcs == null) continue;
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)createdFile, arg_0 -> VcsFileUtil.lambda$addFilesToVcsWithConfirmation$1((Multimap)vcsMap, vcs, arg_0));
        }
        for (AbstractVcs vcs : vcsMap.keySet()) {
            VcsShowConfirmationOption addOption = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, vcs);
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                return;
            }
            ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>(vcsMap.get((Object)vcs));
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
                VcsFileUtil.performAdditions(vcs, filesList);
                continue;
            }
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project2);
            Ref filesToAdd = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> filesToAdd.set((Object)helper.selectFilesToProcess(new ArrayList(filesList), VcsBundle.message((String)"confirmation.title.add.files.to", (Object[])new Object[]{vcs.getDisplayName()}), null, VcsBundle.message((String)"confirmation.title.add.file.to", (Object[])new Object[]{vcs.getDisplayName()}), null, addOption)));
            if (filesToAdd.isNull()) continue;
            VcsFileUtil.performAdditions(vcs, new ArrayList<VirtualFile>((Collection)filesToAdd.get()));
        }
    }

    private static void performAdditions(@NotNull AbstractVcs vcs, @NotNull List<VirtualFile> value2) {
        CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
        if (checkinEnvironment != null) {
            checkinEnvironment.scheduleUnversionedFilesForAddition(value2);
        }
    }

    private static /* synthetic */ boolean lambda$addFilesToVcsWithConfirmation$1(Multimap vcsMap, AbstractVcs vcs, VirtualFile virtualFile) {
        return vcsMap.put((Object)vcs, (Object)virtualFile);
    }
}

