/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.openapi.ui.MessageType;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagingErrorDialog;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagesNotificationPanel {
    private final JEditorPane myHtmlViewer;
    private final Map<String, Runnable> myLinkHandlers = new HashMap<String, Runnable>();
    private String myErrorTitle;
    private PackageManagementService.ErrorDescription myErrorDescription;

    public PackagesNotificationPanel() {
        this.myHtmlViewer = SwingHelper.createHtmlViewer(true, null, null, null);
        this.myHtmlViewer.setVisible(false);
        this.myHtmlViewer.setOpaque(true);
        this.myHtmlViewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                Runnable handler2 = (Runnable)PackagesNotificationPanel.this.myLinkHandlers.get(e.getDescription());
                if (handler2 != null) {
                    handler2.run();
                } else if (PackagesNotificationPanel.this.myErrorTitle != null && PackagesNotificationPanel.this.myErrorDescription != null) {
                    PackagesNotificationPanel.showError(PackagesNotificationPanel.this.myErrorTitle, PackagesNotificationPanel.this.myErrorDescription);
                }
            }
        });
    }

    public static void showError(@NotNull String title, @NotNull PackageManagementService.ErrorDescription description) {
        PackagingErrorDialog dialog2 = new PackagingErrorDialog(title, description);
        dialog2.show();
    }

    public void showResult(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
        if (errorDescription == null) {
            String message2 = "Package installed successfully";
            if (packageName != null) {
                message2 = "Package '" + packageName + "' installed successfully";
            }
            this.showSuccess(message2);
        } else {
            String title = "Failed to install packages";
            if (packageName != null) {
                title = "Failed to install package '" + packageName + "'";
            }
            String firstLine = "Error occurred when installing package '" + packageName + "'. ";
            this.showError(firstLine + "<a href=\"xxx\">Details...</a>", title, errorDescription);
        }
    }

    public void addLinkHandler(String key2, Runnable handler2) {
        this.myLinkHandlers.put(key2, handler2);
    }

    public void removeAllLinkHandlers() {
        this.myLinkHandlers.clear();
    }

    public JComponent getComponent() {
        return this.myHtmlViewer;
    }

    public void showSuccess(String text) {
        this.showContent(text, MessageType.INFO.getPopupBackground());
    }

    private void showContent(@NotNull String text, @NotNull Color background) {
        String htmlText = text.startsWith("<html>") ? text : UIUtil.toHtml((String)text);
        this.myHtmlViewer.setText(htmlText);
        this.myHtmlViewer.setBackground(background);
        this.setVisibleEditorPane(true);
        this.myErrorTitle = null;
        this.myErrorDescription = null;
    }

    public void showError(String text, String detailsTitle, PackageManagementService.ErrorDescription errorDescription) {
        this.showContent(text, MessageType.ERROR.getPopupBackground());
        this.myErrorTitle = detailsTitle;
        this.myErrorDescription = errorDescription;
    }

    public void showWarning(String text) {
        this.showContent(text, MessageType.WARNING.getPopupBackground());
    }

    public void hide() {
        this.setVisibleEditorPane(false);
    }

    private void setVisibleEditorPane(boolean visible) {
        boolean oldVisible = this.myHtmlViewer.isVisible();
        this.myHtmlViewer.setVisible(visible);
        if (oldVisible != visible) {
            this.myHtmlViewer.revalidate();
            this.myHtmlViewer.repaint();
        }
    }

    public boolean hasLinkHandler(String key2) {
        return this.myLinkHandlers.containsKey(key2);
    }

    public void removeLinkHandler(String key2) {
        this.myLinkHandlers.remove(key2);
    }
}

