/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerHistoryManager {
    public static final int MAX_RECENT_EXPRESSIONS = 10;
    private final Map<String, LinkedList<XExpression>> myRecentExpressions = new HashMap<String, LinkedList<XExpression>>();

    public static XDebuggerHistoryManager getInstance(@NotNull Project project2) {
        return (XDebuggerHistoryManager)ServiceManager.getService((Project)project2, XDebuggerHistoryManager.class);
    }

    public boolean addRecentExpression(@NotNull @NonNls String id, @Nullable XExpression expression2) {
        if (XDebuggerUtilImpl.isEmptyExpression(expression2)) {
            return false;
        }
        LinkedList list = this.myRecentExpressions.computeIfAbsent(id, k -> new LinkedList());
        if (list.size() == 10) {
            list.removeLast();
        }
        XExpressionImpl trimmedExpression = new XExpressionImpl(expression2.getExpression().trim(), expression2.getLanguage(), expression2.getCustomInfo(), expression2.getMode());
        list.remove(trimmedExpression);
        list.addFirst(trimmedExpression);
        return true;
    }

    public List<XExpression> getRecentExpressions(@NonNls String id) {
        return ContainerUtil.notNullize((List)this.myRecentExpressions.get(id));
    }
}

