/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.AppTopics;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointAdapter;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugProcessConfiguratorStarter;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="XDebuggerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class XDebuggerManagerImpl
extends XDebuggerManager
implements NamedComponent,
PersistentStateComponent<XDebuggerState> {
    @NonNls
    public static final String COMPONENT_NAME = "XDebuggerManager";
    private final Project myProject;
    private final XBreakpointManagerImpl myBreakpointManager;
    private final XDebuggerWatchesManager myWatchesManager;
    private final Map<ProcessHandler, XDebugSessionImpl> mySessions;
    private final ExecutionPointHighlighter myExecutionPointHighlighter;
    private final AtomicReference<XDebugSessionImpl> myActiveSession = new AtomicReference();

    public XDebuggerManagerImpl(Project project2, StartupManager startupManager, MessageBus messageBus) {
        this.myProject = project2;
        this.myBreakpointManager = new XBreakpointManagerImpl(project2, this, startupManager);
        this.myWatchesManager = new XDebuggerWatchesManager();
        this.mySessions = new LinkedHashMap<ProcessHandler, XDebugSessionImpl>();
        this.myExecutionPointHighlighter = new ExecutionPointHighlighter(project2);
        MessageBusConnection messageBusConnection = messageBus.connect();
        messageBusConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentLoaded(@NotNull VirtualFile file2, @NotNull Document document) {
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, true);
            }

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, true);
            }
        });
        messageBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, false);
            }
        });
        this.myBreakpointManager.addBreakpointListener((XBreakpointListener<XBreakpoint<?>>)new XBreakpointAdapter<XBreakpoint<?>>(){

            public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
                XDebugSessionImpl session2;
                if (!(breakpoint instanceof XLineBreakpoint) && (session2 = XDebuggerManagerImpl.this.getCurrentSession()) != null && breakpoint.equals(session2.getActiveNonLineBreakpoint())) {
                    XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
                    breakpointBase.clearIcon();
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.updateGutterIcon(breakpointBase.createGutterIconRenderer());
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
                XDebugSessionImpl session2 = XDebuggerManagerImpl.this.getCurrentSession();
                if (session2 != null && breakpoint == session2.getActiveNonLineBreakpoint()) {
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.updateGutterIcon(null);
                }
            }
        });
        messageBusConnection.subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (descriptor != null && executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
                    XDebugSessionImpl session2 = (XDebugSessionImpl)XDebuggerManagerImpl.this.mySessions.get(descriptor.getProcessHandler());
                    if (session2 != null) {
                        session2.activateSession();
                    } else {
                        XDebuggerManagerImpl.this.setCurrentSession(null);
                    }
                }
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (descriptor != null && executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
                    XDebuggerManagerImpl.this.mySessions.remove(descriptor.getProcessHandler());
                }
            }
        });
    }

    private void updateExecutionPoint(@NotNull VirtualFile file2, boolean navigate) {
        if (file2.equals(this.myExecutionPointHighlighter.getCurrentFile())) {
            this.myExecutionPointHighlighter.update(navigate);
        }
    }

    @NotNull
    public XBreakpointManagerImpl getBreakpointManager() {
        return this.myBreakpointManager;
    }

    public XDebuggerWatchesManager getWatchesManager() {
        return this.myWatchesManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @NotNull
    public XDebugSession startSession(@NotNull ExecutionEnvironment environment, @NotNull XDebugProcessStarter processStarter) throws ExecutionException {
        return this.startSession(environment.getContentToReuse(), processStarter, new XDebugSessionImpl(environment, this));
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        return this.startSessionAndShowTab(sessionName, contentToReuse, false, starter);
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        return this.startSessionAndShowTab(sessionName, null, contentToReuse, showToolWindowOnSuspendOnly, starter);
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, Icon icon, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        XDebugSessionImpl session2 = this.startSession(contentToReuse, starter, new XDebugSessionImpl(null, this, sessionName, icon, showToolWindowOnSuspendOnly, contentToReuse));
        if (!showToolWindowOnSuspendOnly) {
            session2.showSessionTab();
        }
        ProcessHandler handler2 = session2.getDebugProcess().getProcessHandler();
        handler2.startNotify();
        return session2;
    }

    private XDebugSessionImpl startSession(@Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter processStarter, @NotNull XDebugSessionImpl session2) throws ExecutionException {
        XDebugProcess process2 = processStarter.start((XDebugSession)session2);
        ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).processStarted(process2);
        if (processStarter instanceof XDebugProcessConfiguratorStarter) {
            session2.activateSession();
            ((XDebugProcessConfiguratorStarter)processStarter).configure(session2.getSessionData());
        }
        session2.init(process2, contentToReuse);
        this.mySessions.put(session2.getDebugProcess().getProcessHandler(), session2);
        return session2;
    }

    public void removeSession(@NotNull XDebugSessionImpl session2) {
        XDebugSessionTab sessionTab = session2.getSessionTab();
        this.mySessions.remove(session2.getDebugProcess().getProcessHandler());
        if (sessionTab != null) {
            RunContentDescriptor descriptor = sessionTab.getRunContentDescriptor();
            if (descriptor != null) {
                Disposer.register((Disposable)descriptor, () -> this.mySessions.remove(session2.getDebugProcess().getProcessHandler()));
            }
            if (!this.myProject.isDisposed() && !ApplicationManager.getApplication().isUnitTestMode() && XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isHideDebuggerOnProcessTermination()) {
                ExecutionManager.getInstance((Project)this.myProject).getContentManager().hideRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), descriptor);
            }
        }
        if (this.myActiveSession.compareAndSet(session2, null)) {
            this.onActiveSessionChanged();
        }
    }

    void updateExecutionPoint(@Nullable XSourcePosition position, boolean nonTopFrame, @Nullable GutterIconRenderer gutterIconRenderer) {
        if (position != null) {
            this.myExecutionPointHighlighter.show(position, nonTopFrame, gutterIconRenderer);
        } else {
            this.myExecutionPointHighlighter.hide();
        }
    }

    private void onActiveSessionChanged() {
        this.myBreakpointManager.getLineBreakpointManager().queueAllBreakpointsUpdate();
    }

    @NotNull
    public XDebugSession[] getDebugSessions() {
        Collection<XDebugSessionImpl> sessions = this.mySessions.values();
        return sessions.toArray(new XDebugSessionImpl[sessions.size()]);
    }

    @Nullable
    public XDebugSession getDebugSession(@NotNull ExecutionConsole executionConsole) {
        for (XDebugSessionImpl debuggerSession : this.mySessions.values()) {
            RunContentDescriptor contentDescriptor;
            XDebugSessionTab sessionTab = debuggerSession.getSessionTab();
            if (sessionTab == null || (contentDescriptor = sessionTab.getRunContentDescriptor()) == null || executionConsole != contentDescriptor.getExecutionConsole()) continue;
            return debuggerSession;
        }
        return null;
    }

    @NotNull
    public <T extends XDebugProcess> List<? extends T> getDebugProcesses(Class<T> processClass) {
        SmartList list = null;
        for (XDebugSessionImpl session2 : this.mySessions.values()) {
            XDebugProcess process2 = session2.getDebugProcess();
            if (!processClass.isInstance(process2)) continue;
            if (list == null) {
                list = new SmartList();
            }
            list.add(processClass.cast(process2));
        }
        return ContainerUtil.notNullize(list);
    }

    @Nullable
    public XDebugSessionImpl getCurrentSession() {
        return this.myActiveSession.get();
    }

    void setCurrentSession(@Nullable XDebugSessionImpl session2) {
        boolean sessionChanged;
        boolean bl = sessionChanged = this.myActiveSession.getAndSet(session2) != session2;
        if (sessionChanged) {
            if (session2 != null) {
                XDebugSessionTab tab = session2.getSessionTab();
                if (tab != null) {
                    tab.select();
                }
            } else {
                this.myExecutionPointHighlighter.hide();
            }
            this.onActiveSessionChanged();
        }
    }

    public XDebuggerState getState() {
        return new XDebuggerState(this.myBreakpointManager.getState(), this.myWatchesManager.getState());
    }

    public boolean isFullLineHighlighter() {
        return this.myExecutionPointHighlighter.isFullLineHighlighter();
    }

    public void loadState(XDebuggerState state) {
        this.myBreakpointManager.loadState(state.myBreakpointManagerState);
        this.myWatchesManager.loadState(state.myWatchesManagerState);
    }

    public void showExecutionPosition() {
        this.myExecutionPointHighlighter.navigateTo();
    }

    public static class XDebuggerState {
        private XBreakpointManagerImpl.BreakpointManagerState myBreakpointManagerState;
        private XDebuggerWatchesManager.WatchesManagerState myWatchesManagerState;

        public XDebuggerState() {
        }

        public XDebuggerState(XBreakpointManagerImpl.BreakpointManagerState breakpointManagerState, XDebuggerWatchesManager.WatchesManagerState watchesManagerState) {
            this.myBreakpointManagerState = breakpointManagerState;
            this.myWatchesManagerState = watchesManagerState;
        }

        @Property(surroundWithTag=false)
        public XBreakpointManagerImpl.BreakpointManagerState getBreakpointManagerState() {
            return this.myBreakpointManagerState;
        }

        public void setBreakpointManagerState(XBreakpointManagerImpl.BreakpointManagerState breakpointManagerState) {
            this.myBreakpointManagerState = breakpointManagerState;
        }

        @Property(surroundWithTag=false)
        public XDebuggerWatchesManager.WatchesManagerState getWatchesManagerState() {
            return this.myWatchesManagerState;
        }

        public void setWatchesManagerState(XDebuggerWatchesManager.WatchesManagerState watchesManagerState) {
            this.myWatchesManagerState = watchesManagerState;
        }
    }
}

