/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.DebuggerToggleActionHandler;
import com.intellij.xdebugger.impl.actions.EditBreakpointActionHandler;
import com.intellij.xdebugger.impl.actions.MarkObjectActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerEditBreakpointActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XAddToWatchesFromEditorActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerMuteBreakpointsHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerPauseActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerRunToCursorActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerSmartStepIntoHandler;
import com.intellij.xdebugger.impl.actions.handlers.XEvaluateInConsoleFromEditorActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XMarkObjectActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XToggleLineBreakpointActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.evaluate.quick.XQuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import org.jetbrains.annotations.NotNull;

public class XDebuggerSupport
extends DebuggerSupport {
    private final XBreakpointPanelProvider myBreakpointPanelProvider;
    private final XToggleLineBreakpointActionHandler myToggleLineBreakpointActionHandler;
    private final XToggleLineBreakpointActionHandler myToggleTemporaryLineBreakpointActionHandler;
    private final XDebuggerSuspendedActionHandler myStepOverHandler;
    private final XDebuggerSuspendedActionHandler myStepIntoHandler;
    private final XDebuggerSuspendedActionHandler myStepOutHandler;
    private final XDebuggerSuspendedActionHandler myForceStepOverHandler;
    private final XDebuggerSuspendedActionHandler myForceStepIntoHandler;
    private final XDebuggerRunToCursorActionHandler myRunToCursorHandler;
    private final XDebuggerRunToCursorActionHandler myForceRunToCursor;
    private final XDebuggerActionHandler myResumeHandler;
    private final XDebuggerPauseActionHandler myPauseHandler;
    private final XDebuggerSuspendedActionHandler myShowExecutionPointHandler;
    private final XDebuggerEvaluateActionHandler myEvaluateHandler;
    private final XQuickEvaluateHandler myQuickEvaluateHandler;
    private final XAddToWatchesFromEditorActionHandler myAddToWatchesActionHandler;
    private final DebuggerActionHandler myEvaluateInConsoleActionHandler = new XEvaluateInConsoleFromEditorActionHandler();
    private final DebuggerToggleActionHandler myMuteBreakpointsHandler;
    private final DebuggerActionHandler mySmartStepIntoHandler;
    private final XMarkObjectActionHandler myMarkObjectActionHandler;
    private final EditBreakpointActionHandler myEditBreakpointActionHandler;

    public XDebuggerSupport() {
        this.myBreakpointPanelProvider = new XBreakpointPanelProvider();
        this.myToggleLineBreakpointActionHandler = new XToggleLineBreakpointActionHandler(false);
        this.myToggleTemporaryLineBreakpointActionHandler = new XToggleLineBreakpointActionHandler(true);
        this.myAddToWatchesActionHandler = new XAddToWatchesFromEditorActionHandler();
        this.myStepOverHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
                session2.stepOver(false);
            }
        };
        this.myStepIntoHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
                session2.stepInto();
            }
        };
        this.myStepOutHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
                session2.stepOut();
            }
        };
        this.myForceStepOverHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
                session2.stepOver(true);
            }
        };
        this.myForceStepIntoHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
                session2.forceStepInto();
            }
        };
        this.mySmartStepIntoHandler = new XDebuggerSmartStepIntoHandler();
        this.myRunToCursorHandler = new XDebuggerRunToCursorActionHandler(false);
        this.myForceRunToCursor = new XDebuggerRunToCursorActionHandler(true);
        this.myResumeHandler = new XDebuggerActionHandler(){

            @Override
            protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
                return session2.isPaused();
            }

            @Override
            protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
                session2.resume();
            }
        };
        this.myPauseHandler = new XDebuggerPauseActionHandler();
        this.myShowExecutionPointHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
                session2.showExecutionPoint();
            }
        };
        this.myMuteBreakpointsHandler = new XDebuggerMuteBreakpointsHandler();
        this.myEvaluateHandler = new XDebuggerEvaluateActionHandler();
        this.myQuickEvaluateHandler = new XQuickEvaluateHandler();
        this.myMarkObjectActionHandler = new XMarkObjectActionHandler();
        this.myEditBreakpointActionHandler = new XDebuggerEditBreakpointActionHandler();
    }

    @Override
    @NotNull
    public BreakpointPanelProvider<?> getBreakpointPanelProvider() {
        return this.myBreakpointPanelProvider;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepOverHandler() {
        return this.myStepOverHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepIntoHandler() {
        return this.myStepIntoHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getSmartStepIntoHandler() {
        return this.mySmartStepIntoHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepOutHandler() {
        return this.myStepOutHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceStepOverHandler() {
        return this.myForceStepOverHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceStepIntoHandler() {
        return this.myForceStepIntoHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getRunToCursorHandler() {
        return this.myRunToCursorHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceRunToCursorHandler() {
        return this.myForceRunToCursor;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getResumeActionHandler() {
        return this.myResumeHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getPauseHandler() {
        return this.myPauseHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getToggleLineBreakpointHandler() {
        return this.myToggleLineBreakpointActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getToggleTemporaryLineBreakpointHandler() {
        return this.myToggleTemporaryLineBreakpointActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getShowExecutionPointHandler() {
        return this.myShowExecutionPointHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getEvaluateHandler() {
        return this.myEvaluateHandler;
    }

    @Override
    @NotNull
    public QuickEvaluateHandler getQuickEvaluateHandler() {
        return this.myQuickEvaluateHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getAddToWatchesActionHandler() {
        return this.myAddToWatchesActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getEvaluateInConsoleActionHandler() {
        return this.myEvaluateInConsoleActionHandler;
    }

    @Override
    @NotNull
    public DebuggerToggleActionHandler getMuteBreakpointsHandler() {
        return this.myMuteBreakpointsHandler;
    }

    @Override
    @NotNull
    public MarkObjectActionHandler getMarkObjectHandler() {
        return this.myMarkObjectActionHandler;
    }

    @Override
    public AbstractDebuggerSession getCurrentSession(@NotNull Project project2) {
        return XDebuggerManager.getInstance((Project)project2).getCurrentSession();
    }

    @Override
    @NotNull
    public EditBreakpointActionHandler getEditBreakpointAction() {
        return this.myEditBreakpointActionHandler;
    }
}

