/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroupingRule;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class XDebuggerUtilImpl
extends XDebuggerUtil {
    private XLineBreakpointType<?>[] myLineBreakpointTypes;
    private Map<Class<? extends XBreakpointType>, XBreakpointType> myBreakpointTypeByClass;

    public XLineBreakpointType<?>[] getLineBreakpointTypes() {
        if (this.myLineBreakpointTypes == null) {
            this.myLineBreakpointTypes = (XLineBreakpointType[])XBreakpointUtil.breakpointTypes().select(XLineBreakpointType.class).toArray(XLineBreakpointType[]::new);
        }
        return this.myLineBreakpointTypes;
    }

    public void toggleLineBreakpoint(@NotNull Project project2, @NotNull VirtualFile file2, int line, boolean temporary) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XLineBreakpointType<?> typeWinner = null;
        for (XLineBreakpointType<?> type2 : this.getLineBreakpointTypes()) {
            if (!type2.canPutAt(file2, line, project2) || typeWinner != null && type2.getPriority() <= typeWinner.getPriority()) continue;
            typeWinner = type2;
        }
        if (typeWinner != null) {
            this.toggleLineBreakpoint(project2, typeWinner, file2, line, temporary);
        }
    }

    public boolean canPutBreakpointAt(@NotNull Project project2, @NotNull VirtualFile file2, int line) {
        return Arrays.stream(this.getLineBreakpointTypes()).anyMatch(type2 -> type2.canPutAt(file2, line, project2));
    }

    public <P extends XBreakpointProperties> void toggleLineBreakpoint(@NotNull Project project2, @NotNull XLineBreakpointType<P> type2, @NotNull VirtualFile file2, int line, boolean temporary) {
        XSourcePositionImpl position = XSourcePositionImpl.create(file2, line);
        if (position != null) {
            XDebuggerUtilImpl.toggleAndReturnLineBreakpoint(project2, type2, position, temporary, null, true);
        }
    }

    @NotNull
    public static <P extends XBreakpointProperties> Promise<XLineBreakpoint> toggleAndReturnLineBreakpoint(final @NotNull Project project2, final @NotNull XLineBreakpointType<P> type2, final @NotNull XSourcePosition position, final boolean temporary, final @Nullable Editor editor, final boolean canRemove) {
        return (Promise)new WriteAction<Promise<XLineBreakpoint>>(){

            protected void run(@NotNull Result<Promise<XLineBreakpoint>> result2) throws Throwable {
                final VirtualFile file2 = position.getFile();
                final int line = position.getLine();
                final XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
                XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(type2, file2, line);
                if (breakpoint != null) {
                    if (!temporary && canRemove) {
                        breakpointManager.removeBreakpoint((XBreakpoint)breakpoint);
                    }
                } else {
                    List variants = type2.computeVariants(project2, position);
                    if (!variants.isEmpty() && editor != null) {
                        RelativePoint relativePoint = DebuggerUIUtil.getPositionForPopup(editor, line);
                        if (variants.size() > 1 && relativePoint != null) {
                            final AsyncPromise res = new AsyncPromise();
                            int caretOffset = editor.getCaretModel().getOffset();
                            XLineBreakpointType.XLineBreakpointVariant defaultVariant = null;
                            for (XLineBreakpointType.XLineBreakpointVariant variant : variants) {
                                TextRange range = variant.getHighlightRange();
                                if (range == null || !range.contains(caretOffset) || defaultVariant != null && defaultVariant.getHighlightRange().getLength() <= range.getLength()) continue;
                                defaultVariant = variant;
                            }
                            final int defaultIndex = defaultVariant != null ? variants.indexOf(defaultVariant) : 0;
                            class MySelectionListener
                            implements ListSelectionListener {
                                RangeHighlighter myHighlighter = null;

                                MySelectionListener() {
                                }

                                @Override
                                public void valueChanged(ListSelectionEvent e) {
                                    if (!e.getValueIsAdjusting()) {
                                        this.updateHighlighter(((JList)e.getSource()).getSelectedValue());
                                    }
                                }

                                public void initialSet(Object value2) {
                                    if (this.myHighlighter == null) {
                                        this.updateHighlighter(value2);
                                    }
                                }

                                void updateHighlighter(Object value2) {
                                    this.clearHighlighter();
                                    if (value2 instanceof XLineBreakpointType.XLineBreakpointVariant) {
                                        TextRange range = ((XLineBreakpointType.XLineBreakpointVariant)value2).getHighlightRange();
                                        TextRange lineRange = DocumentUtil.getLineTextRange(editor.getDocument(), line);
                                        if ((range = range != null ? range.intersection(lineRange) : lineRange) != null && !range.isEmpty()) {
                                            EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
                                            TextAttributes attributes = scheme2.getAttributes(DebuggerColors.BREAKPOINT_ATTRIBUTES);
                                            this.myHighlighter = editor.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 3001, attributes, HighlighterTargetArea.EXACT_RANGE);
                                        }
                                    }
                                }

                                private void clearHighlighter() {
                                    if (this.myHighlighter != null) {
                                        this.myHighlighter.dispose();
                                    }
                                }
                            }
                            final MySelectionListener selectionListener = new MySelectionListener();
                            ListPopupImpl popup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<XLineBreakpointType.XLineBreakpointVariant>("Set Breakpoint", variants){
                                {
                                    super(arg0, arg1);
                                }

                                @NotNull
                                public String getTextFor(XLineBreakpointType.XLineBreakpointVariant value2) {
                                    return value2.getText();
                                }

                                public Icon getIconFor(XLineBreakpointType.XLineBreakpointVariant value2) {
                                    return value2.getIcon();
                                }

                                public void canceled() {
                                    selectionListener.clearHighlighter();
                                }

                                public PopupStep onChosen(XLineBreakpointType.XLineBreakpointVariant selectedValue, boolean finalChoice) {
                                    selectionListener.clearHighlighter();
                                    ApplicationManager.getApplication().runWriteAction(() -> {
                                        XBreakpointProperties properties = selectedValue.createProperties();
                                        res.setResult((Object)breakpointManager.addLineBreakpoint(type2, file2.getUrl(), line, properties, temporary));
                                    });
                                    return FINAL_CHOICE;
                                }

                                public int getDefaultOptionIndex() {
                                    return defaultIndex;
                                }
                            }){
                                {
                                    super(arg0);
                                }

                                @Override
                                protected void afterShow() {
                                    super.afterShow();
                                    selectionListener.initialSet(this.getList().getSelectedValue());
                                }
                            };
                            DebuggerUIUtil.registerExtraHandleShortcuts(popup, "ToggleLineBreakpoint");
                            popup.setAdText(DebuggerUIUtil.getSelectionShortcutsAdText("ToggleLineBreakpoint"));
                            popup.addListSelectionListener(selectionListener);
                            popup.show(relativePoint);
                            result2.setResult((Object)res);
                            return;
                        }
                        XBreakpointProperties properties = ((XLineBreakpointType.XLineBreakpointVariant)variants.get(0)).createProperties();
                        result2.setResult((Object)Promise.resolve((Object)breakpointManager.addLineBreakpoint(type2, file2.getUrl(), line, properties, temporary)));
                        return;
                    }
                    XBreakpointProperties properties = type2.createBreakpointProperties(file2, line);
                    result2.setResult((Object)Promise.resolve((Object)breakpointManager.addLineBreakpoint(type2, file2.getUrl(), line, properties, temporary)));
                    return;
                }
                result2.setResult((Object)Promises.rejectedPromise());
            }
        }.execute().getResultObject();
    }

    public void removeBreakpoint(final Project project2, final XBreakpoint<?> breakpoint) {
        new WriteAction(){

            protected void run(@NotNull Result result2) {
                XDebuggerManager.getInstance((Project)project2).getBreakpointManager().removeBreakpoint(breakpoint);
            }
        }.execute();
    }

    public <T extends XBreakpointType> T findBreakpointType(@NotNull Class<T> typeClass) {
        if (this.myBreakpointTypeByClass == null) {
            this.myBreakpointTypeByClass = XBreakpointUtil.breakpointTypes().toMap(Object::getClass, t -> t);
        }
        XBreakpointType type2 = this.myBreakpointTypeByClass.get(typeClass);
        return (T)type2;
    }

    public <T extends XDebuggerSettings<?>> T getDebuggerSettings(Class<T> aClass) {
        return XDebuggerSettingManagerImpl.getInstanceImpl().getSettings(aClass);
    }

    public XValueContainer getValueContainer(DataContext dataContext) {
        return XDebuggerTreeActionBase.getSelectedValue(dataContext);
    }

    @Nullable
    public XSourcePosition createPosition(VirtualFile file2, int line) {
        return XSourcePositionImpl.create(file2, line);
    }

    @Nullable
    public XSourcePosition createPosition(VirtualFile file2, int line, int column) {
        return XSourcePositionImpl.create(file2, line, column);
    }

    @Nullable
    public XSourcePosition createPositionByOffset(VirtualFile file2, int offset) {
        return XSourcePositionImpl.createByOffset(file2, offset);
    }

    @Nullable
    public XSourcePosition createPositionByElement(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        final VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return null;
        }
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        return new XSourcePosition(){
            private volatile XSourcePosition myDelegate;

            private XSourcePosition getDelegate() {
                if (this.myDelegate == null) {
                    this.myDelegate = (XSourcePosition)ReadAction.compute(() -> {
                        PsiElement elem = pointer.getElement();
                        return XSourcePositionImpl.createByOffset(pointer.getVirtualFile(), elem != null ? elem.getTextOffset() : -1);
                    });
                }
                return this.myDelegate;
            }

            public int getLine() {
                return this.getDelegate().getLine();
            }

            public int getOffset() {
                return this.getDelegate().getOffset();
            }

            @NotNull
            public VirtualFile getFile() {
                return file2;
            }

            @NotNull
            public Navigatable createNavigatable(@NotNull Project project2) {
                if (this.myDelegate != null) {
                    return this.myDelegate.createNavigatable(project2);
                }
                PsiElement elem = pointer.getElement();
                if (elem instanceof Navigatable) {
                    return (Navigatable)elem;
                }
                return NonNavigatable.INSTANCE;
            }
        };
    }

    public <B extends XLineBreakpoint<?>> XBreakpointGroupingRule<B, ?> getGroupingByFileRule() {
        return new XBreakpointFileGroupingRule();
    }

    @Nullable
    public static XSourcePosition getCaretPosition(@NotNull Project project2, DataContext context) {
        Editor editor = XDebuggerUtilImpl.getEditor(project2, context);
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        return XSourcePositionImpl.createByOffset(file2, offset);
    }

    @NotNull
    public static Collection<XSourcePosition> getAllCaretsPositions(@NotNull Project project2, DataContext context) {
        Editor editor = XDebuggerUtilImpl.getEditor(project2, context);
        if (editor == null) {
            return Collections.emptyList();
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        SmartList res = new SmartList();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            XSourcePositionImpl position = XSourcePositionImpl.createByOffset(file2, caret.getOffset());
            if (position == null) continue;
            res.add(position);
        }
        return res;
    }

    @Nullable
    private static Editor getEditor(@NotNull Project project2, DataContext context) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor == null) {
            return FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        }
        return editor;
    }

    public <B extends XBreakpoint<?>> Comparator<B> getDefaultBreakpointComparator(XBreakpointType<B, ?> type2) {
        return Comparator.comparing(arg_0 -> type2.getDisplayText(arg_0));
    }

    public <P extends XBreakpointProperties> Comparator<XLineBreakpoint<P>> getDefaultLineBreakpointComparator() {
        return (o1, o2) -> {
            int fileCompare = o1.getFileUrl().compareTo(o2.getFileUrl());
            if (fileCompare != 0) {
                return fileCompare;
            }
            return o1.getLine() - o2.getLine();
        };
    }

    @Nullable
    public static XDebuggerEvaluator getEvaluator(XSuspendContext suspendContext) {
        XStackFrame stackFrame;
        XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
        if (executionStack != null && (stackFrame = executionStack.getTopFrame()) != null) {
            return stackFrame.getEvaluator();
        }
        return null;
    }

    public void iterateLine(@NotNull Project project2, @NotNull Document document, int line, @NotNull Processor<PsiElement> processor2) {
        int lineEnd;
        int lineStart;
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (file2 == null) {
            return;
        }
        try {
            lineStart = document.getLineStartOffset(line);
            lineEnd = document.getLineEndOffset(line);
        }
        catch (IndexOutOfBoundsException ignored) {
            return;
        }
        int offset = lineStart;
        while (offset < lineEnd) {
            PsiElement element = file2.findElementAt(offset);
            if (element != null) {
                if (!processor2.process((Object)element)) {
                    return;
                }
                offset = element.getTextRange().getEndOffset();
                continue;
            }
            ++offset;
        }
    }

    public <B extends XLineBreakpoint<?>> List<XBreakpointGroupingRule<B, ?>> getGroupingByFileRuleAsList() {
        return Collections.singletonList(this.getGroupingByFileRule());
    }

    @Nullable
    public PsiElement findContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project2, boolean checkXml) {
        PsiLanguageInjectionHost parent;
        PsiElement element;
        PsiFile file2;
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        PsiFile psiFile = file2 = document == null ? null : PsiManager.getInstance((Project)project2).findFile(virtualFile);
        if (file2 == null) {
            return null;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > document.getTextLength()) {
            offset = document.getTextLength();
        }
        int startOffset = offset;
        int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
        PsiElement result2 = null;
        do {
            if ((element = file2.findElementAt(offset)) instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            result2 = element;
            break;
        } while ((offset = element.getTextRange().getEndOffset() + 1) < lineEndOffset);
        if (result2 == null) {
            result2 = file2.findElementAt(startOffset);
        }
        if (checkXml && result2 != null && StdFileTypes.XML.getLanguage().equals(result2.getLanguage()) && (parent = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)result2, PsiLanguageInjectionHost.class)) != null) {
            result2 = InjectedLanguageUtil.findElementInInjected(parent, offset);
        }
        return result2;
    }

    public void disableValueLookup(@NotNull Editor editor) {
        ValueLookupManager.DISABLE_VALUE_LOOKUP.set((UserDataHolder)editor, (Object)Boolean.TRUE);
    }

    @Nullable
    public static Editor createEditor(@NotNull OpenFileDescriptor descriptor) {
        return descriptor.canNavigate() ? FileEditorManager.getInstance((Project)descriptor.getProject()).openTextEditor(descriptor, false) : null;
    }

    public static void rebuildAllSessionsViews(@Nullable Project project2) {
        if (project2 == null) {
            return;
        }
        Arrays.stream(XDebuggerManager.getInstance((Project)project2).getDebugSessions()).filter(XDebugSession::isSuspended).forEach(XDebugSession::rebuildViews);
    }

    public static void rebuildTreeAndViews(XDebuggerTree tree) {
        if (tree.isDetached()) {
            tree.rebuildAndRestore(XDebuggerTreeState.saveState(tree));
        }
        XDebuggerUtilImpl.rebuildAllSessionsViews(tree.getProject());
    }

    @NotNull
    public XExpression createExpression(@NotNull String text, Language language, String custom, EvaluationMode mode) {
        return new XExpressionImpl(text, language, custom, mode);
    }

    public static boolean isEmptyExpression(@Nullable XExpression expression2) {
        return expression2 == null || StringUtil.isEmptyOrSpaces((String)expression2.getExpression());
    }
}

