/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.ui.StatusText;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.intellij.xdebugger.attach.XLocalAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XLocalAttachGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachToLocalProcessAction
extends AnAction {
    private static final Key<LinkedHashMap<String, HistoryItem>> HISTORY_KEY = Key.create((String)"AttachToLocalProcessAction.HISTORY_KEY");

    public AttachToLocalProcessAction() {
        super(XDebuggerBundle.message((String)"xdebugger.attach.toLocal.action", (Object[])new Object[0]), XDebuggerBundle.message((String)"xdebugger.attach.toLocal.action.description", (Object[])new Object[0]), AllIcons.Debugger.AttachToProcess);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project2 = AttachToLocalProcessAction.getEventProject((AnActionEvent)e);
        boolean enabled = project2 != null && ((XLocalAttachDebuggerProvider[])Extensions.getExtensions(XLocalAttachDebuggerProvider.EP)).length > 0;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project2 = AttachToLocalProcessAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return;
        }
        final XLocalAttachDebuggerProvider[] providers = (XLocalAttachDebuggerProvider[])Extensions.getExtensions(XLocalAttachDebuggerProvider.EP);
        new Task.Backgroundable(project2, XDebuggerBundle.message((String)"xdebugger.attach.toLocal.action.collectingProcesses", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                ProcessInfo[] processList = OSProcessUtil.getProcessList();
                List<AttachItem> items = AttachToLocalProcessAction.collectAttachItems(project2, processList, indicator, providers);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project2.isDisposed()) {
                        return;
                    }
                    ProcessListStep step = new ProcessListStep(items, project2);
                    ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
                    JList mainList = ((ListPopupImpl)popup).getList();
                    ListSelectionListener listener2 = event -> {
                        if (event.getValueIsAdjusting()) {
                            return;
                        }
                        Object item = ((JList)event.getSource()).getSelectedValue();
                        if (item == null) {
                            item = mainList.getSelectedValue();
                        }
                        if (item instanceof AttachItem) {
                            String debuggerName = ((AttachItem)item).getSelectedDebugger().getDebuggerDisplayName();
                            debuggerName = StringUtil.shortenTextWithEllipsis((String)debuggerName, (int)50, (int)0);
                            ((ListPopupImpl)popup).setCaption(XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.title", (Object[])new Object[]{debuggerName}));
                        }
                    };
                    popup.addListSelectionListener(listener2);
                    listener2.valueChanged(new ListSelectionEvent(mainList, mainList.getMinSelectionIndex(), mainList.getMaxSelectionIndex(), false));
                    popup.showCenteredInCurrentWindow(project2);
                });
            }
        }.queue();
    }

    @NotNull
    public static List<AttachItem> collectAttachItems(@NotNull Project project2, @NotNull ProcessInfo[] processList, @NotNull ProgressIndicator indicator, XLocalAttachDebuggerProvider ... providers) {
        MultiMap groupWithItems = new MultiMap();
        UserDataHolderBase dataHolder = new UserDataHolderBase();
        for (ProcessInfo eachInfo : processList) {
            MultiMap groupsWithDebuggers = new MultiMap();
            for (XLocalAttachDebuggerProvider eachProvider : providers) {
                indicator.checkCanceled();
                groupsWithDebuggers.putValues((Object)eachProvider.getAttachGroup(), eachProvider.getAvailableDebuggers(project2, eachInfo, (UserDataHolder)dataHolder));
            }
            for (XLocalAttachGroup eachGroup : groupsWithDebuggers.keySet()) {
                Collection debuggers = groupsWithDebuggers.get((Object)eachGroup);
                if (debuggers.isEmpty()) continue;
                groupWithItems.putValue((Object)eachGroup, (Object)Pair.create((Object)eachInfo, new ArrayList(debuggers)));
            }
        }
        ArrayList<XLocalAttachGroup> sortedGroups = new ArrayList<XLocalAttachGroup>(groupWithItems.keySet());
        sortedGroups.sort(Comparator.comparingInt(XLocalAttachGroup::getOrder));
        ArrayList<AttachItem> currentItems = new ArrayList<AttachItem>();
        for (XLocalAttachGroup eachGroup : sortedGroups) {
            ArrayList sortedItems = new ArrayList(groupWithItems.get((Object)eachGroup));
            sortedItems.sort((a, b) -> eachGroup.compare(project2, (ProcessInfo)a.first, (ProcessInfo)b.first, (UserDataHolder)dataHolder));
            boolean first = true;
            for (Pair eachItem : sortedItems) {
                currentItems.add(new AttachItem(eachGroup, first, (ProcessInfo)eachItem.first, (List)eachItem.second, (UserDataHolder)dataHolder));
                first = false;
            }
        }
        ArrayList<AttachItem> currentHistoryItems = new ArrayList<AttachItem>();
        List<HistoryItem> history = AttachToLocalProcessAction.getHistory(project2);
        for (int i2 = history.size() - 1; i2 >= 0; --i2) {
            HistoryItem eachHistoryItem = history.get(i2);
            for (AttachItem eachCurrentItem : currentItems) {
                boolean isSuitableItem;
                boolean bl = isSuitableItem = eachHistoryItem.getGroup().equals(eachCurrentItem.getGroup()) && eachHistoryItem.getProcessInfo().getCommandLine().equals(eachCurrentItem.getProcessInfo().getCommandLine());
                if (!isSuitableItem) continue;
                List<XLocalAttachDebugger> debuggers = eachCurrentItem.getDebuggers();
                int selectedDebugger = -1;
                for (int j = 0; j < debuggers.size(); ++j) {
                    XLocalAttachDebugger eachDebugger = debuggers.get(j);
                    if (!eachDebugger.getDebuggerDisplayName().equals(eachHistoryItem.getDebuggerName())) continue;
                    selectedDebugger = j;
                    break;
                }
                if (selectedDebugger == -1) continue;
                currentHistoryItems.add(new AttachItem(eachCurrentItem.getGroup(), currentHistoryItems.isEmpty(), XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.recent", (Object[])new Object[0]), eachCurrentItem.getProcessInfo(), debuggers, selectedDebugger, (UserDataHolder)dataHolder));
            }
        }
        currentHistoryItems.addAll(currentItems);
        return currentHistoryItems;
    }

    public static void addToHistory(@NotNull Project project2, @NotNull AttachItem item) {
        LinkedHashMap history = (LinkedHashMap)project2.getUserData(HISTORY_KEY);
        if (history == null) {
            history = new LinkedHashMap();
            project2.putUserData(HISTORY_KEY, (Object)history);
        }
        ProcessInfo processInfo = item.getProcessInfo();
        history.remove((Object)processInfo.getCommandLine());
        history.put((Object)processInfo.getCommandLine(), (Object)new HistoryItem(processInfo, item.getGroup(), item.getSelectedDebugger().getDebuggerDisplayName()));
        while (history.size() > 4) {
            history.remove(history.keySet().iterator().next());
        }
    }

    @NotNull
    public static List<HistoryItem> getHistory(@NotNull Project project2) {
        LinkedHashMap history = (LinkedHashMap)project2.getUserData(HISTORY_KEY);
        return history == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(history.values()));
    }

    private static class ProcessListStep
    extends MyBasePopupStep
    implements ListPopupStepEx<AttachItem> {
        public ProcessListStep(@NotNull List<AttachItem> items, @NotNull Project project2) {
            super(project2, XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.title.default", (Object[])new Object[0]), items);
        }

        @Nullable
        public ListSeparator getSeparatorAbove(AttachItem value2) {
            String separatorTitle = value2.getSeparatorTitle();
            return separatorTitle == null ? null : new ListSeparator(separatorTitle);
        }

        public Icon getIconFor(AttachItem value2) {
            return value2.getIcon(this.myProject);
        }

        @NotNull
        public String getTextFor(AttachItem value2) {
            return value2.getText(this.myProject);
        }

        @Nullable
        public String getTooltipTextFor(AttachItem value2) {
            return value2.getText(this.myProject);
        }

        public void setEmptyText(@NotNull StatusText emptyText) {
            emptyText.setText(XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.emptyText", (Object[])new Object[0]));
        }

        @Override
        public PopupStep onChosen(AttachItem selectedValue, boolean finalChoice) {
            if (finalChoice) {
                return super.onChosen(selectedValue, true);
            }
            return new DebuggerListStep(selectedValue.getSubItems(), selectedValue.mySelectedDebugger);
        }

        public PopupStep onChosen(AttachItem selectedValue, boolean finalChoice, int eventModifiers) {
            return this.onChosen(selectedValue, finalChoice);
        }

        private class DebuggerListStep
        extends MyBasePopupStep {
            public DebuggerListStep(List<AttachItem> items, int selectedItem) {
                super(ProcessListStep.this.myProject, XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.selectDebugger.title", (Object[])new Object[0]), items);
                this.setDefaultOptionIndex(selectedItem);
            }

            @NotNull
            public String getTextFor(AttachItem value2) {
                return value2.getSelectedDebugger().getDebuggerDisplayName();
            }
        }
    }

    private static class MyBasePopupStep
    extends BaseListPopupStep<AttachItem> {
        @NotNull
        final Project myProject;

        public MyBasePopupStep(@NotNull Project project2, @Nullable String title, List<? extends AttachItem> values) {
            super(title, values);
            this.myProject = project2;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        public boolean hasSubstep(AttachItem selectedValue) {
            return !selectedValue.getSubItems().isEmpty();
        }

        public PopupStep onChosen(AttachItem selectedValue, boolean finalChoice) {
            AttachToLocalProcessAction.addToHistory(this.myProject, selectedValue);
            return this.doFinalStep(() -> selectedValue.startDebugSession(this.myProject));
        }
    }

    public static class AttachItem {
        @NotNull
        private final XLocalAttachGroup myGroup;
        private final boolean myIsFirstInGroup;
        @NotNull
        private final String myGroupName;
        @NotNull
        private UserDataHolder myDataHolder;
        @NotNull
        private final ProcessInfo myProcessInfo;
        @NotNull
        private final List<XLocalAttachDebugger> myDebuggers;
        private final int mySelectedDebugger;
        @NotNull
        private final List<AttachItem> mySubItems;

        public AttachItem(@NotNull XLocalAttachGroup group, boolean isFirstInGroup, @NotNull ProcessInfo info, @NotNull List<XLocalAttachDebugger> debuggers, @NotNull UserDataHolder dataHolder) {
            this(group, isFirstInGroup, group.getGroupName(), info, debuggers, 0, dataHolder);
        }

        public AttachItem(@NotNull XLocalAttachGroup group, boolean isFirstInGroup, @NotNull String groupName, @NotNull ProcessInfo info, @NotNull List<XLocalAttachDebugger> debuggers, int selectedDebugger, @NotNull UserDataHolder dataHolder) {
            this.myGroupName = groupName;
            this.myDataHolder = dataHolder;
            assert (!debuggers.isEmpty()) : "debugger list should not be empty";
            assert (selectedDebugger >= 0 && selectedDebugger < debuggers.size()) : "wrong selected debugger index";
            this.myGroup = group;
            this.myIsFirstInGroup = isFirstInGroup;
            this.myProcessInfo = info;
            this.myDebuggers = debuggers;
            this.mySelectedDebugger = selectedDebugger;
            this.mySubItems = debuggers.size() > 1 ? ContainerUtil.map(debuggers, debugger -> new AttachItem(this.myGroup, false, this.myProcessInfo, Collections.singletonList(debugger), dataHolder)) : Collections.emptyList();
        }

        @NotNull
        public ProcessInfo getProcessInfo() {
            return this.myProcessInfo;
        }

        @NotNull
        public XLocalAttachGroup getGroup() {
            return this.myGroup;
        }

        @Nullable
        public String getSeparatorTitle() {
            return this.myIsFirstInGroup ? this.myGroupName : null;
        }

        @Nullable
        public Icon getIcon(@NotNull Project project2) {
            return this.myGroup.getProcessIcon(project2, this.myProcessInfo, this.myDataHolder);
        }

        @NotNull
        public String getText(@NotNull Project project2) {
            String shortenedText = StringUtil.shortenTextWithEllipsis((String)this.myGroup.getProcessDisplayText(project2, this.myProcessInfo, this.myDataHolder), (int)200, (int)0);
            return this.myProcessInfo.getPid() + " " + shortenedText;
        }

        @NotNull
        public List<XLocalAttachDebugger> getDebuggers() {
            return this.myDebuggers;
        }

        @NotNull
        public XLocalAttachDebugger getSelectedDebugger() {
            return this.myDebuggers.get(this.mySelectedDebugger);
        }

        @NotNull
        public List<AttachItem> getSubItems() {
            return this.mySubItems;
        }

        public void startDebugSession(@NotNull Project project2) {
            XLocalAttachDebugger debugger = this.getSelectedDebugger();
            UsageTrigger.trigger(ConvertUsagesUtil.ensureProperKey("debugger.attach.local"));
            UsageTrigger.trigger(ConvertUsagesUtil.ensureProperKey("debugger.attach.local." + debugger.getDebuggerDisplayName()));
            try {
                debugger.attachDebugSession(project2, this.myProcessInfo);
            }
            catch (ExecutionException e) {
                ExecutionUtil.handleExecutionError((Project)project2, (String)ToolWindowId.DEBUG, (String)this.myProcessInfo.getExecutableName(), (ExecutionException)e);
            }
        }
    }

    public static class HistoryItem {
        @NotNull
        private final ProcessInfo myProcessInfo;
        @NotNull
        private final XLocalAttachGroup myGroup;
        @NotNull
        private final String myDebuggerName;

        public HistoryItem(@NotNull ProcessInfo processInfo, @NotNull XLocalAttachGroup group, @NotNull String debuggerName) {
            this.myProcessInfo = processInfo;
            this.myGroup = group;
            this.myDebuggerName = debuggerName;
        }

        @NotNull
        public ProcessInfo getProcessInfo() {
            return this.myProcessInfo;
        }

        @NotNull
        public XLocalAttachGroup getGroup() {
            return this.myGroup;
        }

        @NotNull
        public String getDebuggerName() {
            return this.myDebuggerName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HistoryItem item = (HistoryItem)o;
            if (!this.myProcessInfo.equals(item.myProcessInfo)) {
                return false;
            }
            if (!this.myGroup.equals(item.myGroup)) {
                return false;
            }
            return this.myDebuggerName.equals(item.myDebuggerName);
        }

        public int hashCode() {
            int result2 = this.myProcessInfo.hashCode();
            result2 = 31 * result2 + this.myGroup.hashCode();
            result2 = 31 * result2 + this.myDebuggerName.hashCode();
            return result2;
        }
    }
}

