/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class XAddToWatchesFromEditorActionHandler
extends XDebuggerActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        Promise<String> textPromise = XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session2);
        if (textPromise.getState() != Promise.State.PENDING) {
            return true;
        }
        if (textPromise.getState() == Promise.State.REJECTED) {
            return false;
        }
        return textPromise.blockingGet(0) != null;
    }

    @NotNull
    protected static Promise<String> getTextToEvaluate(DataContext dataContext, XDebugSession session2) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return Promise.resolve(null);
        }
        String text = editor.getSelectionModel().getSelectedText();
        if (text != null) {
            return Promise.resolve((Object)StringUtil.nullize((String)text, (boolean)true));
        }
        XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
        if (evaluator != null) {
            return XDebuggerEvaluateActionHandler.getExpressionText(evaluator, editor.getProject(), editor).then(s -> StringUtil.nullize((String)s, (boolean)true));
        }
        return Promise.resolve(null);
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session2).done(text -> {
            if (text == null) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> ((XDebugSessionImpl)session2).getSessionTab().getWatchesView().addWatchExpression(XExpressionImpl.fromText(text), -1, true));
        });
    }
}

