/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class XDebuggerEvaluateActionHandler
extends XDebuggerActionHandler {
    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        String selectedText;
        XDebuggerEditorsProvider editorsProvider = session2.getDebugProcess().getEditorsProvider();
        XStackFrame stackFrame = session2.getCurrentStackFrame();
        XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        EvaluationMode mode = EvaluationMode.EXPRESSION;
        String string = selectedText = editor != null ? editor.getSelectionModel().getSelectedText() : null;
        if (selectedText != null) {
            selectedText = evaluator.formatTextForEvaluation(selectedText);
            mode = evaluator.getEvaluationMode(selectedText, editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext));
        }
        Promise<String> expressionTextPromise = Promise.resolve((Object)selectedText);
        if (selectedText == null && editor != null) {
            expressionTextPromise = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, (Project)CommonDataKeys.PROJECT.getData(dataContext), editor);
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        EvaluationMode finalMode = mode;
        XValue value2 = XDebuggerTreeActionBase.getSelectedValue(dataContext);
        expressionTextPromise.done(expressionText -> {
            if (expressionText == null && value2 != null) {
                value2.calculateEvaluationExpression().done(expression2 -> {
                    if (expression2 != null) {
                        AppUIUtil.invokeOnEdt(() -> XDebuggerEvaluateActionHandler.showDialog(session2, file2, editorsProvider, stackFrame, evaluator, expression2));
                    }
                });
            } else {
                XExpressionImpl expression3 = XExpressionImpl.fromText(StringUtil.notNullize((String)expressionText), finalMode);
                AppUIUtil.invokeOnEdt(() -> XDebuggerEvaluateActionHandler.showDialog(session2, file2, editorsProvider, stackFrame, evaluator, expression3));
            }
        });
    }

    private static void showDialog(@NotNull XDebugSession session2, VirtualFile file2, XDebuggerEditorsProvider editorsProvider, XStackFrame stackFrame, XDebuggerEvaluator evaluator, @NotNull XExpression expression2) {
        if (expression2.getLanguage() == null) {
            XSourcePosition position;
            Language language = null;
            if (stackFrame != null && (position = stackFrame.getSourcePosition()) != null) {
                language = LanguageUtil.getFileLanguage((VirtualFile)position.getFile());
            }
            if (language == null && file2 != null) {
                language = LanguageUtil.getFileTypeLanguage((FileType)file2.getFileType());
            }
            expression2 = new XExpressionImpl(expression2.getExpression(), language, expression2.getCustomInfo(), expression2.getMode());
        }
        new XDebuggerEvaluationDialog(session2, editorsProvider, evaluator, expression2, stackFrame == null ? null : stackFrame.getSourcePosition()).show();
    }

    @NotNull
    public static Promise<String> getExpressionText(@Nullable XDebuggerEvaluator evaluator, @Nullable Project project2, @NotNull Editor editor) {
        if (project2 == null || evaluator == null) {
            return Promise.resolve(null);
        }
        Document document = editor.getDocument();
        Promise expressionInfoPromise = evaluator.getExpressionInfoAtOffsetAsync(project2, document, editor.getCaretModel().getOffset(), true);
        return expressionInfoPromise.then(expressionInfo -> XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, document));
    }

    @Nullable
    public static String getExpressionText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (expressionInfo == null) {
            return null;
        }
        String text = expressionInfo.getExpressionText();
        return text == null ? document.getText(expressionInfo.getTextRange()) : text;
    }

    @Nullable
    public static String getDisplayText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (expressionInfo == null) {
            return null;
        }
        String text = expressionInfo.getDisplayText();
        return text == null ? document.getText(expressionInfo.getTextRange()) : text;
    }

    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        return session2.getDebugProcess().getEvaluator() != null;
    }
}

