/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.favoritesTreeView.AbstractFavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsSimpleTree;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointsFavoriteListProvider
extends AbstractFavoritesListProvider<Object>
implements BreakpointPanelProvider.BreakpointsListener {
    private final List<BreakpointPanelProvider> myBreakpointPanelProviders;
    private final BreakpointItemsTreeController myTreeController;
    private final List<XBreakpointGroupingRule> myRulesAvailable = new ArrayList<XBreakpointGroupingRule>();
    private final Set<XBreakpointGroupingRule> myRulesEnabled = new TreeSet<XBreakpointGroupingRule>(XBreakpointGroupingRule.PRIORITY_COMPARATOR);
    private final SingleAlarm myRebuildAlarm = new SingleAlarm(this::updateChildren, 100);
    private final FavoritesManager myFavoritesManager;

    public BreakpointsFavoriteListProvider(Project project2, FavoritesManager favoritesManager) {
        super(project2, "Breakpoints");
        this.myBreakpointPanelProviders = XBreakpointUtil.collectPanelProviders();
        this.myFavoritesManager = favoritesManager;
        this.myTreeController = new BreakpointItemsTreeController(this.myRulesAvailable);
        this.myTreeController.setTreeView((JTree)((Object)new BreakpointsSimpleTree(this.myProject, this.myTreeController)));
        for (BreakpointPanelProvider provider2 : this.myBreakpointPanelProviders) {
            provider2.addListener(this, this.myProject, (Disposable)this.myProject);
            provider2.createBreakpointsGroupingRules(this.myRulesAvailable);
        }
        this.updateChildren();
    }

    @Override
    public void breakpointsChanged() {
        this.myRebuildAlarm.cancelAndRequest();
    }

    private void getEnabledGroupingRules(Collection<XBreakpointGroupingRule> rules) {
        rules.clear();
        XBreakpointsDialogState settings = ((XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager()).getBreakpointsDialogSettings();
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (!rule.isAlwaysEnabled() && (settings == null || !settings.getSelectedGroupingRules().contains(rule.getId()))) continue;
            rules.add(rule);
        }
    }

    private void updateChildren() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myChildren.clear();
        ArrayList<BreakpointItem> items = new ArrayList<BreakpointItem>();
        for (BreakpointPanelProvider provider2 : this.myBreakpointPanelProviders) {
            provider2.provideBreakpointItems(this.myProject, items);
        }
        this.getEnabledGroupingRules(this.myRulesEnabled);
        this.myTreeController.setGroupingRules(this.myRulesEnabled);
        this.myTreeController.rebuildTree(items);
        CheckedTreeNode root = this.myTreeController.getRoot();
        for (int i2 = 0; i2 < root.getChildCount(); ++i2) {
            TreeNode child = root.getChildAt(i2);
            if (!(child instanceof DefaultMutableTreeNode)) continue;
            this.replicate((DefaultMutableTreeNode)child, this.myNode, this.myChildren);
        }
        this.myFavoritesManager.fireListeners(this.getListName(this.myProject));
    }

    private void replicate(DefaultMutableTreeNode source, AbstractTreeNode destination, List<AbstractTreeNode<Object>> destinationChildren) {
        final ArrayList<AbstractTreeNode<Object>> copyChildren = new ArrayList<AbstractTreeNode<Object>>();
        AbstractTreeNode<Object> copy = new AbstractTreeNode<Object>(this.myProject, source.getUserObject()){

            @NotNull
            public Collection<? extends AbstractTreeNode> getChildren() {
                return copyChildren;
            }

            protected void update(PresentationData presentation) {
            }
        };
        for (int i2 = 0; i2 < source.getChildCount(); ++i2) {
            TreeNode treeNode = source.getChildAt(i2);
            if (!(treeNode instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode sourceChild = (DefaultMutableTreeNode)treeNode;
            this.replicate(sourceChild, (AbstractTreeNode)copy, copyChildren);
        }
        if (BreakpointsFavoriteListProvider.checkNavigatable(copy)) {
            destinationChildren.add(copy);
            copy.setParent(destination);
        }
    }

    private static boolean checkNavigatable(AbstractTreeNode<?> node) {
        if (node.getValue() instanceof Navigatable && ((Navigatable)node.getValue()).canNavigate()) {
            return true;
        }
        Collection children2 = node.getChildren();
        for (AbstractTreeNode child : children2) {
            if (!BreakpointsFavoriteListProvider.checkNavigatable(child)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type2) {
        switch (type2) {
            case EDIT: {
                return "Edit breakpoint";
            }
            case REMOVE: {
                return "Remove breakpoint";
            }
        }
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type2, Project project2, @NotNull Set<Object> selectedObjects) {
        if (selectedObjects.size() >= 1 && type2 == CommonActionsPanel.Buttons.REMOVE) {
            for (Object selectedObject : selectedObjects) {
                if (((AbstractTreeNode)selectedObject).getValue() instanceof BreakpointItem) continue;
                return false;
            }
            return true;
        }
        return selectedObjects.size() == 1 && type2 == CommonActionsPanel.Buttons.EDIT && ((AbstractTreeNode)selectedObjects.iterator().next()).getValue() instanceof BreakpointItem;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type2, Project project2, @NotNull Set<Object> selectedObjects, JComponent component) {
        Rectangle bounds = component.getBounds();
        if (component instanceof JTree) {
            JTree tree = (JTree)component;
            bounds = tree.getRowBounds(tree.getLeadSelectionRow());
            bounds.y += bounds.height / 2;
            bounds = tree.getVisibleRect().intersection(bounds);
        }
        Point whereToShow = new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
        switch (type2) {
            case EDIT: {
                BreakpointItem breakpointItem = (BreakpointItem)((AbstractTreeNode)selectedObjects.iterator().next()).getValue();
                DebuggerSupport debuggerSupport = XBreakpointUtil.getDebuggerSupport(this.myProject, breakpointItem);
                if (debuggerSupport == null || breakpointItem == null) {
                    return;
                }
                debuggerSupport.getEditBreakpointAction().editBreakpoint(this.myProject, component, whereToShow, breakpointItem);
                break;
            }
            case REMOVE: {
                for (Object selectedObject : selectedObjects) {
                    BreakpointItem removeBreakpointItem = (BreakpointItem)((AbstractTreeNode)selectedObject).getValue();
                    removeBreakpointItem.removed(this.myProject);
                }
                break;
            }
        }
    }

    @Override
    public int getWeight() {
        return 200;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer, JTree tree, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.clear();
        renderer.setIcon(AllIcons.Debugger.Db_set_breakpoint);
        if (value2 instanceof BreakpointItem) {
            BreakpointItem breakpointItem = (BreakpointItem)value2;
            breakpointItem.setupGenericRenderer((SimpleColoredComponent)renderer, true);
        } else if (value2 instanceof XBreakpointGroup) {
            renderer.append(((XBreakpointGroup)value2).getName());
            renderer.setIcon(((XBreakpointGroup)value2).getIcon(expanded));
        } else if (value2 instanceof XBreakpointGroupingRule) {
            renderer.append(((XBreakpointGroupingRule)value2).getPresentableName());
        } else {
            renderer.append(String.valueOf(value2));
        }
    }
}

