/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointManagerImpl
implements XBreakpointManager,
PersistentStateComponent<BreakpointManagerState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
    public static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTER = new SkipDefaultValuesSerializationFilters();
    private final MultiValuesMap<XBreakpointType, XBreakpointBase<?, ?, ?>> myBreakpoints = new MultiValuesMap(true);
    private final Map<XBreakpointType, XBreakpointBase<?, ?, ?>> myDefaultBreakpoints = new LinkedHashMap();
    private final Map<XBreakpointType, BreakpointState<?, ?, ?>> myBreakpointsDefaults = new LinkedHashMap();
    private final Set<XBreakpointBase<?, ?, ?>> myAllBreakpoints = new HashSet();
    private final Map<XBreakpointType, EventDispatcher<XBreakpointListener>> myDispatchers = new HashMap<XBreakpointType, EventDispatcher<XBreakpointListener>>();
    private XBreakpointsDialogState myBreakpointsDialogSettings;
    private final EventDispatcher<XBreakpointListener> myAllBreakpointsDispatcher;
    private final XLineBreakpointManager myLineBreakpointManager;
    private final Project myProject;
    private final XDebuggerManagerImpl myDebuggerManager;
    private final XDependentBreakpointManager myDependentBreakpointManager;
    private long myTime;
    private String myDefaultGroup;

    public XBreakpointManagerImpl(Project project2, XDebuggerManagerImpl debuggerManager, StartupManager startupManager) {
        this.myProject = project2;
        this.myDebuggerManager = debuggerManager;
        this.myAllBreakpointsDispatcher = EventDispatcher.create(XBreakpointListener.class);
        this.myDependentBreakpointManager = new XDependentBreakpointManager(this);
        this.myLineBreakpointManager = new XLineBreakpointManager(project2, this.myDependentBreakpointManager, startupManager);
        if (!project2.isDefault()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HttpVirtualFileListener httpVirtualFileListener = this::updateBreakpointInFile;
                HttpFileSystem.getInstance().addFileListener(httpVirtualFileListener, (Disposable)project2);
            }
            XBreakpointUtil.breakpointTypes().forEach(this::addDefaultBreakpoint);
        }
    }

    private void updateBreakpointInFile(VirtualFile file2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            for (XBreakpointBase<?, ?, ?> breakpoint : this.getAllBreakpoints()) {
                XSourcePosition position = breakpoint.getSourcePosition();
                if (position == null || !Comparing.equal((Object)position.getFile(), (Object)file2)) continue;
                this.fireBreakpointChanged(breakpoint);
            }
        });
    }

    public XLineBreakpointManager getLineBreakpointManager() {
        return this.myLineBreakpointManager;
    }

    public XDependentBreakpointManager getDependentBreakpointManager() {
        return this.myDependentBreakpointManager;
    }

    public XDebuggerManagerImpl getDebuggerManager() {
        return this.myDebuggerManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public <T extends XBreakpointProperties> XBreakpoint<T> addBreakpoint(XBreakpointType<XBreakpoint<T>, T> type2, @Nullable T properties) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XBreakpointBase<?, T, ?> breakpoint = this.createBreakpoint(type2, properties, true, false);
        this.addBreakpoint(breakpoint, false, true);
        return breakpoint;
    }

    private <T extends XBreakpointProperties> XBreakpointBase<?, T, ?> createBreakpoint(XBreakpointType<XBreakpoint<T>, T> type2, T properties, boolean enabled, boolean defaultBreakpoint) {
        long l;
        String string = type2.getId();
        if (defaultBreakpoint) {
            l = 0L;
        } else {
            long l2 = this.myTime;
            l = l2;
            this.myTime = l2 + 1L;
        }
        BreakpointState state = new BreakpointState(enabled, string, l, type2.getDefaultSuspendPolicy());
        this.getBreakpointDefaults(type2).applyDefaults(state);
        state.setGroup(this.myDefaultGroup);
        return new XBreakpointBase(type2, this, properties, state);
    }

    private <T extends XBreakpointProperties> void addBreakpoint(XBreakpointBase<?, T, ?> breakpoint, boolean defaultBreakpoint, boolean initUI) {
        EventDispatcher<XBreakpointListener> dispatcher;
        XBreakpointType<?, T> type2 = breakpoint.getType();
        if (defaultBreakpoint) {
            LOG.assertTrue(!this.myDefaultBreakpoints.containsKey(type2), (Object)("Cannot have more than one default breakpoint (type " + type2.getId() + ")"));
            this.myDefaultBreakpoints.put(type2, breakpoint);
        } else {
            this.myBreakpoints.put(type2, breakpoint);
        }
        this.myAllBreakpoints.add(breakpoint);
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.registerBreakpoint((XLineBreakpointImpl)breakpoint, initUI);
        }
        if ((dispatcher = this.myDispatchers.get(type2)) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointAdded(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointAdded(breakpoint);
    }

    private XBreakpointListener<XBreakpoint<?>> getBreakpointDispatcherMulticaster() {
        return (XBreakpointListener)this.myAllBreakpointsDispatcher.getMulticaster();
    }

    public void fireBreakpointChanged(XBreakpointBase<?, ?, ?> breakpoint) {
        EventDispatcher<XBreakpointListener> dispatcher;
        if (!this.myAllBreakpoints.contains(breakpoint)) {
            return;
        }
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.breakpointChanged((XLineBreakpointImpl)breakpoint);
        }
        if ((dispatcher = this.myDispatchers.get(breakpoint.getType())) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointChanged(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointChanged(breakpoint);
    }

    public void removeBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.doRemoveBreakpoint(breakpoint);
    }

    private void doRemoveBreakpoint(XBreakpoint<?> breakpoint) {
        if (this.isDefaultBreakpoint(breakpoint)) {
            breakpoint.setEnabled(false);
        } else {
            XBreakpointType type2 = breakpoint.getType();
            XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
            this.myBreakpoints.remove((Object)type2, (Object)breakpointBase);
            this.myAllBreakpoints.remove(breakpointBase);
            if (breakpointBase instanceof XLineBreakpointImpl) {
                this.myLineBreakpointManager.unregisterBreakpoint((XLineBreakpointImpl)breakpointBase);
            }
            breakpointBase.dispose();
            EventDispatcher<XBreakpointListener> dispatcher = this.myDispatchers.get(type2);
            if (dispatcher != null) {
                ((XBreakpointListener)dispatcher.getMulticaster()).breakpointRemoved(breakpoint);
            }
            this.getBreakpointDispatcherMulticaster().breakpointRemoved(breakpoint);
        }
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type2, @NotNull String fileUrl, int line, @Nullable T properties) {
        return this.addLineBreakpoint(type2, fileUrl, line, properties, false);
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type2, @NotNull String fileUrl, int line, @Nullable T properties, boolean temporary) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LineBreakpointState state = new LineBreakpointState(true, type2.getId(), fileUrl, line, temporary, this.myTime++, type2.getDefaultSuspendPolicy());
        this.getBreakpointDefaults((XBreakpointType)type2).applyDefaults(state);
        state.setGroup(this.myDefaultGroup);
        XLineBreakpointImpl<T> breakpoint = new XLineBreakpointImpl<T>(type2, this, properties, state);
        this.addBreakpoint(breakpoint, false, true);
        return breakpoint;
    }

    @NotNull
    public XBreakpointBase<?, ?, ?>[] getAllBreakpoints() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myAllBreakpoints.toArray(new XBreakpointBase[this.myAllBreakpoints.size()]);
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull XBreakpointType<B, ?> type2) {
        Collection breakpoints;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<B> result2 = new ArrayList<B>();
        B defaultBreakpoint = this.getDefaultBreakpoint(type2);
        if (defaultBreakpoint != null) {
            result2.add(defaultBreakpoint);
        }
        if ((breakpoints = this.myBreakpoints.get(type2)) != null) {
            result2.addAll(breakpoints);
        }
        return Collections.unmodifiableList(result2);
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull Class<? extends XBreakpointType<B, ?>> typeClass) {
        XBreakpointType type2 = XDebuggerUtil.getInstance().findBreakpointType(typeClass);
        LOG.assertTrue(type2 != null, (Object)("Unregistered breakpoint type " + typeClass + ", registered: " + Arrays.toString(XBreakpointType.EXTENSION_POINT_NAME.getExtensions())));
        return this.getBreakpoints(type2);
    }

    @Nullable
    public <B extends XBreakpoint<?>> B getDefaultBreakpoint(@NotNull XBreakpointType<B, ?> type2) {
        return (B)this.myDefaultBreakpoints.get(type2);
    }

    @Nullable
    public <P extends XBreakpointProperties> XLineBreakpoint<P> findBreakpointAtLine(@NotNull XLineBreakpointType<P> type2, @NotNull VirtualFile file2, int line) {
        Collection breakpoints = this.myBreakpoints.get(type2);
        if (breakpoints == null) {
            return null;
        }
        for (XBreakpointBase breakpoint : breakpoints) {
            XLineBreakpoint lineBreakpoint = (XLineBreakpoint)breakpoint;
            if (!lineBreakpoint.getFileUrl().equals(file2.getUrl()) || lineBreakpoint.getLine() != line) continue;
            return lineBreakpoint;
        }
        return null;
    }

    public boolean isDefaultBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        return this.myDefaultBreakpoints.values().contains(breakpoint);
    }

    private <T extends XBreakpointProperties> EventDispatcher<XBreakpointListener> getOrCreateDispatcher(XBreakpointType<?, T> type2) {
        return this.myDispatchers.computeIfAbsent(type2, k -> EventDispatcher.create(XBreakpointListener.class));
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type2, @NotNull XBreakpointListener<B> listener2) {
        this.getOrCreateDispatcher(type2).addListener(listener2);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void removeBreakpointListener(@NotNull XBreakpointType<B, P> type2, @NotNull XBreakpointListener<B> listener2) {
        this.getOrCreateDispatcher(type2).removeListener(listener2);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type2, @NotNull XBreakpointListener<B> listener2, Disposable parentDisposable) {
        this.getOrCreateDispatcher(type2).addListener(listener2, parentDisposable);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2) {
        this.myAllBreakpointsDispatcher.addListener(listener2);
    }

    public void removeBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2) {
        this.myAllBreakpointsDispatcher.removeListener(listener2);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2, @NotNull Disposable parentDisposable) {
        this.myAllBreakpointsDispatcher.addListener(listener2, parentDisposable);
    }

    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon, @Nullable String errorMessage) {
        XLineBreakpointImpl lineBreakpoint = (XLineBreakpointImpl)breakpoint;
        CustomizedBreakpointPresentation presentation = lineBreakpoint.getCustomizedPresentation();
        if (presentation == null) {
            if (icon == null && errorMessage == null) {
                return;
            }
            presentation = new CustomizedBreakpointPresentation();
        } else if (Comparing.equal((Object)presentation.getIcon(), (Object)icon) && Comparing.strEqual((String)presentation.getErrorMessage(), (String)errorMessage)) {
            return;
        }
        presentation.setErrorMessage(errorMessage);
        presentation.setIcon(icon);
        lineBreakpoint.setCustomizedPresentation(presentation);
        this.myLineBreakpointManager.queueBreakpointUpdate((XBreakpoint<?>)breakpoint);
    }

    public BreakpointManagerState getState() {
        this.myDependentBreakpointManager.saveState();
        BreakpointManagerState state = new BreakpointManagerState();
        for (XBreakpointBase<?, ?, ?> xBreakpointBase : this.myDefaultBreakpoints.values()) {
            Object breakpointState = xBreakpointBase.getState();
            if (!this.differsFromDefault((XBreakpointType)xBreakpointBase.getType(), (BreakpointState)breakpointState)) continue;
            state.getDefaultBreakpoints().add((BreakpointState)breakpointState);
        }
        for (XBreakpointBase<Object, Object, Object> xBreakpointBase : this.myBreakpoints.values()) {
            state.getBreakpoints().add((BreakpointState)xBreakpointBase.getState());
        }
        for (Map.Entry entry : this.myBreakpointsDefaults.entrySet()) {
            if (!XBreakpointManagerImpl.statesAreDifferent((BreakpointState)entry.getValue(), XBreakpointManagerImpl.createBreakpointDefaults((XBreakpointType)entry.getKey()))) continue;
            state.getBreakpointsDefaults().add((BreakpointState)entry.getValue());
        }
        state.setBreakpointsDialogProperties(this.myBreakpointsDialogSettings);
        state.setTime(this.myTime);
        state.setDefaultGroup(this.myDefaultGroup);
        return state;
    }

    private <P extends XBreakpointProperties> boolean differsFromDefault(XBreakpointType<?, P> type2, BreakpointState state) {
        XBreakpoint<P> defaultBreakpoint = this.createDefaultBreakpoint(type2);
        if (defaultBreakpoint == null) {
            return false;
        }
        Object defaultState = ((XBreakpointBase)defaultBreakpoint).getState();
        return XBreakpointManagerImpl.statesAreDifferent(state, defaultState);
    }

    private static boolean statesAreDifferent(BreakpointState state1, BreakpointState state2) {
        Element elem2;
        Element elem1 = XmlSerializer.serialize((Object)state1, (SerializationFilter)SERIALIZATION_FILTER);
        return !JDOMUtil.areElementsEqual((Element)elem1, (Element)(elem2 = XmlSerializer.serialize((Object)state2, (SerializationFilter)SERIALIZATION_FILTER)));
    }

    public void loadState(BreakpointManagerState state) {
        this.myBreakpointsDialogSettings = state.getBreakpointsDialogProperties();
        this.myAllBreakpoints.clear();
        this.myDefaultBreakpoints.clear();
        this.myBreakpointsDefaults.clear();
        ApplicationManager.getApplication().runReadAction(() -> {
            state.getDefaultBreakpoints().forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, true));
            ((StreamEx)XBreakpointUtil.breakpointTypes().remove(this.myDefaultBreakpoints::containsKey)).forEach(this::addDefaultBreakpoint);
            this.myBreakpoints.values().forEach(this::doRemoveBreakpoint);
            state.getBreakpoints().forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, false));
            for (BreakpointState defaults : state.getBreakpointsDefaults()) {
                XBreakpointType<?, ?> type2 = XBreakpointUtil.findType(defaults.getTypeId());
                if (type2 != null) {
                    this.myBreakpointsDefaults.put(type2, defaults);
                    continue;
                }
                LOG.warn("Unknown breakpoint type " + defaults.getTypeId());
            }
            this.myDependentBreakpointManager.loadState();
        });
        this.myLineBreakpointManager.updateBreakpointsUI();
        this.myTime = state.getTime();
        this.myDefaultGroup = state.getDefaultGroup();
    }

    private <P extends XBreakpointProperties> void addDefaultBreakpoint(XBreakpointType<?, P> type2) {
        XBreakpoint<P> breakpoint = this.createDefaultBreakpoint(type2);
        if (breakpoint != null) {
            this.addBreakpoint((XBreakpointBase)breakpoint, true, false);
        }
    }

    @Nullable
    private <P extends XBreakpointProperties> XBreakpoint<P> createDefaultBreakpoint(XBreakpointType<? extends XBreakpoint<P>, P> type2) {
        return type2.createDefaultBreakpoint(properties -> this.createBreakpoint(type2, properties, false, true));
    }

    private void loadBreakpoint(BreakpointState breakpointState, boolean defaultBreakpoint) {
        XBreakpointBase<?, ?, ?> breakpoint = this.createBreakpoint(breakpointState);
        if (breakpoint != null) {
            this.addBreakpoint(breakpoint, defaultBreakpoint, false);
        }
    }

    public XBreakpointsDialogState getBreakpointsDialogSettings() {
        return this.myBreakpointsDialogSettings;
    }

    public void setBreakpointsDialogSettings(XBreakpointsDialogState breakpointsDialogSettings) {
        this.myBreakpointsDialogSettings = breakpointsDialogSettings;
    }

    public Set<String> getAllGroups() {
        return ((StreamEx)StreamEx.of(this.myAllBreakpoints).map(XBreakpointBase::getGroup).nonNull()).toSet();
    }

    public String getDefaultGroup() {
        return this.myDefaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.myDefaultGroup = defaultGroup;
    }

    @Nullable
    private XBreakpointBase<?, ?, ?> createBreakpoint(BreakpointState breakpointState) {
        XBreakpointType<?, ?> type2 = XBreakpointUtil.findType(breakpointState.getTypeId());
        if (type2 == null) {
            LOG.warn("Unknown breakpoint type " + breakpointState.getTypeId());
            return null;
        }
        return breakpointState.createBreakpoint(type2, this);
    }

    @NotNull
    public BreakpointState getBreakpointDefaults(@NotNull XBreakpointType type2) {
        return this.myBreakpointsDefaults.computeIfAbsent(type2, k -> XBreakpointManagerImpl.createBreakpointDefaults(type2));
    }

    @NotNull
    private static BreakpointState createBreakpointDefaults(@NotNull XBreakpointType type2) {
        BreakpointState state = new BreakpointState();
        state.setTypeId(type2.getId());
        state.setSuspendPolicy(type2.getDefaultSuspendPolicy());
        return state;
    }

    @Tag(value="breakpoint-manager")
    public static class BreakpointManagerState {
        private List<BreakpointState> myDefaultBreakpoints = new ArrayList<BreakpointState>();
        private List<BreakpointState> myBreakpoints = new ArrayList<BreakpointState>();
        private List<BreakpointState> myBreakpointsDefaults = new ArrayList<BreakpointState>();
        private XBreakpointsDialogState myBreakpointsDialogProperties;
        private long myTime;
        private String myDefaultGroup;

        @Tag(value="default-breakpoints")
        @AbstractCollection(surroundWithTag=false)
        public List<BreakpointState> getDefaultBreakpoints() {
            return this.myDefaultBreakpoints;
        }

        @Tag(value="breakpoints")
        @AbstractCollection(surroundWithTag=false, elementTypes={BreakpointState.class, LineBreakpointState.class})
        public List<BreakpointState> getBreakpoints() {
            return this.myBreakpoints;
        }

        @Tag(value="breakpoints-defaults")
        @AbstractCollection(surroundWithTag=false, elementTypes={BreakpointState.class, LineBreakpointState.class})
        public List<BreakpointState> getBreakpointsDefaults() {
            return this.myBreakpointsDefaults;
        }

        @Tag(value="breakpoints-dialog")
        public XBreakpointsDialogState getBreakpointsDialogProperties() {
            return this.myBreakpointsDialogProperties;
        }

        public void setBreakpoints(List<BreakpointState> breakpoints) {
            this.myBreakpoints = breakpoints;
        }

        public void setDefaultBreakpoints(List<BreakpointState> defaultBreakpoints) {
            this.myDefaultBreakpoints = defaultBreakpoints;
        }

        public void setBreakpointsDefaults(List<BreakpointState> breakpointsDefaults) {
            this.myBreakpointsDefaults = breakpointsDefaults;
        }

        public void setBreakpointsDialogProperties(XBreakpointsDialogState breakpointsDialogProperties) {
            this.myBreakpointsDialogProperties = breakpointsDialogProperties;
        }

        public long getTime() {
            return this.myTime;
        }

        public void setTime(long time) {
            this.myTime = time;
        }

        public String getDefaultGroup() {
            return this.myDefaultGroup;
        }

        public void setDefaultGroup(String defaultGroup) {
            this.myDefaultGroup = defaultGroup;
        }
    }
}

