/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.actions.ExpandRegionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class XBreakpointUtil {
    private XBreakpointUtil() {
    }

    public static <B extends XBreakpoint> String getShortText(B breakpoint) {
        return StringUtil.shortenTextWithEllipsis((String)StringUtil.notNullize((String)breakpoint.getType().getShortText(breakpoint)), (int)70, (int)5);
    }

    public static <B extends XBreakpoint> String getDisplayText(@NotNull B breakpoint) {
        return breakpoint.getType().getDisplayText(breakpoint);
    }

    @Nullable
    public static XBreakpointType<?, ?> findType(@NotNull @NonNls String id) {
        return ((StreamEx)XBreakpointUtil.breakpointTypes().filter(breakpointType -> id.equals(breakpointType.getId()))).findFirst().orElse(null);
    }

    public static StreamEx<XBreakpointType> breakpointTypes() {
        return StreamEx.of((Object[])XBreakpointType.EXTENSION_POINT_NAME.getExtensions());
    }

    @NotNull
    public static Pair<GutterIconRenderer, Object> findSelectedBreakpoint(@NotNull Project project2, @NotNull Editor editor) {
        DebuggerSupport[] debuggerSupports;
        int offset = editor.getCaretModel().getOffset();
        Document editorDocument = editor.getDocument();
        for (DebuggerSupport debuggerSupport : debuggerSupports = DebuggerSupport.getDebuggerSupports()) {
            Object breakpoint;
            BreakpointPanelProvider<?> provider2 = debuggerSupport.getBreakpointPanelProvider();
            int textLength = editor.getDocument().getTextLength();
            if (offset > textLength) {
                offset = textLength;
            }
            if ((breakpoint = provider2.findBreakpoint(project2, editorDocument, offset)) == null) continue;
            GutterIconRenderer iconRenderer = provider2.getBreakpointGutterIconRenderer(breakpoint);
            return Pair.create((Object)iconRenderer, breakpoint);
        }
        return Pair.create(null, null);
    }

    public static List<BreakpointPanelProvider> collectPanelProviders() {
        ArrayList<BreakpointPanelProvider> panelProviders = new ArrayList<BreakpointPanelProvider>();
        for (DebuggerSupport debuggerSupport : DebuggerSupport.getDebuggerSupports()) {
            panelProviders.add(debuggerSupport.getBreakpointPanelProvider());
        }
        panelProviders.sort((o1, o2) -> o2.getPriority() - o1.getPriority());
        return panelProviders;
    }

    @Nullable
    public static DebuggerSupport getDebuggerSupport(Project project2, BreakpointItem breakpointItem) {
        DebuggerSupport[] debuggerSupports = DebuggerSupport.getDebuggerSupports();
        ArrayList<BreakpointItem> items = new ArrayList<BreakpointItem>();
        for (DebuggerSupport support : debuggerSupports) {
            support.getBreakpointPanelProvider().provideBreakpointItems(project2, items);
            if (items.contains(breakpointItem)) {
                return support;
            }
            items.clear();
        }
        return null;
    }

    @NotNull
    public static Promise<XLineBreakpoint> toggleLineBreakpoint(@NotNull Project project2, @NotNull XSourcePosition position, @Nullable Editor editor, boolean temporary, boolean moveCaret, boolean canRemove) {
        FoldRegion region;
        int lineStart = position.getLine();
        VirtualFile file2 = position.getFile();
        int linesEnd = lineStart;
        if (editor != null && (region = FoldingUtil.findFoldRegionStartingAtLine(editor, lineStart)) != null && !region.isExpanded()) {
            linesEnd = region.getDocument().getLineNumber(region.getEndOffset());
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        XLineBreakpointType[] lineTypes = XDebuggerUtil.getInstance().getLineBreakpointTypes();
        XLineBreakpointType typeWinner = null;
        int lineWinner = -1;
        for (int line = lineStart; line <= linesEnd; ++line) {
            int maxPriority = 0;
            for (XLineBreakpointType type2 : lineTypes) {
                maxPriority = Math.max(maxPriority, type2.getPriority());
                XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(type2, file2, line);
                if (!type2.canPutAt(file2, line, project2) && breakpoint == null || typeWinner != null && type2.getPriority() <= typeWinner.getPriority()) continue;
                typeWinner = type2;
                lineWinner = line;
            }
            if (typeWinner != null && typeWinner.getPriority() == maxPriority) break;
        }
        if (typeWinner != null) {
            XSourcePosition winPosition;
            Object object = winPosition = lineStart == lineWinner ? position : XSourcePositionImpl.create(file2, lineWinner);
            if (winPosition != null) {
                Promise<XLineBreakpoint> res = XDebuggerUtilImpl.toggleAndReturnLineBreakpoint(project2, typeWinner, winPosition, temporary, editor, canRemove);
                if (editor != null && lineStart != lineWinner) {
                    int offset = editor.getDocument().getLineStartOffset(lineWinner);
                    ExpandRegionAction.expandRegionAtOffset(project2, editor, offset);
                    if (moveCaret) {
                        editor.getCaretModel().moveToOffset(offset);
                    }
                }
                return res;
            }
        }
        return Promises.rejectedPromise();
    }
}

