/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.tree;

import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsCheckboxTree;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsGroupNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointItemsTreeController
implements BreakpointsCheckboxTree.Delegate {
    private final TreeNodeComparator myComparator = new TreeNodeComparator();
    private final CheckedTreeNode myRoot;
    private final Map<BreakpointItem, BreakpointItemNode> myNodes = new HashMap<BreakpointItem, BreakpointItemNode>();
    private List<XBreakpointGroupingRule> myGroupingRules;
    private final MultiValuesMap<XBreakpointGroupingRule, XBreakpointGroup> myGroups = new MultiValuesMap();
    private JTree myTreeView;
    protected boolean myInBuild;

    public BreakpointItemsTreeController(Collection<XBreakpointGroupingRule> groupingRules) {
        this.myRoot = new CheckedTreeNode((Object)"root");
        this.setGroupingRulesInternal(groupingRules);
    }

    public JTree getTreeView() {
        return this.myTreeView;
    }

    public void setTreeView(JTree treeView) {
        this.myTreeView = treeView;
        this.myTreeView.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                BreakpointItemsTreeController.this.selectionChanged();
            }
        });
        if (treeView instanceof BreakpointsCheckboxTree) {
            ((BreakpointsCheckboxTree)((Object)treeView)).setDelegate(this);
        }
        this.myTreeView.setShowsRootHandles(!this.myGroupingRules.isEmpty());
    }

    protected void selectionChanged() {
        if (this.myInBuild) {
            return;
        }
        this.selectionChangedImpl();
    }

    protected void selectionChangedImpl() {
    }

    @Override
    public void nodeStateDidChange(CheckedTreeNode node) {
        if (this.myInBuild) {
            return;
        }
        this.nodeStateDidChangeImpl(node);
    }

    protected void nodeStateDidChangeImpl(CheckedTreeNode node) {
        if (node instanceof BreakpointItemNode) {
            ((BreakpointItemNode)node).getBreakpointItem().setEnabled(node.isChecked());
        }
    }

    @Override
    public void nodeStateWillChange(CheckedTreeNode node) {
        if (this.myInBuild) {
            return;
        }
        this.nodeStateWillChangeImpl(node);
    }

    protected void nodeStateWillChangeImpl(CheckedTreeNode node) {
    }

    private void setGroupingRulesInternal(Collection<XBreakpointGroupingRule> groupingRules) {
        this.myGroupingRules = new ArrayList<XBreakpointGroupingRule>(groupingRules);
    }

    public void buildTree(@NotNull Collection<? extends BreakpointItem> breakpoints) {
        TreeState state = TreeState.createOn((JTree)this.myTreeView, (DefaultMutableTreeNode)this.myRoot);
        this.myRoot.removeAllChildren();
        this.myNodes.clear();
        this.myGroups.clear();
        for (BreakpointItem breakpointItem : breakpoints) {
            BreakpointItemNode node = new BreakpointItemNode(breakpointItem);
            CheckedTreeNode parent = this.getParentNode(breakpointItem);
            parent.add((MutableTreeNode)((Object)node));
            this.myNodes.put(breakpointItem, node);
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (Comparator)this.myComparator);
        this.myInBuild = true;
        ((DefaultTreeModel)this.myTreeView.getModel()).nodeStructureChanged((TreeNode)this.myRoot);
        state.applyTo(this.myTreeView, (DefaultMutableTreeNode)this.myRoot);
        this.myInBuild = false;
    }

    @NotNull
    private CheckedTreeNode getParentNode(BreakpointItem breakpoint) {
        CheckedTreeNode parent = this.myRoot;
        for (int i2 = 0; i2 < this.myGroupingRules.size(); ++i2) {
            XBreakpointGroup group = this.myGroupingRules.get(i2).getGroup(breakpoint.getBreakpoint(), Collections.emptyList());
            if (group == null) continue;
            parent = BreakpointItemsTreeController.getOrCreateGroupNode(parent, group, i2);
            if (!breakpoint.isEnabled()) continue;
            parent.setChecked(true);
        }
        return parent;
    }

    private static Collection<XBreakpointGroup> getGroupNodes(CheckedTreeNode parent) {
        ArrayList<XBreakpointGroup> nodes = new ArrayList<XBreakpointGroup>();
        Enumeration children2 = parent.children();
        while (children2.hasMoreElements()) {
            Object element = children2.nextElement();
            if (!(element instanceof BreakpointsGroupNode)) continue;
            nodes.add((XBreakpointGroup)((BreakpointsGroupNode)((Object)element)).getGroup());
        }
        return nodes;
    }

    private static BreakpointsGroupNode getOrCreateGroupNode(CheckedTreeNode parent, XBreakpointGroup group, int level) {
        Enumeration children2 = parent.children();
        while (children2.hasMoreElements()) {
            Object groupFound;
            Object element = children2.nextElement();
            if (!(element instanceof BreakpointsGroupNode) || !(groupFound = ((BreakpointsGroupNode)((Object)element)).getGroup()).equals((Object)group)) continue;
            return (BreakpointsGroupNode)((Object)element);
        }
        BreakpointsGroupNode<XBreakpointGroup> groupNode = new BreakpointsGroupNode<XBreakpointGroup>(group, level);
        parent.add(groupNode);
        return groupNode;
    }

    public void setGroupingRules(Collection<XBreakpointGroupingRule> groupingRules) {
        this.setGroupingRulesInternal(groupingRules);
        this.rebuildTree(new ArrayList<BreakpointItem>(this.myNodes.keySet()));
    }

    public void rebuildTree(Collection<BreakpointItem> items) {
        List<BreakpointItem> selectedBreakpoints = this.getSelectedBreakpoints(false);
        TreePath path = this.myTreeView.getSelectionPath();
        this.buildTree(items);
        if (this.myTreeView.getRowForPath(path) == -1 && !selectedBreakpoints.isEmpty()) {
            this.selectBreakpointItem(selectedBreakpoints.get(0), path);
        } else {
            this.selectBreakpointItem(null, path);
        }
    }

    public List<BreakpointItem> getSelectedBreakpoints(boolean traverse) {
        TreePath[] selectionPaths = this.myTreeView.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<BreakpointItem> list = new ArrayList<BreakpointItem>();
        for (TreePath selectionPath : selectionPaths) {
            TreeNode startNode = (TreeNode)selectionPath.getLastPathComponent();
            if (traverse) {
                TreeUtil.traverseDepth((TreeNode)startNode, node -> {
                    if (node instanceof BreakpointItemNode) {
                        list.add(((BreakpointItemNode)((Object)((Object)node))).getBreakpointItem());
                    }
                    return true;
                });
                continue;
            }
            if (!(startNode instanceof BreakpointItemNode)) continue;
            list.add(((BreakpointItemNode)((Object)startNode)).getBreakpointItem());
        }
        return list;
    }

    public void selectBreakpointItem(@Nullable BreakpointItem breakpoint, TreePath path) {
        BreakpointItemNode node = this.myNodes.get(breakpoint);
        if (node != null) {
            TreeUtil.selectNode((JTree)this.myTreeView, (TreeNode)((Object)node));
        } else {
            TreeUtil.selectPath((JTree)this.myTreeView, (TreePath)path);
        }
    }

    public CheckedTreeNode getRoot() {
        return this.myRoot;
    }

    public void selectFirstBreakpointItem() {
        TreeUtil.selectPath((JTree)this.myTreeView, (TreePath)TreeUtil.getFirstLeafNodePath((JTree)this.myTreeView));
    }

    public void removeSelectedBreakpoints(Project project2) {
        TreePath[] paths = this.myTreeView.getSelectionPaths();
        if (paths == null) {
            return;
        }
        List<BreakpointItem> breakpoints = this.getSelectedBreakpoints(true);
        for (TreePath path : paths) {
            BreakpointItem item;
            Object node = path.getLastPathComponent();
            if (!(node instanceof BreakpointItemNode) || (item = ((BreakpointItemNode)((Object)node)).getBreakpointItem()).allowedToRemove()) continue;
            TreeUtil.unselect((JTree)this.myTreeView, (DefaultMutableTreeNode)((DefaultMutableTreeNode)node));
            breakpoints.remove(item);
        }
        if (breakpoints.isEmpty()) {
            return;
        }
        TreeUtil.removeSelected((JTree)this.myTreeView);
        for (BreakpointItem breakpoint : breakpoints) {
            breakpoint.removed(project2);
        }
    }

    private static class TreeNodeComparator
    implements Comparator<TreeNode> {
        private TreeNodeComparator() {
        }

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            if (o1 instanceof BreakpointItemNode && o2 instanceof BreakpointItemNode) {
                BreakpointItem b1 = ((BreakpointItemNode)((Object)o1)).getBreakpointItem();
                BreakpointItem b2 = ((BreakpointItemNode)((Object)o2)).getBreakpointItem();
                boolean default1 = b1.isDefaultBreakpoint();
                boolean default2 = b2.isDefaultBreakpoint();
                if (default1 && !default2) {
                    return -1;
                }
                if (!default1 && default2) {
                    return 1;
                }
                return b1.compareTo(b2);
            }
            if (o1 instanceof BreakpointsGroupNode && o2 instanceof BreakpointsGroupNode) {
                BreakpointsGroupNode group1 = (BreakpointsGroupNode)((Object)o1);
                BreakpointsGroupNode group2 = (BreakpointsGroupNode)((Object)o2);
                if (group1.getLevel() != group2.getLevel()) {
                    return group1.getLevel() - group2.getLevel();
                }
                return group1.getGroup().compareTo(group2.getGroup());
            }
            return o1 instanceof BreakpointsGroupNode ? -1 : 1;
        }
    }
}

