/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class XQuickEvaluateHandler
extends QuickEvaluateHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.evaluate.quick.XQuickEvaluateHandler");

    @Override
    public boolean isEnabled(@NotNull Project project2) {
        XDebugSession session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        return session2 != null && session2.getDebugProcess().getEvaluator() != null;
    }

    @Override
    @Nullable
    public AbstractValueHint createValueHint(@NotNull Project project2, @NotNull Editor editor, @NotNull Point point, ValueHintType type2) {
        return null;
    }

    @Override
    @NotNull
    public Promise<AbstractValueHint> createValueHintAsync(@NotNull Project project2, @NotNull Editor editor, @NotNull Point point, ValueHintType type2) {
        XDebugSession session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        if (session2 == null) {
            return Promise.resolve(null);
        }
        XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            return Promise.resolve(null);
        }
        int offset = AbstractValueHint.calculateOffset(editor, point);
        return XQuickEvaluateHandler.getExpressionInfo(evaluator, project2, type2, editor, offset).thenAsync(expressionInfo -> {
            AsyncPromise resultPromise = new AsyncPromise();
            UIUtil.invokeLaterIfNeeded(() -> {
                int textLength = editor.getDocument().getTextLength();
                if (expressionInfo == null) {
                    resultPromise.setResult(null);
                    return;
                }
                TextRange range = expressionInfo.getTextRange();
                if (range.getStartOffset() > range.getEndOffset() || range.getStartOffset() < 0 || range.getEndOffset() > textLength) {
                    LOG.error("invalid range: " + range + ", text length = " + textLength + ", evaluator: " + evaluator);
                    resultPromise.setResult(null);
                    return;
                }
                resultPromise.setResult((Object)new XValueHint(project2, editor, point, type2, (ExpressionInfo)expressionInfo, evaluator, session2));
            });
            return resultPromise;
        });
    }

    @NotNull
    private static Promise<ExpressionInfo> getExpressionInfo(XDebuggerEvaluator evaluator, Project project2, ValueHintType type2, @NotNull Editor editor, int offset) {
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        if ((type2 == ValueHintType.MOUSE_CLICK_HINT || type2 == ValueHintType.MOUSE_ALT_OVER_HINT) && selectionModel.hasSelection() && selectionStart <= offset && offset <= selectionEnd) {
            return Promise.resolve((Object)new ExpressionInfo(new TextRange(selectionStart, selectionEnd)));
        }
        return evaluator.getExpressionInfoAtOffsetAsync(project2, editor.getDocument(), offset, type2 == ValueHintType.MOUSE_CLICK_HINT || type2 == ValueHintType.MOUSE_ALT_OVER_HINT);
    }

    @Override
    public boolean canShowHint(@NotNull Project project2) {
        return this.isEnabled(project2);
    }

    @Override
    public int getValueLookupDelay(Project project2) {
        return XDebuggerSettingsManager.getInstance().getDataViewSettings().getValueLookupDelay();
    }
}

