/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

abstract class DebuggerTreeWithHistoryContainer<D> {
    private static final Logger LOG = Logger.getInstance(DebuggerTreeWithHistoryContainer.class);
    private static final int HISTORY_SIZE = 11;
    private final List<D> myHistory = new ArrayList<D>();
    private int myCurrentIndex = -1;
    protected final DebuggerTreeCreator<D> myTreeCreator;
    @NotNull
    protected final Project myProject;

    protected DebuggerTreeWithHistoryContainer(@NotNull D initialItem, @NotNull DebuggerTreeCreator<D> creator, @NotNull Project project2) {
        this.myTreeCreator = creator;
        this.myProject = project2;
        this.myHistory.add(initialItem);
    }

    protected JPanel createMainPanel(Tree tree) {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)tree), "Center");
        mainPanel.add((Component)this.createToolbar(mainPanel, tree), "North");
        return mainPanel;
    }

    private void updateTree() {
        D item = this.myHistory.get(this.myCurrentIndex);
        this.updateTree(item);
    }

    protected void updateTree(@NotNull D selectedItem) {
        this.updateContainer(this.myTreeCreator.createTree(selectedItem), this.myTreeCreator.getTitle(selectedItem));
    }

    protected abstract void updateContainer(Tree var1, String var2);

    protected void addToHistory(D item) {
        if (this.myCurrentIndex < 11) {
            this.myCurrentIndex = this.myCurrentIndex != -1 ? ++this.myCurrentIndex : 1;
            this.myHistory.add(this.myCurrentIndex, item);
        }
    }

    private JComponent createToolbar(JPanel parent, Tree tree) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new SetAsRootAction(tree));
        GoBackwardAction back = new GoBackwardAction();
        back.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(37, 8)), parent);
        group.add((AnAction)back);
        GoForwardAction forward = new GoForwardAction();
        forward.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(39, 8)), parent);
        group.add((AnAction)forward);
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
    }

    protected static void registerTreeDisposable(Disposable disposable, Tree tree) {
        if (tree instanceof Disposable) {
            Disposer.register((Disposable)disposable, (Disposable)((Disposable)tree));
        }
    }

    private class SetAsRootAction
    extends AnAction {
        private final Tree myTree;

        public SetAsRootAction(Tree tree) {
            super(XDebuggerBundle.message((String)"xdebugger.popup.value.tree.set.root.action.tooltip", (Object[])new Object[0]), XDebuggerBundle.message((String)"xdebugger.popup.value.tree.set.root.action.tooltip", (Object[])new Object[0]), AllIcons.Modules.UnmarkWebroot);
            this.myTree = tree;
        }

        public void update(AnActionEvent e) {
            TreePath path = this.myTree.getSelectionPath();
            e.getPresentation().setEnabled(path != null && path.getPathCount() > 1);
        }

        public void actionPerformed(AnActionEvent e) {
            TreePath path = this.myTree.getSelectionPath();
            if (path != null) {
                Object node = path.getLastPathComponent();
                DebuggerTreeWithHistoryContainer.this.myTreeCreator.createDescriptorByNode(node, new ResultConsumer<D>(){

                    public void onSuccess(D value2) {
                        if (value2 != null) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                DebuggerTreeWithHistoryContainer.this.addToHistory(value2);
                                DebuggerTreeWithHistoryContainer.this.updateTree(value2);
                            });
                        }
                    }

                    public void onFailure(@NotNull Throwable t) {
                        LOG.debug(t);
                    }
                });
            }
        }
    }

    private class GoBackwardAction
    extends AnAction {
        public GoBackwardAction() {
            super(CodeInsightBundle.message((String)"quick.definition.back", (Object[])new Object[0]), null, AllIcons.Actions.Back);
        }

        public void actionPerformed(AnActionEvent e) {
            if (DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex > 0) {
                DebuggerTreeWithHistoryContainer.this.myCurrentIndex--;
                DebuggerTreeWithHistoryContainer.this.updateTree();
            }
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex > 0);
        }
    }

    private class GoForwardAction
    extends AnAction {
        public GoForwardAction() {
            super(CodeInsightBundle.message((String)"quick.definition.forward", (Object[])new Object[0]), null, AllIcons.Actions.Forward);
        }

        public void actionPerformed(AnActionEvent e) {
            if (DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex < DebuggerTreeWithHistoryContainer.this.myHistory.size() - 1) {
                DebuggerTreeWithHistoryContainer.this.myCurrentIndex++;
                DebuggerTreeWithHistoryContainer.this.updateTree();
            }
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex < DebuggerTreeWithHistoryContainer.this.myHistory.size() - 1);
        }
    }
}

