/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final WatchesRootNode myRootNode;
    private final XWatchesView myWatchesView;
    private final WatchNode myOldNode;

    public WatchInplaceEditor(@NotNull WatchesRootNode rootNode, XWatchesView watchesView, WatchNode node, @Nullable WatchNode oldNode) {
        super((XDebuggerTreeNode)((Object)node), "watch");
        this.myRootNode = rootNode;
        this.myWatchesView = watchesView;
        this.myOldNode = oldNode;
        this.myExpressionEditor.setExpression(oldNode != null ? oldNode.getExpression() : null);
    }

    @Override
    public void cancelEditing() {
        if (!this.isShown()) {
            return;
        }
        super.cancelEditing();
        int index = this.myRootNode.getIndex(this.myNode);
        if (this.myOldNode == null && index != -1) {
            this.myRootNode.removeChildNode(this.myNode);
        }
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)this.myNode);
    }

    @Override
    public void doOKAction() {
        XExpression expression2 = this.getExpression();
        super.doOKAction();
        int index = this.myRootNode.removeChildNode(this.myNode);
        if (!XDebuggerUtilImpl.isEmptyExpression(expression2) && index != -1) {
            this.myWatchesView.addWatchExpression(expression2, index, false);
        }
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)this.myNode);
    }
}

