/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.impl.frame.XDebugView;
import org.jetbrains.annotations.NotNull;

public class XDebugViewSessionListener
implements XDebugSessionListener {
    private final XDebugView myDebugView;
    private final XDebugSession mySession;

    public XDebugViewSessionListener(@NotNull XDebugView debugView, @NotNull XDebugSession session2) {
        this.myDebugView = debugView;
        this.mySession = session2;
    }

    private void onSessionEvent(@NotNull XDebugView.SessionEvent event) {
        this.myDebugView.processSessionEvent(event, this.mySession);
    }

    public void sessionPaused() {
        this.onSessionEvent(XDebugView.SessionEvent.PAUSED);
    }

    public void sessionResumed() {
        this.onSessionEvent(XDebugView.SessionEvent.RESUMED);
    }

    public void sessionStopped() {
        this.onSessionEvent(XDebugView.SessionEvent.STOPPED);
    }

    public void stackFrameChanged() {
        this.onSessionEvent(XDebugView.SessionEvent.FRAME_CHANGED);
    }

    public void beforeSessionResume() {
        this.onSessionEvent(XDebugView.SessionEvent.BEFORE_RESUME);
    }
}

