/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerCopyPastePreprocessor;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerExpressionComboBox
extends XDebuggerEditorBase {
    private final JComponent myComponent;
    private final ComboBox<XExpression> myComboBox = new ComboBox(100);
    private XDebuggerComboBoxEditor myEditor;
    private XExpression myExpression;

    public XDebuggerExpressionComboBox(@NotNull Project project2, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition, boolean showEditor) {
        super(project2, debuggerEditorsProvider, EvaluationMode.EXPRESSION, historyId, sourcePosition);
        this.myComboBox.setEditable(true);
        this.myExpression = XExpressionImpl.EMPTY_EXPRESSION;
        Dimension minimumSize = new Dimension(this.myComboBox.getMinimumSize());
        minimumSize.width = 100;
        this.myComboBox.setMinimumSize(minimumSize);
        this.initEditor();
        this.fillComboBox();
        this.myComponent = showEditor ? this.addMultilineButton((JComponent)this.myComboBox) : this.myComboBox;
    }

    public ComboBox getComboBox() {
        return this.myComboBox;
    }

    @Override
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditor.getEditorTextField().getEditor();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myEditor.getEditorTextField();
    }

    public void setEnabled(boolean enable) {
        if (enable == this.myComboBox.isEnabled()) {
            return;
        }
        UIUtil.setEnabled((Component)this.myComponent, (boolean)enable, (boolean)true);
        if (!enable) {
            this.myExpression = this.getExpression();
        }
    }

    private void initEditor() {
        this.myEditor = new XDebuggerComboBoxEditor();
        this.myComboBox.setEditor((ComboBoxEditor)this.myEditor);
        this.myComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)this.myEditor));
        this.myComboBox.setMaximumRowCount(10);
    }

    @Override
    protected void onHistoryChanged() {
        this.fillComboBox();
    }

    private void fillComboBox() {
        this.myComboBox.removeAllItems();
        this.getRecentExpressions().forEach(arg_0 -> this.myComboBox.addItem(arg_0));
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
    }

    @Override
    protected void doSetText(XExpression text) {
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
        this.myEditor.setItem(text);
        this.myExpression = text;
    }

    @Override
    public XExpression getExpression() {
        XExpression item = this.myEditor.getItem();
        return item != null ? item : this.myExpression;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getEditorTextField();
    }

    @Override
    public void selectAll() {
        this.myComboBox.getEditor().selectAll();
    }

    private class XDebuggerComboBoxEditor
    implements ComboBoxEditor {
        private final JComponent myPanel;
        private final EditorComboBoxEditor myDelegate;

        public XDebuggerComboBoxEditor() {
            this.myDelegate = new EditorComboBoxEditor(XDebuggerExpressionComboBox.this.getProject(), XDebuggerExpressionComboBox.this.getEditorsProvider().getFileType()){

                @Override
                protected void onEditorCreate(EditorEx editor) {
                    editor.putUserData(DebuggerCopyPastePreprocessor.REMOVE_NEWLINES_ON_PASTE, true);
                    editor.getColorsScheme().setEditorFontSize(XDebuggerExpressionComboBox.this.myComboBox.getFont().getSize());
                }
            };
            this.myDelegate.getEditorComponent().setFontInheritedFromLAF(false);
            this.myPanel = XDebuggerExpressionComboBox.this.addChooser((JComponent)((Object)this.myDelegate.getEditorComponent()));
        }

        public EditorTextField getEditorTextField() {
            return this.myDelegate.getEditorComponent();
        }

        @Override
        public JComponent getEditorComponent() {
            return this.myPanel;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject == null) {
                anObject = XExpressionImpl.EMPTY_EXPRESSION;
            }
            XExpression expression2 = (XExpression)anObject;
            this.myDelegate.getEditorComponent().setNewDocumentAndFileType(XDebuggerExpressionComboBox.this.getFileType(expression2), XDebuggerExpressionComboBox.this.createDocument(expression2));
        }

        public XExpression getItem() {
            Object document = this.myDelegate.getItem();
            if (document instanceof Document) {
                return XDebuggerExpressionComboBox.this.getEditorsProvider().createExpression(XDebuggerExpressionComboBox.this.getProject(), (Document)document, XDebuggerExpressionComboBox.this.myExpression.getLanguage(), XDebuggerExpressionComboBox.this.myExpression.getMode());
            }
            return null;
        }

        @Override
        public void selectAll() {
            this.myDelegate.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.myDelegate.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.myDelegate.removeActionListener(l);
        }
    }
}

