/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerInstanceTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeWithHistoryPanel;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XInspectDialog
extends DialogWrapper {
    private final DebuggerTreeWithHistoryPanel myDebuggerTreePanel;
    private final boolean myRebuildOnSessionEvents;

    public XInspectDialog(@NotNull Project project2, XDebuggerEditorsProvider editorsProvider, XSourcePosition sourcePosition, @NotNull String name, @NotNull XValue value2, XValueMarkers<?, ?> markers, @Nullable XDebugSession session2, boolean rebuildOnSessionEvents) {
        super(project2, false);
        this.myRebuildOnSessionEvents = rebuildOnSessionEvents;
        this.setTitle(XDebuggerBundle.message((String)"inspect.value.dialog.title", (Object[])new Object[]{name}));
        this.setModal(false);
        XInstanceEvaluator instanceEvaluator = value2.getInstanceEvaluator();
        if (instanceEvaluator != null && this.myRebuildOnSessionEvents && session2 != null) {
            Pair initialItem = Pair.create((Object)instanceEvaluator, (Object)name);
            XDebuggerInstanceTreeCreator creator = new XDebuggerInstanceTreeCreator(project2, editorsProvider, sourcePosition, markers, session2);
            this.myDebuggerTreePanel = new DebuggerTreeWithHistoryPanel<Pair<XInstanceEvaluator, String>>(initialItem, creator, project2, this.myDisposable);
        } else {
            Pair initialItem = Pair.create((Object)value2, (Object)name);
            XDebuggerTreeCreator creator = new XDebuggerTreeCreator(project2, editorsProvider, sourcePosition, markers);
            this.myDebuggerTreePanel = new DebuggerTreeWithHistoryPanel<Pair<XValue, String>>(initialItem, creator, project2, this.myDisposable);
        }
        if (session2 != null) {
            session2.addSessionListener(new XDebugSessionListener(){

                public void sessionPaused() {
                    if (XInspectDialog.this.myRebuildOnSessionEvents) {
                        XInspectDialog.this.myDebuggerTreePanel.rebuild();
                    }
                }
            }, this.myDisposable);
        }
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myDebuggerTreePanel.getMainPanel();
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "#xdebugger.XInspectDialog";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myDebuggerTreePanel.getTree();
    }
}

