/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;

class XAddToWatchesAction
extends XDebuggerTreeActionBase {
    XAddToWatchesAction() {
    }

    @Override
    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        return super.isEnabled(node, e) && DebuggerUIUtil.hasEvaluationExpression((XValue)node.getValueContainer()) && XAddToWatchesAction.getWatchesView(e) != null;
    }

    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        XWatchesView watchesView = XAddToWatchesAction.getWatchesView(e);
        if (watchesView != null) {
            ((XValue)node.getValueContainer()).calculateEvaluationExpression().done(expression2 -> {
                if (expression2 != null) {
                    watchesView.addWatchExpression((XExpression)expression2, -1, true);
                }
            });
        }
    }

    private static XWatchesView getWatchesView(@NotNull AnActionEvent e) {
        XDebugSessionTab tab;
        XDebugSession session2;
        XWatchesView view = (XWatchesView)e.getData(XWatchesView.DATA_KEY);
        Project project2 = e.getProject();
        if (view == null && project2 != null && (session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null && (tab = ((XDebugSessionImpl)session2).getSessionTab()) != null) {
            return tab.getWatchesView();
        }
        return view;
    }
}

