/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XValueNodePresentationConfigurator {
    public static void setPresentation(@Nullable Icon icon, @NotNull XValuePresentation presentation, boolean hasChildren, ConfigurableXValueNode node) {
        XValueNodePresentationConfigurator.doSetPresentation(icon, presentation, hasChildren, node);
    }

    public static void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type2, @NonNls @NotNull String value2, boolean hasChildren, ConfigurableXValueNode node) {
        XValueNodePresentationConfigurator.doSetPresentation(icon, (XValuePresentation)new XRegularValuePresentation(value2, type2), hasChildren, node);
    }

    public static void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type2, @NonNls @NotNull String separator, @NonNls @Nullable String value2, boolean hasChildren, ConfigurableXValueNode node) {
        XValueNodePresentationConfigurator.doSetPresentation(icon, (XValuePresentation)new XRegularValuePresentation(StringUtil.notNullize((String)value2), type2, separator), hasChildren, node);
    }

    public static void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type2, @NonNls @NotNull String value2, @Nullable NotNullFunction<String, String> valuePresenter, boolean hasChildren, ConfigurableXValueNode node) {
        XValueNodePresentationConfigurator.doSetPresentation(icon, (XValuePresentation)(valuePresenter == null ? new XRegularValuePresentation(value2, type2) : new XValuePresentationAdapter(value2, type2, valuePresenter)), hasChildren, node);
    }

    private static void doSetPresentation(@Nullable Icon icon, @NotNull XValuePresentation presentation, boolean hasChildren, ConfigurableXValueNode node) {
        if (DebuggerUIUtil.isObsolete(node)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            node.applyPresentation(icon, presentation, hasChildren);
        } else {
            Runnable updater = () -> node.applyPresentation(icon, presentation, hasChildren);
            if (node instanceof XDebuggerTreeNode) {
                ((XDebuggerTreeNode)((Object)node)).invokeNodeUpdate(updater);
            } else {
                application.invokeLater(updater);
            }
        }
    }

    private static final class XValuePresentationAdapter
    extends XValuePresentation {
        private final String myValue;
        private final String myType;
        private final NotNullFunction<String, String> valuePresenter;

        public XValuePresentationAdapter(String value2, String type2, NotNullFunction<String, String> valuePresenter) {
            this.myValue = value2;
            this.myType = type2;
            this.valuePresenter = valuePresenter;
        }

        @Nullable
        public String getType() {
            return this.myType;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            renderer.renderValue((String)this.valuePresenter.fun((Object)this.myValue));
        }
    }

    public static abstract class ConfigurableXValueNodeImpl
    implements ConfigurableXValueNode,
    XValueNode {
        public void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type2, @NonNls @NotNull String value2, boolean hasChildren) {
            XValueNodePresentationConfigurator.setPresentation(icon, type2, value2, hasChildren, this);
        }

        public void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type2, @NonNls @NotNull String separator, @NonNls @Nullable String value2, boolean hasChildren) {
            XValueNodePresentationConfigurator.setPresentation(icon, type2, separator, value2, hasChildren, (ConfigurableXValueNode)this);
        }

        public void setPresentation(@Nullable Icon icon, @NotNull XValuePresentation presentation, boolean hasChildren) {
            XValueNodePresentationConfigurator.setPresentation(icon, presentation, hasChildren, this);
        }
    }

    public static interface ConfigurableXValueNode {
        public void applyPresentation(@Nullable Icon var1, @NotNull XValuePresentation var2, boolean var3);
    }
}

