/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.validate;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.actions.validate.StdErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import org.jetbrains.annotations.NotNull;

public class ValidateXmlAction
extends AnAction {
    private static final Key<String> runningValidationKey = Key.create((String)"xml.running.validation.indicator");

    private ValidateXmlActionHandler getHandler(@NotNull PsiFile file2) {
        ValidateXmlActionHandler handler2 = new ValidateXmlActionHandler(true);
        handler2.setErrorReporter(new StdErrorReporter(handler2, file2.getProject(), () -> this.doRunAction(file2)));
        return handler2;
    }

    public void actionPerformed(AnActionEvent e) {
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (psiFile != null) {
            this.doRunAction(psiFile);
        }
    }

    private void doRunAction(@NotNull PsiFile psiFile) {
        CommandProcessor.getInstance().executeCommand(psiFile.getProject(), () -> {
            Runnable action = () -> {
                try {
                    psiFile.putUserData(runningValidationKey, (Object)"");
                    PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitAllDocuments();
                    this.getHandler(psiFile).doValidate((XmlFile)psiFile);
                }
                finally {
                    psiFile.putUserData(runningValidationKey, null);
                }
            };
            ApplicationManager.getApplication().runWriteAction(action);
        }, this.getCommandName(), null);
    }

    private String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text != null ? text : "";
    }

    public void update(AnActionEvent event) {
        super.update(event);
        Presentation presentation = event.getPresentation();
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_FILE.getData(event.getDataContext());
        boolean flag = psiElement instanceof XmlFile;
        presentation.setVisible(flag);
        boolean value2 = psiElement instanceof XmlFile;
        if (value2) {
            PsiFile containingFile = psiElement.getContainingFile();
            value2 = containingFile != null && (containingFile.getFileType() == StdFileTypes.XML || containingFile.getFileType() == StdFileTypes.XHTML) ? containingFile.getUserData(runningValidationKey) == null : false;
        }
        presentation.setEnabled(value2);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(value2);
        }
    }
}

