/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class BreadcrumbsInitializingActivity
implements StartupActivity,
DumbAware {
    public void runActivity(@NotNull Project project2) {
        if (project2.isDefault()) {
            return;
        }
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener(project2));
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new MyVirtualFileListener(project2), (Disposable)project2);
        connection.subscribe(UISettingsListener.TOPIC, (Object)new MyUISettingsListener(project2));
    }

    private static void reinitBreadcrumbsInAllEditors(@NotNull Project project2) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(fileEditorManager, virtualFile);
        }
    }

    private static void reinitBreadcrumbsComponent(final @NotNull FileEditorManager fileEditorManager, @NotNull VirtualFile file2) {
        if (BreadcrumbsInitializingActivity.isSuitable(fileEditorManager.getProject(), file2)) {
            FileEditor[] fileEditors;
            for (final FileEditor fileEditor : fileEditors = fileEditorManager.getAllEditors(file2)) {
                if (!(fileEditor instanceof TextEditor) || !fileEditor.isValid()) continue;
                Editor editor = ((TextEditor)fileEditor).getEditor();
                BreadcrumbsXmlWrapper existingWrapper = BreadcrumbsXmlWrapper.getBreadcrumbsComponent(editor);
                if (existingWrapper != null) {
                    existingWrapper.queueUpdate();
                    continue;
                }
                final BreadcrumbsXmlWrapper wrapper = new BreadcrumbsXmlWrapper(editor);
                JComponent c = wrapper.getComponent();
                fileEditorManager.addTopComponent(fileEditor, c);
                Disposer.register((Disposable)fileEditor, (Disposable)new Disposable(){

                    public void dispose() {
                        BreadcrumbsInitializingActivity.disposeWrapper(fileEditorManager, fileEditor, wrapper);
                    }
                });
            }
        } else {
            BreadcrumbsInitializingActivity.removeBreadcrumbs(fileEditorManager, file2);
        }
    }

    private static void removeBreadcrumbs(@NotNull FileEditorManager fileEditorManager, @NotNull VirtualFile file2) {
        FileEditor[] fileEditors;
        for (FileEditor fileEditor : fileEditors = fileEditorManager.getAllEditors(file2)) {
            Editor editor;
            BreadcrumbsXmlWrapper wrapper;
            if (!(fileEditor instanceof TextEditor) || (wrapper = BreadcrumbsXmlWrapper.getBreadcrumbsComponent(editor = ((TextEditor)fileEditor).getEditor())) == null) continue;
            BreadcrumbsInitializingActivity.disposeWrapper(fileEditorManager, fileEditor, wrapper);
        }
    }

    private static boolean isSuitable(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (file2 instanceof HttpVirtualFile) {
            return false;
        }
        FileViewProvider provider2 = PsiManager.getInstance((Project)project2).findViewProvider(file2);
        return provider2 != null && BreadcrumbsXmlWrapper.findInfoProvider(provider2) != null;
    }

    private static void disposeWrapper(@NotNull FileEditorManager fileEditorManager, @NotNull FileEditor fileEditor, @NotNull BreadcrumbsXmlWrapper wrapper) {
        fileEditorManager.removeTopComponent(fileEditor, wrapper.getComponent());
        Disposer.dispose((Disposable)wrapper);
    }

    private static class MyUISettingsListener
    implements UISettingsListener {
        private final Project myProject;

        public MyUISettingsListener(@NotNull Project project2) {
            this.myProject = project2;
        }

        public void uiSettingsChanged(UISettings uiSettings) {
            if (!this.myProject.isDisposed()) {
                BreadcrumbsInitializingActivity.reinitBreadcrumbsInAllEditors(this.myProject);
            }
        }
    }

    private static class MyFileTypeListener
    implements FileTypeListener {
        private final Project myProject;

        public MyFileTypeListener(@NotNull Project project2) {
            this.myProject = project2;
        }

        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            if (!this.myProject.isDisposed()) {
                BreadcrumbsInitializingActivity.reinitBreadcrumbsInAllEditors(this.myProject);
            }
        }
    }

    private static class MyVirtualFileListener
    extends VirtualFileAdapter {
        private final Project myProject;

        public MyVirtualFileListener(@NotNull Project project2) {
            this.myProject = project2;
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile file2;
            FileEditorManager fileEditorManager;
            if ("name".equals(event.getPropertyName()) && !this.myProject.isDisposed() && (fileEditorManager = FileEditorManager.getInstance((Project)this.myProject)).isFileOpen(file2 = event.getFile())) {
                BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(fileEditorManager, file2);
            }
        }
    }

    private static class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(source, file2);
        }
    }
}

