/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class XmlIndex<V>
extends FileBasedIndexExtension<String, V> {
    protected static GlobalSearchScope createFilter(Project project2) {
        final GlobalSearchScope projectScope = GlobalSearchScope.allScope((Project)project2);
        return new GlobalSearchScope(project2){

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                return projectScope.compare(file1, file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                return true;
            }

            public boolean contains(@NotNull VirtualFile file2) {
                VirtualFile parent = file2.getParent();
                return parent != null && (parent.getName().equals("standardSchemas") || projectScope.contains(file2));
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        };
    }

    protected static VirtualFileFilter createFilter(final @NotNull Module module2) {
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module2.getProject()).getFileIndex();
        return new VirtualFileFilter(){

            public boolean accept(VirtualFile file2) {
                Module moduleForFile = fileIndex.getModuleForFile(file2);
                if (moduleForFile != null) {
                    return module2.equals(moduleForFile);
                }
                if (fileIndex.isInLibraryClasses(file2)) {
                    List orderEntries = fileIndex.getOrderEntriesForFile(file2);
                    if (orderEntries.isEmpty()) {
                        return false;
                    }
                    for (OrderEntry orderEntry : orderEntries) {
                        Module ownerModule = orderEntry.getOwnerModule();
                        if (!ownerModule.equals(module2)) continue;
                        return true;
                    }
                }
                VirtualFile parent = file2.getParent();
                assert (parent != null);
                return parent.getName().equals("standardSchemas");
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE, DTDFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                FileType fileType = file2.getFileType();
                String extension = file2.getExtension();
                return XmlFileType.INSTANCE.equals(fileType) && "xsd".equals(extension) || ((Object)((Object)DTDFileType.INSTANCE)).equals(fileType) && "dtd".equals(extension);
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }
}

