/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.AnchorReference;
import com.intellij.xml.util.HtmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnchorReferenceImpl
implements AnchorReference,
PsiReference,
EmptyResolveMessageProvider {
    private final String myAnchor;
    private final FileReference myFileReference;
    private final PsiElement myElement;
    private final int myOffset;
    private final boolean mySoft;
    @NonNls
    private static final String ANCHOR_ELEMENT_NAME = "a";
    @NonNls
    private static final String MAP_ELEMENT_NAME = "map";
    private static final Key<CachedValue<Map<String, XmlTag>>> ourCachedIdsKey = Key.create((String)"cached.ids");

    AnchorReferenceImpl(String anchor, @Nullable FileReference psiReference, PsiElement element, int offset, boolean soft) {
        this.myAnchor = anchor;
        this.myFileReference = psiReference;
        this.myElement = element;
        this.myOffset = offset;
        this.mySoft = soft;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return new TextRange(this.myOffset, this.myOffset + this.myAnchor.length());
    }

    public PsiElement resolve() {
        XmlTag tag;
        if (this.myAnchor.isEmpty()) {
            return this.myElement;
        }
        Map<String, XmlTag> map2 = this.getIdMap();
        XmlTag xmlTag = tag = map2 != null ? map2.get(this.myAnchor) : null;
        if (tag != null) {
            XmlAttribute attribute = tag.getAttribute("id");
            if (attribute == null) {
                attribute = tag.getAttribute("name");
            }
            if (attribute == null && MAP_ELEMENT_NAME.equalsIgnoreCase(tag.getName())) {
                attribute = tag.getAttribute("usemap");
            }
            assert (attribute != null) : tag.getText();
            return attribute.getValueElement();
        }
        return null;
    }

    private static boolean processXmlElements(XmlTag element, PsiElementProcessor<XmlTag> processor2) {
        if (!AnchorReferenceImpl._processXmlElements(element, processor2)) {
            return false;
        }
        for (PsiElement next = element.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (!(next instanceof XmlTag) || AnchorReferenceImpl._processXmlElements((XmlTag)next, processor2)) continue;
            return false;
        }
        return true;
    }

    static boolean _processXmlElements(XmlTag element, PsiElementProcessor<XmlTag> processor2) {
        XmlTag[] subTags;
        if (!processor2.execute((PsiElement)element)) {
            return false;
        }
        for (XmlTag subTag : subTags = element.getSubTags()) {
            if (AnchorReferenceImpl._processXmlElements(subTag, processor2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private Map<String, XmlTag> getIdMap() {
        XmlFile file2 = this.getFile();
        if (file2 != null) {
            CachedValue value2 = (CachedValue)file2.getUserData(ourCachedIdsKey);
            if (value2 == null) {
                value2 = CachedValuesManager.getManager((Project)file2.getProject()).createCachedValue((CachedValueProvider)new MapCachedValueProvider(file2), false);
                file2.putUserData(ourCachedIdsKey, (Object)value2);
            }
            return (Map)value2.getValue();
        }
        return null;
    }

    @Nullable
    private static String getAnchorValue(XmlTag xmlTag) {
        String map_anchor;
        String attributeValue2;
        String attributeValue = xmlTag.getAttributeValue("id");
        if (attributeValue != null) {
            return attributeValue;
        }
        if (ANCHOR_ELEMENT_NAME.equalsIgnoreCase(xmlTag.getName()) && (attributeValue2 = xmlTag.getAttributeValue("name")) != null) {
            return attributeValue2;
        }
        if (MAP_ELEMENT_NAME.equalsIgnoreCase(xmlTag.getName()) && (map_anchor = xmlTag.getAttributeValue("name")) != null) {
            return map_anchor;
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myAnchor;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof XmlAttributeValue && this.myElement.getManager().areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        Map<String, XmlTag> idMap = this.getIdMap();
        if (idMap == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        String[] variants = idMap.keySet().toArray(new String[idMap.size()]);
        Object[] elements = new LookupElement[variants.length];
        int variantsLength = variants.length;
        for (int i2 = 0; i2 < variantsLength; ++i2) {
            elements[i2] = LookupElementBuilder.create((String)variants[i2]).withCaseSensitivity(true);
        }
        return elements;
    }

    @Nullable
    private XmlFile getFile() {
        if (this.myFileReference != null) {
            PsiFileSystemItem psiElement = this.myFileReference.resolve();
            return psiElement instanceof XmlFile ? (XmlFile)psiElement : null;
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        if (containingFile instanceof XmlFile) {
            return (XmlFile)containingFile;
        }
        XmlExtension extension = XmlExtension.getExtensionByElement(this.myElement);
        return extension == null ? null : extension.getContainingFile(this.myElement);
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        XmlFile xmlFile = this.getFile();
        return xmlFile == null ? XmlBundle.message((String)"cannot.resolve.anchor", (Object[])new Object[]{this.myAnchor}) : XmlBundle.message((String)"cannot.resolve.anchor.in.file", (Object[])new Object[]{this.myAnchor, xmlFile.getName()});
    }

    private static class MapCachedValueProvider
    implements CachedValueProvider<Map<String, XmlTag>> {
        private final XmlFile myFile;

        public MapCachedValueProvider(XmlFile file2) {
            this.myFile = file2;
        }

        public CachedValueProvider.Result<Map<String, XmlTag>> compute() {
            XmlTag rootTag;
            HashMap resultMap = new HashMap();
            XmlDocument document = HtmlUtil.getRealXmlDocument(this.myFile.getDocument());
            XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
            if (rootTag != null) {
                AnchorReferenceImpl.processXmlElements(rootTag, (PsiElementProcessor<XmlTag>)((PsiElementProcessor)new PsiElementProcessor<XmlTag>((Map)resultMap){
                    final /* synthetic */ Map val$resultMap;
                    {
                        this.val$resultMap = map2;
                    }

                    public boolean execute(@NotNull XmlTag element) {
                        String anchorValue = AnchorReferenceImpl.getAnchorValue(element);
                        if (anchorValue != null) {
                            this.val$resultMap.put(anchorValue, element);
                        }
                        return true;
                    }
                }));
            }
            return new CachedValueProvider.Result((Object)resultMap, new Object[]{this.myFile});
        }
    }
}

