/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDeclareIdInCommentAction
implements LocalQuickFix {
    private final String myId;

    public XmlDeclareIdInCommentAction(@NotNull String id) {
        this.myId = id;
    }

    @NotNull
    public String getFamilyName() {
        return XmlErrorMessages.message("declare.id.in.comment.quickfix", new Object[0]);
    }

    @Nullable
    public static String getImplicitlyDeclaredId(@NotNull PsiComment comment) {
        String text = XmlDeclareIdInCommentAction.getUncommentedText(comment);
        if (text == null) {
            return null;
        }
        if (text.startsWith("@declare id=\"")) {
            String result2 = text.substring("@declare id=\"".length() - 1);
            return StringUtil.unquoteString((String)result2);
        }
        return null;
    }

    @Nullable
    private static String getUncommentedText(@NotNull PsiComment comment) {
        PsiFile psiFile = comment.getContainingFile();
        Language language = psiFile.getViewProvider().getBaseLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter != null) {
            String text = comment.getText();
            String prefix = commenter.getBlockCommentPrefix();
            if (prefix != null && text.startsWith(prefix)) {
                text = text.substring(prefix.length());
                String suffix = commenter.getBlockCommentSuffix();
                if (suffix != null && text.length() > suffix.length()) {
                    return text.substring(0, text.length() - suffix.length()).trim();
                }
            }
        }
        return null;
    }

    public void applyFix(final @NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        final PsiElement psiElement = descriptor.getPsiElement();
        final PsiFile psiFile = psiElement.getContainingFile();
        new WriteCommandAction(project2, new PsiFile[]{psiFile}){

            protected void run(@NotNull Result result2) throws Throwable {
                PsiElement element;
                PsiFile psi;
                XmlTag[] tags;
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
                if (tag == null) {
                    return;
                }
                Language language = psiFile.getViewProvider().getBaseLanguage();
                Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
                if (commenter == null) {
                    return;
                }
                PsiFile tempFile = PsiFileFactory.getInstance((Project)project2).createFileFromText("dummy", (FileType)language.getAssociatedFileType(), (CharSequence)(commenter.getBlockCommentPrefix() + "@declare id=\"" + XmlDeclareIdInCommentAction.this.myId + "\"" + commenter.getBlockCommentSuffix() + "\n"));
                XmlTag parent = tag.getParentTag();
                if (parent != null && parent.isValid() && (tags = parent.getSubTags()).length > 0 && (psi = tempFile.getViewProvider().getPsi(language)) != null && (element = psi.findElementAt(1)) instanceof PsiComment) {
                    parent.getNode().addChild(element.getNode(), tags[0].getNode());
                }
            }
        }.execute();
    }
}

