/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.RemoveAttributeIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.RoleFinder;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlTagRuleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlTagRuleProviderBase
extends XmlTagRuleProvider {
    public static RequireAttributeOneOf requireAttr(String ... attributeNames) {
        return new RequireAttributeOneOf(attributeNames);
    }

    public static ShouldHaveParams shouldHaveParams() {
        return new ShouldHaveParams();
    }

    public static XmlTagRuleProvider.Rule unusedIfPresent(String attrPresent, String ... attrUnused) {
        Effect[] effects = new Effect[attrUnused.length];
        for (int i2 = 0; i2 < effects.length; ++i2) {
            effects[i2] = XmlTagRuleProviderBase.unused(attrUnused[i2], "The attribute '" + attrUnused[i2] + "' is unused because the attribute '" + attrPresent + "' is present");
        }
        return new ConditionRule(XmlTagRuleProviderBase.ifAttrPresent(attrPresent), effects);
    }

    public static XmlTagRuleProvider.Rule unusedAllIfPresent(String attrPresent, String ... attrUnused) {
        return new ConditionRule(XmlTagRuleProviderBase.ifAttrPresent(attrPresent), new InvalidAllExpectSome("The attribute is unused because the attribute " + attrPresent + " is present", ProblemHighlightType.LIKE_UNUSED_SYMBOL, (String[])ArrayUtil.append((Object[])attrUnused, (Object)attrPresent)));
    }

    public static Effect invalid(String attrName, String text) {
        return new InvalidAttrEffect(attrName, text, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    public static Effect unused(String attrName) {
        return new InvalidAttrEffect(attrName, "Attribute '" + attrName + "' is unused", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
    }

    public static Effect unused(String attrName, String text) {
        return new InvalidAttrEffect(attrName, text, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
    }

    public static Effect unusedAll(String text, String ... attrNames) {
        return new InvalidAllExpectSome(text, ProblemHighlightType.LIKE_UNUSED_SYMBOL, attrNames);
    }

    public static XmlTagRuleProvider.Rule rule(Condition<XmlTag> condition2, Effect ... effect) {
        return new ConditionRule(condition2, effect);
    }

    @Nullable
    public static PsiElement getXmlElement(RoleFinder roleFinder, XmlElement tag) {
        ASTNode tagNode = tag.getNode();
        if (tagNode == null) {
            return null;
        }
        ASTNode nameElement = roleFinder.findChild(tagNode);
        if (nameElement == null) {
            return null;
        }
        return nameElement.getPsi();
    }

    @Nullable
    public static PsiElement getTagNameElement(XmlTag tag) {
        return XmlTagRuleProviderBase.getXmlElement(XmlChildRole.START_TAG_NAME_FINDER, (XmlElement)tag);
    }

    @Nullable
    public static PsiElement getAttributeNameElement(XmlAttribute attribute) {
        return XmlTagRuleProviderBase.getXmlElement(XmlChildRole.ATTRIBUTE_NAME_FINDER, (XmlElement)attribute);
    }

    public static boolean isClosedTag(XmlTag tag) {
        return XmlTagRuleProviderBase.getXmlElement(XmlChildRole.EMPTY_TAG_END_FINDER, (XmlElement)tag) != null || XmlTagRuleProviderBase.getXmlElement(XmlChildRole.CLOSING_TAG_START_FINDER, (XmlElement)tag) != null;
    }

    public static Condition<XmlTag> ifAttrPresent(String attrName) {
        return tag -> tag.getAttribute(attrName) != null;
    }

    public static class RequireAttributeOneOf
    extends ShouldHaveParams {
        private final String[] myAttributeNames;
        private final ProblemHighlightType myProblemHighlightType;

        public RequireAttributeOneOf(String ... attributeNames) {
            this.myAttributeNames = attributeNames;
            this.myProblemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }

        public RequireAttributeOneOf(@NotNull ProblemHighlightType problemHighlightType, String ... attributeNames) {
            assert (attributeNames.length > 0);
            this.myAttributeNames = attributeNames;
            this.myProblemHighlightType = problemHighlightType;
        }

        public String[] getAttributeNames() {
            return this.myAttributeNames;
        }

        public void annotate(@NotNull XmlTag tag, @NotNull ProblemsHolder holder) {
            for (String attributeName : this.myAttributeNames) {
                if (tag.getAttribute(attributeName) == null) continue;
                return;
            }
            if (!XmlTagRuleProviderBase.isClosedTag(tag)) {
                return;
            }
            PsiElement tagNameElement = XmlTagRuleProviderBase.getTagNameElement(tag);
            if (tagNameElement == null) {
                return;
            }
            LocalQuickFix[] fixes = new LocalQuickFix[this.myAttributeNames.length];
            for (int i2 = 0; i2 < this.myAttributeNames.length; ++i2) {
                fixes[i2] = XmlQuickFixFactory.getInstance().insertRequiredAttributeFix(tag, this.myAttributeNames[i2], new String[0]);
            }
            holder.registerProblem(tagNameElement, "Tag should have one of following attributes: " + StringUtil.join((String[])this.myAttributeNames, (String)", "), this.myProblemHighlightType, fixes);
        }
    }

    public static class ShouldHaveParams
    extends XmlTagRuleProvider.Rule {
        public boolean needAtLeastOneAttribute(@NotNull XmlTag tag) {
            return true;
        }
    }

    public static class ConditionRule
    extends XmlTagRuleProvider.Rule {
        private final Condition<XmlTag> myCondition;
        private final Effect[] myEffect;

        public ConditionRule(Condition<XmlTag> condition2, Effect ... effect) {
            this.myCondition = condition2;
            this.myEffect = effect;
        }

        public void annotate(@NotNull XmlTag tag, @NotNull ProblemsHolder holder) {
            if (this.myCondition.value((Object)tag)) {
                for (Effect effect : this.myEffect) {
                    effect.annotate(tag, holder);
                }
            }
        }
    }

    public static class InvalidAllExpectSome
    extends Effect {
        private final String[] myAttrNames;
        private final String myText;
        private final ProblemHighlightType myType;

        public InvalidAllExpectSome(String text, ProblemHighlightType type2, String ... attrNames) {
            this.myAttrNames = attrNames;
            this.myText = text;
            this.myType = type2;
        }

        @Override
        public void annotate(@NotNull XmlTag tag, @NotNull ProblemsHolder holder) {
            for (XmlAttribute xmlAttribute : tag.getAttributes()) {
                PsiElement attributeNameElement;
                String attrName = xmlAttribute.getName();
                if (ArrayUtil.contains((String)attrName, (String[])this.myAttrNames) || (attributeNameElement = XmlTagRuleProviderBase.getAttributeNameElement(xmlAttribute)) == null) continue;
                holder.registerProblem(attributeNameElement, this.myText, this.myType, new LocalQuickFix[]{new RemoveAttributeIntentionAction(attrName)});
            }
        }
    }

    public static class InvalidAttrEffect
    extends Effect {
        private final String myAttrName;
        private final String myText;
        private final ProblemHighlightType myType;

        public InvalidAttrEffect(String attrName, String text, ProblemHighlightType type2) {
            this.myAttrName = attrName;
            this.myText = text;
            this.myType = type2;
        }

        @Override
        public void annotate(@NotNull XmlTag tag, @NotNull ProblemsHolder holder) {
            PsiElement attributeNameElement;
            XmlAttribute attribute = tag.getAttribute(this.myAttrName);
            if (attribute != null && (attributeNameElement = XmlTagRuleProviderBase.getAttributeNameElement(attribute)) != null) {
                holder.registerProblem(attributeNameElement, this.myText, this.myType, new LocalQuickFix[]{new RemoveAttributeIntentionAction(this.myAttrName)});
            }
        }
    }

    public static abstract class Effect {
        public abstract void annotate(@NotNull XmlTag var1, @NotNull ProblemsHolder var2);
    }
}

