/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.PathManager;
import java.io.File;

public class CidrPathManager {
    private static final String CIDR_ROOT_PATH_PROPERTY = "cidr.root.path";
    private static final String CIDR_APPCODE_ROOT_PATH_PROPERTY = "cidr.appcode.root.path";
    private static OverrideablePath ourCidrRootPath = new OverrideablePath("cidr.root.path", "CIDR");
    private static OverrideablePath ourCidrAppcodeRootPath = new OverrideablePath("cidr.appcode.root.path", "CIDR-appcode");

    public static File getCidrRootPath() {
        return ourCidrRootPath.getPath();
    }

    public static File getCidrAppcodeRootPath() {
        return ourCidrAppcodeRootPath.getPath();
    }

    private static class OverrideablePath {
        private final String myProperty;
        private final String myDefaultPath;
        private File myCachedPath;

        OverrideablePath(String property, String defaultPath) {
            this.myProperty = property;
            this.myDefaultPath = defaultPath;
        }

        File getPath() {
            if (this.myCachedPath != null) {
                return this.myCachedPath;
            }
            String relativePath = System.getProperty(this.myProperty);
            if (relativePath == null) {
                relativePath = this.myDefaultPath;
            }
            this.myCachedPath = new File(PathManager.getHomePath(), relativePath);
            return this.myCachedPath;
        }
    }
}

