/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.jetbrains.cidr.ProjectOpenHelper;
import java.io.File;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class CidrProjectOpenProcessor
extends ProjectOpenProcessor {
    @NotNull
    private final String myName;
    @NotNull
    private final ProjectOpenHelper myHelper;

    protected CidrProjectOpenProcessor(@NotNull String name, @NotNull ProjectOpenHelper helper) {
        this.myName = name;
        this.myHelper = helper;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        return null;
    }

    public boolean canOpenProject(VirtualFile file2) {
        return this.myHelper.isSupportedFile(file2);
    }

    public boolean isStrongProjectInfoHolder() {
        return true;
    }

    public void refreshProjectFiles(@NotNull File baseDir) {
        File[] projectFiles = baseDir.listFiles((dir, name) -> this.myHelper.isSupportedFile(name));
        if (projectFiles != null) {
            LocalFileSystem.getInstance().refreshIoFiles(Arrays.asList(projectFiles), false, true, null);
        }
    }
}

