/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PredefinedVariables {
    public static final String JETBRAINS_IDE = "JETBRAINS_IDE";

    @NotNull
    public static List<String> getIDEVariables() {
        ApplicationInfo applicationInfo = PredefinedVariables.getInfo();
        if (applicationInfo == null) {
            return Collections.singletonList(JETBRAINS_IDE);
        }
        String ideName = ApplicationNamesInfo.getInstance().getProductName().toUpperCase(Locale.US) + "_IDE".replaceAll("\\W", "_");
        return Collections.unmodifiableList(Arrays.asList(JETBRAINS_IDE, ideName));
    }

    @NotNull
    public static String getVersionNumber() {
        ApplicationInfo applicationInfo = PredefinedVariables.getInfo();
        Application application = ApplicationManager.getApplication();
        if (applicationInfo == null || application == null || application.isUnitTestMode()) {
            return PredefinedVariables.toVersionNumber("2017.1");
        }
        return PredefinedVariables.toVersionNumber(applicationInfo.getFullVersion());
    }

    @Nullable
    private static ApplicationInfo getInfo() {
        Application application = ApplicationManager.getApplication();
        return application == null ? null : ApplicationInfo.getInstance();
    }

    static String toVersionNumber(@NotNull String version) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(version.split("\\D")));
        while (parts.size() < 3) {
            parts.add("00");
        }
        String major = (String)parts.get(0);
        String minor = (String)parts.get(1);
        String bugfix = (String)parts.get(2);
        if (major.length() < 4) {
            major = StringUtil.repeat((String)"0", (int)(4 - major.length())) + major;
        }
        if (minor.length() < 2) {
            minor = StringUtil.repeat((String)"0", (int)(2 - minor.length())) + minor;
        }
        if (bugfix.length() < 2) {
            bugfix = StringUtil.repeat((String)"0", (int)(2 - bugfix.length())) + bugfix;
        }
        return major + minor + bugfix;
    }
}

