/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectOpenHelper<T> {
    private final Key<T> myOpenDataKey;
    private final SupportedFileChecker mySupportedFileChecker;

    public ProjectOpenHelper(@NotNull Key<T> openDataKey, @NotNull SupportedFileChecker supportedFileChecker) {
        this.myOpenDataKey = openDataKey;
        this.mySupportedFileChecker = supportedFileChecker;
    }

    public boolean isSupportedFile(@Nullable VirtualFile file2) {
        return file2 != null && this.mySupportedFileChecker.isSupportedFile(file2);
    }

    public boolean isSupportedFile(@Nullable String fileName) {
        return fileName != null && this.mySupportedFileChecker.isSupportedFile(fileName);
    }

    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data) {
        if (!this.isSupportedFile(virtualFile)) {
            return null;
        }
        this.markFileToOpen(virtualFile, data);
        VirtualFile baseDir = virtualFile.getParent();
        return PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, projectToClose, forceOpenInNewFrame);
    }

    public void markFileToOpen(@NotNull VirtualFile virtualFile, @NotNull T data) {
        VirtualFile baseDir = virtualFile.getParent();
        baseDir.putUserData(this.myOpenDataKey, data);
    }

    @Nullable
    public T getAndClearFileToOpenData(@NotNull Project project2) {
        VirtualFile baseDir = project2.getBaseDir();
        if (baseDir == null) {
            return null;
        }
        Object data = baseDir.getUserData(this.myOpenDataKey);
        baseDir.putUserData(this.myOpenDataKey, null);
        return (T)data;
    }

    public static interface SupportedFileChecker {
        public boolean isSupportedFile(@NotNull VirtualFile var1);

        public boolean isSupportedFile(@NotNull String var1);
    }
}

