/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.Version;
import com.intellij.util.VersionUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ToolVersion
extends Version {
    public final String versionString;
    public static final String UNKNOWN_VERSION = "unknown";
    public static final ToolVersion UNKNOWN = new ToolVersion("unknown", 0, 0, 0);

    public ToolVersion(int major, int minor, int bugfix) {
        this(Version.toCompactString((int)major, (int)minor, (int)bugfix), major, minor, bugfix);
    }

    public ToolVersion(String versionString, int major, int minor, int bugfix) {
        super(major, minor, bugfix);
        this.versionString = versionString;
    }

    public ToolVersion(String versionString, Version version) {
        this(versionString, version.major, version.minor, version.bugfix);
    }

    @NotNull
    public static ToolVersion parse(@NotNull String versionString, Pattern ... patterns) {
        Version version = VersionUtil.parseVersion((String)versionString, (Pattern[])patterns);
        if (version == null) {
            return UNKNOWN;
        }
        return new ToolVersion(versionString, version);
    }

    public String toString() {
        return this.versionString;
    }

    public String toCompactString() {
        if (this.isUnknown()) {
            return UNKNOWN_VERSION;
        }
        return super.toCompactString();
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ToolVersion version = (ToolVersion)((Object)o);
        return !(this.versionString != null ? !this.versionString.equals(version.versionString) : version.versionString != null);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.versionString != null ? this.versionString.hashCode() : 0);
        return result2;
    }
}

