/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.editor.OCEnterInBlockCommentHandler;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DxEnterInBlockCommentHandler
extends OCEnterInBlockCommentHandler {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        PsiFile topFile = InjectedLanguageUtil.getTopLevelFile((PsiElement)file2);
        Editor topEditor = InjectedLanguageUtil.getTopLevelEditor(editor);
        int caretOffset = topEditor.getCaretModel().getOffset();
        if (topFile == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return super.preprocessEnter(topFile, topEditor, (Ref<Integer>)Ref.create((Object)caretOffset), caretAdvanceRef, dataContext, originalHandler);
    }

    @Override
    protected boolean shouldBeProcessed(@NotNull PsiFile file2, @Nullable PsiElement psiAtOffset, int caretOffset) {
        return OCElementUtil.getElementType(psiAtOffset) == OCTokenTypes.BLOCK_COMMENT && psiAtOffset instanceof PsiComment && DoxygenUtil.isDoxygenBlockComment((PsiComment)psiAtOffset) && psiAtOffset.getTextOffset() < caretOffset;
    }

    @Override
    protected Pair<Integer, Integer> generateComment(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int caretInStringOffset, @NotNull StringBuilder result2) {
        result2.append("* ");
        Project project2 = editor.getProject();
        String tagPrefix = DxEnterInBlockCommentHandler.getTagPrefix(project2);
        PsiComment comment = DxEnterInBlockCommentHandler.findCommentAt(file2, editor, caretOffset);
        boolean needSuffix = DxEnterInBlockCommentHandler.needCommentSuffixGeneration(editor, comment, commentText, ch -> "{}".indexOf(ch.charValue()) >= 0);
        if (needSuffix) {
            result2.append(DxEnterInBlockCommentHandler.addBriefIfNeeded(project2, tagPrefix));
        }
        int newCaretPosition = caretOffset + result2.length();
        if (commentText.startsWith("/**") || commentText.startsWith("/*!")) {
            Document document = editor.getDocument();
            if (project2 != null) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
                document.insertString(caretOffset, (CharSequence)"*/");
                documentManager.commitDocument(document);
                comment = DxEnterInBlockCommentHandler.findCommentAt(file2, editor, caretOffset);
                if (!DoxygenUtil.hasNextDocCommentSibling(comment) && comment instanceof PsiDocCommentBase) {
                    PsiElement owner = ((PsiDocCommentBase)comment).getOwner();
                    String linePrefix = DxEnterInBlockCommentHandler.getIndentLine((PsiElement)comment) + "*";
                    DxEnterInBlockCommentHandler.generateDocComment(owner, linePrefix, tagPrefix, result2);
                }
                document.deleteString(caretOffset, caretOffset + 2);
                documentManager.commitDocument(document);
            }
        }
        int insertCommentSuffixPosition = -1;
        if (needSuffix) {
            insertCommentSuffixPosition = caretOffset + result2.length();
        }
        return Pair.create((Object)insertCommentSuffixPosition, (Object)newCaretPosition);
    }

    @NotNull
    public static String addBriefIfNeeded(@Nullable Project project2, @NotNull String tagPrefix) {
        if (project2 != null) {
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
            if (settings.ADD_BRIEF_TAG) {
                return tagPrefix + DoxygenCmd.BRIEF.toString() + " ";
            }
        }
        return "";
    }

    public static void generateDocComment(@Nullable PsiElement owner, @NotNull String linePrefix, @NotNull String tagPrefix, @NotNull StringBuilder result2) {
        if (owner == null) {
            return;
        }
        DoxygenUtil.traverseTemplateParametersList(owner, name -> DxEnterInBlockCommentHandler.appendLine(name, linePrefix, tagPrefix, DoxygenCmd.TPARAM, result2));
        if (owner instanceof OCCallable) {
            OCSymbol symbol;
            OCCallable callable = (OCCallable)owner;
            List<PsiNamedElement> params = callable.getParameters();
            if (params != null) {
                for (PsiNamedElement param : params) {
                    String name2 = DoxygenUtil.getName(param.getName(), param);
                    DxEnterInBlockCommentHandler.appendLine(name2, linePrefix, tagPrefix, DoxygenCmd.PARAM, result2);
                }
            }
            if ((symbol = callable.getSymbol()) != null && !symbol.getKind().isConstructorOrDestructor() && !callable.getReturnType().isVoid()) {
                result2.append("\n").append(linePrefix).append(" ").append(tagPrefix).append((Object)DoxygenCmd.RETURN).append(" ");
            }
        }
    }

    @Override
    protected void flushChanges(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int documentStartOffset, int caretInStringOffset, int insertCommentSuffixPosition, @NotNull StringBuilder indent) {
        Document document = editor.getDocument();
        PsiElement psiAtOffset = DxEnterInBlockCommentHandler.findElementAt(file2, editor, caretOffset);
        int deleteTo = DxEnterInBlockCommentHandler.countWS(commentText, caretInStringOffset);
        if (CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            document.deleteString(caretOffset, documentStartOffset + deleteTo);
        } else if (insertCommentSuffixPosition != -1) {
            insertCommentSuffixPosition += deleteTo - caretInStringOffset;
        }
        int lineEnd = commentText.indexOf(10) != -1 ? commentText.indexOf(10) : commentText.length();
        document.insertString(caretOffset, (CharSequence)indent);
        if (insertCommentSuffixPosition >= 0) {
            String contextIndent = DxEnterInBlockCommentHandler.getFirstCommentLineIndentFromContext(psiAtOffset);
            String settingIndent = DxEnterInBlockCommentHandler.customSettingsIndent(psiAtOffset);
            StringBuilder suffix = new StringBuilder().append('\n').append(contextIndent).append(settingIndent).append("*/");
            if (lineEnd > deleteTo) {
                suffix.append('\n').append(contextIndent);
            }
            document.insertString(insertCommentSuffixPosition, (CharSequence)suffix);
        }
    }

    public static int countWS(String commentText, int initValue) {
        while (initValue < commentText.length() && "\t ".indexOf(commentText.charAt(initValue)) >= 0) {
            ++initValue;
        }
        return initValue;
    }

    @Nullable
    public static PsiComment findCommentAt(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset) {
        return (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)DxEnterInBlockCommentHandler.findElementAt(file2, editor, caretOffset), (Class[])new Class[]{PsiComment.class});
    }

    @NotNull
    private static String getTagPrefix(@Nullable Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        return settings.TAG_PREFIX_OF_BLOCK_COMMENT == OCCodeStyleSettings.DocTagPrefix.AT ? "@" : "\\";
    }

    private static void appendLine(@NotNull String name, @NotNull String linePrefix, @NotNull String tagPrefix, @NotNull DoxygenCmd tag, @NotNull StringBuilder result2) {
        if (!name.equals("<unnamed>")) {
            result2.append("\n").append(linePrefix).append(" ").append(tagPrefix).append((Object)tag).append(" ").append(name).append(" ");
        }
    }
}

