/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.doxygen.DxEnterInBlockCommentHandler;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class DxEnterInLineCommentHandler
extends EnterHandlerDelegateAdapter {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        PsiElement psiAtOffset;
        int caretOffset = (Integer)caretOffsetRef.get();
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
        PsiElement element = file2.findElementAt(caretOffset);
        PsiElement psiElement = psiAtOffset = element instanceof PsiWhiteSpace ? element.getPrevSibling() : element;
        if (this.shouldBeProcessed(document, psiAtOffset, caretOffset)) {
            String text = document.getText();
            if (psiAtOffset instanceof PsiComment && DoxygenUtil.isDoxygenEOLComment((PsiComment)psiAtOffset)) {
                PsiComment comment = (PsiComment)psiAtOffset;
                String commentText = comment.getText();
                String prefix = DxEnterInBlockCommentHandler.getFirstCommentLineIndentFromContext((PsiElement)comment) + commentText.substring(0, 3);
                int caretInComment = caretOffset - comment.getTextRange().getStartOffset();
                StringBuilder result2 = new StringBuilder();
                Project project2 = editor.getProject();
                if (project2 == null) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                int newCaretPosition = caretOffset;
                if (commentText.length() == 3 && !DoxygenUtil.hasNextDocCommentSibling(comment) && comment instanceof PsiDocCommentBase) {
                    PsiElement owner = ((PsiDocCommentBase)comment).getOwner();
                    String tagPrefix = DxEnterInLineCommentHandler.getTagPrefix(project2);
                    result2.append(DxEnterInBlockCommentHandler.addBriefIfNeeded(project2, tagPrefix));
                    newCaretPosition += result2.length();
                    DxEnterInBlockCommentHandler.generateDocComment(owner, prefix, tagPrefix, result2);
                    if (result2.length() != 0) {
                        result2.insert(0, ' ');
                        ++newCaretPosition;
                    }
                } else if (DxEnterInBlockCommentHandler.countWS(commentText, caretInComment) < commentText.length()) {
                    result2.append("\n").append(prefix);
                    if (DoxygenUtil.hasArrow(comment)) {
                        result2.append("<");
                    }
                    if (text.charAt(caretOffset) != ' ') {
                        result2.append(" ");
                    } else {
                        ++newCaretPosition;
                    }
                    newCaretPosition += result2.length();
                } else {
                    return EnterHandlerDelegate.Result.Continue;
                }
                if (result2.length() == 0) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
                document.insertString(caretOffset, (CharSequence)result2.toString());
                editor.getCaretModel().moveToOffset(newCaretPosition);
                documentManager.commitDocument(document);
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected boolean shouldBeProcessed(Document document, PsiElement psiAtOffset, int caretOffset) {
        return psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset && caretOffset < document.getTextLength() && OCElementUtil.getElementType(psiAtOffset.getParent()) != OCElementTypes.PRAGMA && OCElementUtil.getElementType(PsiTreeUtil.skipSiblingsBackward((PsiElement)psiAtOffset, (Class[])new Class[]{PsiWhiteSpace.class})) != OCElementTypes.DIRECTIVE;
    }

    private static String getTagPrefix(Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        return settings.TAG_PREFIX_OF_LINE_COMMENT == OCCodeStyleSettings.DocTagPrefix.AT ? "@" : "\\";
    }
}

