/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.doxygen.DoxygenLexerAdapter;
import com.jetbrains.cidr.doxygen.DxLanguage;
import com.jetbrains.cidr.doxygen.parser.DoxygenParser;
import com.jetbrains.cidr.doxygen.psi.DxFile;
import com.jetbrains.cidr.doxygen.psi.DxTokenType;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import org.jetbrains.annotations.NotNull;

public class DxParserDefinition
implements ParserDefinition {
    public static final TokenSet WHITE_SPACES = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    private static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{new DxTokenType("FAKE_COMMENT")});
    public static final IFileElementType FILE = new IFileElementType(Language.findInstance(DxLanguage.class));

    @NotNull
    public Lexer createLexer(Project project2) {
        return new DoxygenLexerAdapter();
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WHITE_SPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public PsiParser createParser(Project project2) {
        return new DoxygenParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new DxFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        return DxTypes.Factory.createElement(node);
    }
}

